/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.MarkerGroup;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.marker.AbstractMarkerResource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.ResourceFinder;

public class MindMapResourceManager
implements IResourceManager {
    private static final String PATH_MARKERS = "markers/";
    private static final String PATH_USER_MARKERS = "markers/";
    private static final String PATH_STYLES = "styles/";
    private static final String USER_STYLES_TEMP_LOCATION = "styles/userStyles";
    private static final String USER_THEME_TEMP_LOCATION = "styles/userThemes";
    private static final String MARKER_SHEET_XML = "markerSheet.xml";
    private static final String MARKER_SHEET = "markerSheet";
    private static final String DEFAULT_STYLES_XML = "defaultStyles.xml";
    private static final String STYLES_XML = "styles.xml";
    private static final String THEMES_XML = "themes.xml";
    private static final String STYLES = "styles";
    private static final String THEMES = "themes";
    private static final String EXT_PROPERTIES = ".properties";
    private IMarkerSheet systemMarkerSheet = null;
    private IMarkerSheet userMarkerSheet = null;
    private IMarkerGroup recentMarkerGroup = null;
    private IStyleSheet defaultStyleSheet = null;
    private IStyleSheet systemStyleSheet = null;
    private IWorkbook userStylesContainer = null;
    private IStyle defaultTheme = null;
    private IStyleSheet systemThemeSheet = null;
    private IWorkbook userThemesContainer = null;

    public IMarkerSheet getSystemMarkerSheet() {
        if (this.systemMarkerSheet == null) {
            this.systemMarkerSheet = this.createSystemMarkerShet();
        }
        return this.systemMarkerSheet;
    }

    private IMarkerSheet createSystemMarkerShet() {
        URL url = MindMapResourceManager.find("markers/", MARKER_SHEET_XML);
        if (url != null) {
            try {
                IMarkerSheet sheet;
                block12: {
                    sheet = Core.getMarkerSheetBuilder().loadFromURL(url, (IMarkerResourceProvider)new SystemMarkerResourceProvider());
                    URL propUrl = MindMapResourceManager.find("markers/", MARKER_SHEET, EXT_PROPERTIES);
                    if (propUrl != null) {
                        try {
                            InputStream propStream = propUrl.openStream();
                            if (propStream == null) break block12;
                            try {
                                Core.getMarkerSheetBuilder().loadProperties(propStream, sheet);
                            }
                            catch (Throwable throwable) {
                                try {
                                    propStream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                propStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (Exception e) {
                            Logger.log(e, "Failed to load system marker properties: " + propUrl);
                        }
                    }
                }
                return sheet;
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load system marker from: " + url);
            }
        }
        return Core.getMarkerSheetBuilder().createMarkerSheet((IMarkerResourceProvider)new SystemMarkerResourceProvider());
    }

    public IMarkerSheet getUserMarkerSheet() {
        if (this.userMarkerSheet == null) {
            this.userMarkerSheet = this.createUserMarkerSheet();
            this.initUserMarkerSheet(this.userMarkerSheet);
        }
        return this.userMarkerSheet;
    }

    public void saveUserMarkerSheet() {
        if (this.userMarkerSheet != null) {
            String path = Core.getWorkspace().getAbsolutePath("markers/markerSheet.xml");
            File file = FileUtils.ensureFileParent((File)new File(path));
            try {
                this.userMarkerSheet.save((OutputStream)new FileOutputStream(file));
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    private void initUserMarkerSheet(IMarkerSheet sheet) {
        sheet.setParentSheet(this.getSystemMarkerSheet());
    }

    private IMarkerSheet createUserMarkerSheet() {
        File file;
        String path = Core.getWorkspace().getAbsolutePath("markers/markerSheet.xml");
        if (path != null && (file = new File(path)).exists()) {
            try {
                return Core.getMarkerSheetBuilder().loadFromFile(file, (IMarkerResourceProvider)new UserMarkerResourceProvider());
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load user marker from: " + file);
            }
        }
        return Core.getMarkerSheetBuilder().createMarkerSheet((IMarkerResourceProvider)new UserMarkerResourceProvider());
    }

    public IMarkerGroup getRecentMarkerGroup() {
        if (this.recentMarkerGroup == null) {
            this.recentMarkerGroup = new RecentMarkerGroup();
        }
        return this.recentMarkerGroup;
    }

    public IStyleSheet getDefaultStyleSheet() {
        if (this.defaultStyleSheet == null) {
            this.defaultStyleSheet = this.createDefaultStyleSheet();
        }
        return this.defaultStyleSheet;
    }

    private IStyleSheet createDefaultStyleSheet() {
        URL url = MindMapResourceManager.find(PATH_STYLES, DEFAULT_STYLES_XML);
        if (url != null) {
            try {
                return Core.getStyleSheetBuilder().loadFromUrl(url);
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load default styles: " + url);
            }
        }
        return Core.getStyleSheetBuilder().createStyleSheet();
    }

    public IStyleSheet getSystemStyleSheet() {
        if (this.systemStyleSheet == null) {
            this.systemStyleSheet = this.createSystemStyleSheet();
        }
        return this.systemStyleSheet;
    }

    private IStyleSheet createSystemStyleSheet() {
        URL url = MindMapResourceManager.find(PATH_STYLES, STYLES_XML);
        if (url != null) {
            try {
                IStyleSheet sheet;
                block12: {
                    sheet = Core.getStyleSheetBuilder().loadFromUrl(url);
                    URL propUrl = MindMapResourceManager.find(PATH_STYLES, STYLES, EXT_PROPERTIES);
                    if (propUrl != null) {
                        try {
                            InputStream propStream = propUrl.openStream();
                            if (propStream == null) break block12;
                            try {
                                Core.getStyleSheetBuilder().loadProperties(propStream, sheet);
                            }
                            catch (Throwable throwable) {
                                try {
                                    propStream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                propStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (Exception e) {
                            Logger.log(e, "Failed to load saved style properties: " + propUrl);
                        }
                    }
                }
                return sheet;
            }
            catch (Exception e) {
                Logger.log(e, "Falied to load saved styles: " + url);
            }
        }
        return Core.getStyleSheetBuilder().createStyleSheet();
    }

    public IStyleSheet getUserStyleSheet() {
        if (this.userStylesContainer == null) {
            this.userStylesContainer = this.createUserStylesContainer();
        }
        return this.userStylesContainer.getStyleSheet();
    }

    private IWorkbook createUserStylesContainer() {
        IWorkbook stylesContainer = null;
        String path = Core.getWorkspace().getAbsolutePath(USER_STYLES_TEMP_LOCATION);
        File file = new File(path);
        if (file.exists() && file.isDirectory() && new File(file, "content.xml").exists()) {
            try {
                stylesContainer = Core.getWorkbookBuilder().loadFromTempLocation(path);
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load user styles from: " + file);
            }
        }
        if (stylesContainer == null) {
            FileUtils.ensureDirectory((File)file);
            stylesContainer = Core.getWorkbookBuilder().createWorkbook();
            stylesContainer.setTempLocation(path);
        }
        return stylesContainer;
    }

    public void saveUserStyleSheet() {
        if (this.userStylesContainer != null) {
            try {
                this.userStylesContainer.saveTemp();
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    public IStyle getDefaultTheme() {
        if (this.defaultTheme == null) {
            this.defaultTheme = Core.getStyleSheetBuilder().createStyleSheet().createStyle("theme");
            this.defaultTheme.setName(MindMapMessages.DefaultTheme_title);
        }
        return this.defaultTheme;
    }

    public IStyleSheet getSystemThemeSheet() {
        if (this.systemThemeSheet == null) {
            this.systemThemeSheet = this.createSystemThemeSheet();
        }
        return this.systemThemeSheet;
    }

    private IStyleSheet createSystemThemeSheet() {
        URL url = MindMapResourceManager.find(PATH_STYLES, THEMES_XML);
        if (url != null) {
            try {
                IStyleSheet sheet;
                block12: {
                    sheet = Core.getStyleSheetBuilder().loadFromUrl(url);
                    URL propUrl = MindMapResourceManager.find(PATH_STYLES, THEMES, EXT_PROPERTIES);
                    if (propUrl != null) {
                        try {
                            InputStream propStream = propUrl.openStream();
                            if (propStream == null) break block12;
                            try {
                                Core.getStyleSheetBuilder().loadProperties(propStream, sheet);
                            }
                            catch (Throwable throwable) {
                                try {
                                    propStream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                propStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (Exception e) {
                            Logger.log(e, "Failed to load theme properties: " + propUrl);
                        }
                    }
                }
                return sheet;
            }
            catch (Exception e) {
                Logger.log(e, "Falied to load system themes: " + url);
            }
        }
        return Core.getStyleSheetBuilder().createStyleSheet();
    }

    public IStyleSheet getUserThemeSheet() {
        if (this.userThemesContainer == null) {
            this.userThemesContainer = this.createUserThemeContainer();
        }
        return this.userThemesContainer.getStyleSheet();
    }

    private IWorkbook createUserThemeContainer() {
        IWorkbook stylesContainer = null;
        String path = Core.getWorkspace().getAbsolutePath(USER_THEME_TEMP_LOCATION);
        File file = new File(path);
        if (file.exists() && file.isDirectory() && new File(file, "content.xml").exists()) {
            try {
                stylesContainer = Core.getWorkbookBuilder().loadFromTempLocation(path);
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load user themes from: " + file);
            }
        }
        if (stylesContainer == null) {
            FileUtils.ensureDirectory((File)file);
            stylesContainer = Core.getWorkbookBuilder().createWorkbook();
            stylesContainer.setTempLocation(path);
        }
        return stylesContainer;
    }

    public void saveUserThemeSheet() {
        if (this.userThemesContainer != null) {
            try {
                this.userThemesContainer.saveTemp();
            }
            catch (Exception exception) {}
        }
    }

    private static URL find(String fullPath) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        if (bundle != null) {
            return FileLocator.find((Bundle)bundle, (IPath)new Path(fullPath), null);
        }
        return null;
    }

    private static URL find(String mainPath, String subPath) {
        return MindMapResourceManager.find(String.valueOf(mainPath) + subPath);
    }

    private static URL find(String mainPath, String prefix, String suffix) {
        return ResourceFinder.findResource("org.xmind.ui", mainPath, prefix, suffix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecentMarkerGroup
    extends MarkerGroup
    implements ICoreEventSource {
        public static final RecentMarkerGroup instance = new RecentMarkerGroup();
        private static final int CAPACITY = 6;
        private List<IMarker> markers = new ArrayList<IMarker>(6);
        private ICoreEventSupport eventSupport = new CoreEventSupport();

        private RecentMarkerGroup() {
        }

        /*
         * Unable to fully structure code
         */
        public void addMarker(IMarker marker) {
            if (!this.markers.contains(marker)) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                this.markers.remove(this.markers.size() - 1);
lbl5:
                // 2 sources

                ** while (this.markers.size() >= 6)
            }
lbl6:
            // 1 sources

            this.markers.add(0, marker);
            this.eventSupport.dispatchTargetChange((ICoreEventSource)this, "markerAdd", (Object)marker);
        }

        public List<IMarker> getMarkers() {
            return this.markers;
        }

        public String getName() {
            return MindMapMessages.RecentUsed;
        }

        public void setSingleton(boolean singleton) {
        }

        public IMarkerSheet getOwnedSheet() {
            return null;
        }

        public IMarkerSheet getParent() {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }

        public void removeMarker(IMarker marker) {
        }

        public void setName(String name) {
        }

        public String getId() {
            return "org.xmind.ui.RecentMarkerGroup";
        }

        public Object getRegisterKey() {
            return this.getId();
        }

        public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
            return this.eventSupport.registerCoreEventListener((ICoreEventSource)this, type, listener);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public ICoreEventSupport getCoreEventSupport() {
            return this.eventSupport;
        }
    }

    private static class SystemMarkerResource
    extends AbstractMarkerResource {
        public SystemMarkerResource(IMarker marker) {
            super(marker, "markers/");
        }

        public InputStream getInputStream() {
            URL url = this.getURL();
            if (url == null) {
                return null;
            }
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public OutputStream getOutputStream() {
            return null;
        }

        private URL getURL() {
            return MindMapResourceManager.find(this.getFullPath());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof SystemMarkerResource)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    private static class SystemMarkerResourceProvider
    implements IMarkerResourceProvider {
        private SystemMarkerResourceProvider() {
        }

        public IMarkerResource getMarkerResource(IMarker marker) {
            return new SystemMarkerResource(marker);
        }

        public boolean isPermanent() {
            return true;
        }
    }

    private static class UserMarkerResource
    extends AbstractMarkerResource {
        public UserMarkerResource(IMarker marker) {
            super(marker, "markers/");
        }

        private File getFile() {
            String path = Core.getWorkspace().getAbsolutePath(this.getFullPath());
            if (path == null) {
                return null;
            }
            return new File(path);
        }

        public InputStream getInputStream() {
            File file = this.getFile();
            if (file != null) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }

        public OutputStream getOutputStream() {
            File file = FileUtils.ensureFileParent((File)this.getFile());
            if (file != null) {
                try {
                    return new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof UserMarkerResource)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    private static class UserMarkerResourceProvider
    implements IMarkerResourceProvider {
        private UserMarkerResourceProvider() {
        }

        public IMarkerResource getMarkerResource(IMarker marker) {
            return new UserMarkerResource(marker);
        }

        public boolean isPermanent() {
            return false;
        }
    }
}

