/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.xmind.core.CoreException;
import org.xmind.core.IChecksumStream;
import org.xmind.core.internal.security.Base64;

public class ChecksumOutputStream
extends FilterOutputStream
implements IChecksumStream {
    private Digest digest = new MD5Digest();

    public ChecksumOutputStream(OutputStream output) throws CoreException {
        super(output);
    }

    public void write(int b) throws IOException {
        this.digest.update((byte)b);
        super.write(b);
    }

    public String getChecksum() {
        byte[] by = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(by, 0);
        return Base64.byteArrayToBase64(by);
    }
}

