/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.xmind.core.Core;
import org.xmind.core.internal.DefaultLogger;
import org.xmind.core.internal.InternalCore;
import org.xmind.core.internal.security.BouncyCastleSecurityProvider;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.internal.security.ISecurityProvider;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.ILogger;

public class XmindCore
extends Plugin {
    public static final String PLUGIN_ID = "org.xmind.core.runtime";
    private static XmindCore plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        InternalCore.getInstance().setLogger((ILogger)new DefaultLogger());
        String workspacePath = this.findWorkspacePath();
        String path = new File(workspacePath, ".xmind").getAbsolutePath();
        Core.getWorkspace().setWorkingDirectory(path);
        Crypto.setProvider((ISecurityProvider)new BouncyCastleSecurityProvider());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        FileUtils.delete((File)new File(Core.getWorkspace().getTempDir()));
    }

    public static XmindCore getDefault() {
        return plugin;
    }

    private String findWorkspacePath() {
        URL url = Platform.getInstanceLocation().getURL();
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {}
        String file = url.getFile();
        if (file != null && !"".equals(file)) {
            return file;
        }
        return url.toExternalForm();
    }
}

