/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tools;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.spellsupport.SpellingSupport;
import org.xmind.ui.texteditor.FloatingTextEditTool;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IControlContentAdapter2;
import org.xmind.ui.texteditor.StyledTextContentAdapter;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapEditToolBase
extends FloatingTextEditTool {
    private boolean finishedOnMouseDown = false;
    private String oldText = null;

    public MindMapEditToolBase() {
        this.setContextId("org.xmind.ui.context.mindmap.textEdit");
    }

    protected IDocument getTextContents(IPart source) {
        this.oldText = this.getInitialText(source);
        return this.oldText == null ? null : new Document(this.oldText);
    }

    protected void hookEditorControl(FloatingTextEditor editor, ITextViewer textViewer) {
        super.hookEditorControl(editor, textViewer);
        StyledTextContentAdapter adapter = new StyledTextContentAdapter();
        SpellingSupport.getInstance().install(textViewer, (IControlContentAdapter2)adapter);
    }

    protected abstract String getInitialText(IPart var1);

    protected void handleTextModified(IPart source, IDocument document) {
        Request request;
        if (this.finishedOnMouseDown) {
            this.finishedOnMouseDown = false;
            if (this.shouldIgnoreTextChange(source, document, this.oldText)) {
                return;
            }
        }
        if ((request = this.createTextRequest(source, document)) != null) {
            this.internalHandleRequest(request);
        }
    }

    protected boolean shouldIgnoreTextChange(IPart source, IDocument document, String oldText) {
        return document.get().equals(oldText);
    }

    protected abstract Request createTextRequest(IPart var1, IDocument var2);

    protected String getRedoLabel() {
        return CommandMessages.Command_Typing;
    }

    protected String getUndoLabel() {
        return CommandMessages.Command_Typing;
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        if (ke != null && this.getEditor() != null && (MindMapUtils.isTopicTextChar(ke.character) || ke.keyCode == 229 && ke.isImeOpened)) {
            this.getEditor().replaceText(Character.toString(ke.character));
            return true;
        }
        return super.handleKeyDown(ke);
    }

    protected boolean shouldFinishOnMouseDown(MouseEvent me) {
        boolean toFinish = super.shouldFinishOnMouseDown(me);
        if (toFinish) {
            this.finishedOnMouseDown = true;
        }
        return toFinish;
    }
}

