/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.tool.MoveTool;

public abstract class DummyMoveTool
extends MoveTool {
    private IFigure dummy = null;
    private Point dummyStartLoc = null;

    protected void start() {
        if (this.createsDummyOnActivated()) {
            this.doCreateDummy();
        }
    }

    protected boolean createsDummyOnActivated() {
        return true;
    }

    protected boolean usesRelativeLocation() {
        return true;
    }

    public IFigure getDummy() {
        return this.dummy;
    }

    protected void doCreateDummy() {
        if (this.dummy != null) {
            return;
        }
        if (!this.getStatus().isStatus(1)) {
            return;
        }
        this.dummy = this.createDummy();
    }

    protected abstract IFigure createDummy();

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        this.updateDummyPosition(currentPos);
    }

    protected void updateDummyPosition(Point pos) {
        IFigure fig = this.getDummy();
        if (fig != null) {
            Point cursorStart = this.getStartingPosition();
            Point dummyStart = this.getDummyStartLoc();
            if (this.usesRelativeLocation() && cursorStart != null && dummyStart != null) {
                int x = pos.x - cursorStart.x + dummyStart.x;
                int y = pos.y - cursorStart.y + dummyStart.y;
                if (fig instanceof IReferencedFigure) {
                    ((IReferencedFigure)fig).setReference(x, y);
                } else {
                    fig.setLocation(new Point(x, y));
                }
            } else if (fig instanceof IReferencedFigure) {
                ((IReferencedFigure)fig).setReference(pos);
            } else {
                fig.setLocation(pos);
            }
        }
    }

    protected Point getDummyStartLoc() {
        IFigure fig;
        if (this.dummyStartLoc == null && (fig = this.getDummy()) != null) {
            this.dummyStartLoc = fig instanceof IReferencedFigure ? ((IReferencedFigure)fig).getReference() : fig.getBounds().getLocation();
        }
        return this.dummyStartLoc;
    }

    public void finish() {
        Request request = this.createRequest();
        super.finish();
        if (request != null) {
            this.internalHandleRequest(request);
        }
    }

    protected abstract Request createRequest();

    protected void end() {
        this.destroyDummy();
        this.dummyStartLoc = null;
        super.end();
    }

    protected void destroyDummy() {
        if (this.dummy != null) {
            this.destroyDummy(this.dummy);
            this.dummy = null;
        }
    }

    protected void destroyDummy(IFigure dummy) {
        if (dummy.getParent() != null) {
            dummy.getParent().remove(dummy);
        }
    }
}

