/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.image.FigureImageDescriptor;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.util.Properties;
import org.xmind.ui.mindmap.MindMapExportContentProvider;
import org.xmind.ui.util.Logger;

public class MindMapImageExtractor {
    private static final int DEFAULT_MARGIN = 15;
    private Display display;
    private Composite parent;
    private ISheet sheet;
    private ITopic centralTopic;
    private Properties properties;
    private Image image;
    private int margin = -1;
    private Point origin;
    private int resizeStrategy = 0;
    private int widthHint = -1;
    private int heightHint = -1;

    public MindMapImageExtractor(Composite parent, ISheet sheet, ITopic centralTopic) {
        this(parent.getDisplay(), parent, sheet, centralTopic);
    }

    public MindMapImageExtractor(Display display, ISheet sheet, ITopic centralTopic) {
        this(display, null, sheet, centralTopic);
    }

    private MindMapImageExtractor(Display display, Composite parent, ISheet sheet, ITopic centralTopic) {
        this.display = display;
        this.parent = parent;
        this.sheet = sheet;
        this.centralTopic = centralTopic;
        this.setProperty("centered", Boolean.TRUE);
        this.setProperty("cornered", Boolean.TRUE);
        this.setProperty("margin", 15);
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.set(key, value);
    }

    public Image getImage() {
        if (this.image == null) {
            if (Thread.currentThread() != this.display.getThread()) {
                this.display.syncExec(new Runnable(){

                    public void run() {
                        MindMapImageExtractor.this.image = MindMapImageExtractor.this.createImage();
                    }
                });
            } else {
                this.image = this.createImage();
            }
        }
        return this.image;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setResizeStrategy(int resizeStrategy, int widthHint, int heightHint) {
        this.resizeStrategy = resizeStrategy;
        this.widthHint = widthHint;
        this.heightHint = heightHint;
    }

    public int getResizeStrategy() {
        return this.resizeStrategy;
    }

    public int getWidthHint() {
        return this.widthHint;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    private Image createImage() {
        Image image;
        block5: {
            MindMapExportContentProvider provider = this.parent != null ? new MindMapExportContentProvider(this.parent, this.sheet, this.centralTopic) : new MindMapExportContentProvider(this.display, this.sheet, this.centralTopic);
            provider.setProperties(this.properties);
            provider.setMargin(this.margin);
            provider.setResizeStrategy(this.resizeStrategy, this.widthHint, this.heightHint);
            try {
                try {
                    image = FigureImageDescriptor.createFromFigure((IFigure)provider.getContents(), (IExportAreaProvider)provider).createImage(false, (Device)this.display);
                    this.origin = provider.getOrigin();
                }
                catch (Throwable e) {
                    image = null;
                    Logger.log(e);
                    this.display.asyncExec(new Runnable(provider){
                        private final /* synthetic */ MindMapExportContentProvider val$provider;
                        {
                            this.val$provider = mindMapExportContentProvider;
                        }

                        public void run() {
                            this.val$provider.dispose();
                        }
                    });
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            this.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
        }
        return image;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }
}

