/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.xmind.core.Core;
import org.xmind.core.ICloneData;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapExtractor {
    private static final String SUBDIR_EXPORT = "export";
    private static String DefaultDirectory = null;
    private ISheet sourceSheet;
    private ITopic sourceTopic;
    private Collection<IRelationship> sourceRels;
    private IWorkbook result;
    private String tempLocation;

    public MindMapExtractor(IMindMapViewer viewer) {
        this(viewer, MindMapExtractor.newTempLocation());
    }

    public MindMapExtractor(IMindMapViewer viewer, String tempLocation) {
        this.sourceSheet = viewer.getSheet();
        this.sourceTopic = viewer.getCentralTopic();
        List<IRelationshipPart> relParts = viewer.getSheetPart().getRelationships();
        this.sourceRels = new ArrayList<IRelationship>(relParts.size());
        for (IRelationshipPart relPart : relParts) {
            this.sourceRels.add(relPart.getRelationship());
        }
        this.tempLocation = tempLocation;
    }

    public IWorkbook extract() {
        if (this.result == null) {
            this.result = Core.getWorkbookBuilder().createWorkbook();
            this.result.getMarkerSheet().setParentSheet(MindMapUI.getResourceManager().getUserMarkerSheet());
            this.result.setTempLocation(this.tempLocation);
            ICloneData cloneResult = this.result.clone((Collection)Arrays.asList(this.sourceSheet));
            ISheet newSheet = (ISheet)cloneResult.get((Object)this.sourceSheet);
            this.result.addSheet(newSheet);
            this.result.removeSheet(this.result.getPrimarySheet());
            String newTopicId = (String)cloneResult.get((Object)this.sourceTopic.getId());
            ITopic newRootTopic = this.result.findTopic(newTopicId);
            newSheet.replaceRootTopic(newRootTopic);
            HashSet<String> newRelIds = new HashSet<String>(this.sourceRels.size());
            for (IRelationship sr : this.sourceRels) {
                String newRelId = (String)cloneResult.get((Object)sr.getId());
                if (newRelId == null) continue;
                newRelIds.add(newRelId);
            }
            HashSet newRels = new HashSet(newSheet.getRelationships());
            for (IRelationship r : newRels) {
                if (newRelIds.contains(r.getId())) continue;
                newSheet.removeRelationship(r);
            }
        }
        return this.result;
    }

    public void delete() {
        FileUtils.delete((File)new File(this.tempLocation));
    }

    private static String newTempLocation() {
        if (DefaultDirectory == null) {
            DefaultDirectory = Core.getWorkspace().getTempDir(SUBDIR_EXPORT);
        }
        String fileName = String.valueOf(Core.getIdFactory().createId()) + ".xmind.temp";
        return new File(DefaultDirectory, fileName).getAbsolutePath();
    }
}

