/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMap;

public class MindMapExportContentProvider
implements IExportAreaProvider {
    private static final int DEFAULT_MARGIN = 15;
    private Display display;
    private Composite parent;
    private IMindMap source;
    private Properties properties;
    private int margin = -1;
    private Point origin;
    private IExportAreaProvider delegate = null;
    private Shell shell;
    private Control control;
    private IFigure contents;
    private IMindMapViewer viewer;
    private int resizeStrategy = 0;
    private int widthHint = -1;
    private int heightHint = -1;

    public MindMapExportContentProvider(Composite parent, IMindMap source) {
        this(parent.getDisplay(), parent, source);
    }

    public MindMapExportContentProvider(Display display, IMindMap source) {
        this(display, null, source);
    }

    public MindMapExportContentProvider(Composite parent, ISheet sheet, ITopic centralTopic) {
        this(parent.getDisplay(), parent, new MindMap(sheet, centralTopic));
    }

    public MindMapExportContentProvider(Display display, ISheet sheet, ITopic centralTopic) {
        this(display, null, new MindMap(sheet, centralTopic));
    }

    private MindMapExportContentProvider(Display display, Composite parent, IMindMap source) {
        this.display = display;
        this.parent = parent;
        this.source = source;
        this.setProperty("centered", Boolean.TRUE);
        this.setProperty("cornered", Boolean.TRUE);
        this.setProperty("margin", 15);
    }

    public void setResizeStrategy(int resizeStrategy, int widthHint, int heightHint) {
        this.resizeStrategy = resizeStrategy;
        this.widthHint = widthHint;
        this.heightHint = heightHint;
    }

    public int getResizeStrategy() {
        return this.resizeStrategy;
    }

    public int getWidthHint() {
        return this.widthHint;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.set(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public Rectangle getExportArea() {
        return this.getDelegate().getExportArea();
    }

    private IExportAreaProvider getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
        return this.delegate;
    }

    private IExportAreaProvider createDelegate() {
        Composite container = this.getContainer();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        MindMapViewer viewer = new MindMapViewer();
        this.viewer = viewer;
        viewer.setProperties(this.properties);
        viewer.createControl(container);
        this.control = viewer.getControl();
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setInput(this.source);
        if (container != this.parent && container instanceof Shell) {
            container.setBounds(-300, -300, 180, 180);
            container.setVisible(true);
        }
        container.layout();
        viewer.getCanvas().getLightweightSystem().getUpdateManager().performValidation();
        this.contents = this.getPaintingContents(viewer);
        IFigure boundsContents = this.getBoundsContents(this.contents, viewer);
        Rectangle bounds = this.calcContentsBounds(boundsContents, viewer);
        int margin = this.getMargin();
        Point realOrigin = this.getOrigin(boundsContents);
        this.origin = new Point(realOrigin.x - bounds.x + margin, realOrigin.y - bounds.y + margin);
        return ImageExportUtils.createExportAreaProvider((IFigure)this.contents, (Rectangle)bounds, (int)this.resizeStrategy, (int)this.widthHint, (int)this.heightHint, (Insets)new Insets(margin));
    }

    public IMindMapViewer getViewer() {
        this.getDelegate();
        return this.viewer;
    }

    public IFigure getContents() {
        this.getDelegate();
        return this.contents;
    }

    public double getScale() {
        return this.getDelegate().getScale();
    }

    private Composite getContainer() {
        if (this.parent != null && !this.parent.isDisposed() && !(this.parent instanceof Shell)) {
            return this.parent;
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            return this.shell;
        }
        this.shell = new Shell(this.display, 8);
        return this.shell;
    }

    public Point getOrigin() {
        return this.origin;
    }

    private int getMargin() {
        Object margin;
        if (this.margin >= 0) {
            return this.margin;
        }
        if (this.properties != null && (margin = this.properties.get("margin")) instanceof Integer) {
            return (Integer)margin;
        }
        return 0;
    }

    protected IFigure getPaintingContents(IGraphicalViewer viewer) {
        IFigure contents = viewer.getCanvas().getViewport().getContents();
        if (contents != null) {
            return contents;
        }
        return viewer.getCanvas().getLightweightSystem().getRootFigure();
    }

    protected IFigure getBoundsContents(IFigure paintingContents, IGraphicalViewer viewer) {
        IPart contentsPart = viewer.getRootPart().getContents();
        if (contentsPart instanceof IGraphicalPart && contentsPart.getStatus().isActive()) {
            return ((IGraphicalPart)contentsPart).getFigure();
        }
        return paintingContents;
    }

    protected Rectangle calcContentsBounds(IFigure contents, IGraphicalViewer viewer) {
        if (contents instanceof FreeformFigure) {
            return ((FreeformFigure)contents).getFreeformExtent().getCopy();
        }
        return contents.getBounds().getCopy();
    }

    protected Point getOrigin(IFigure figure) {
        if (figure instanceof IOriginBased) {
            return ((IOriginBased)figure).getOrigin();
        }
        if (figure instanceof IReferencedFigure) {
            return ((IReferencedFigure)figure).getReference();
        }
        return new Point();
    }

    public void dispose() {
        if (this.control != null) {
            this.control.dispose();
            this.control = null;
        }
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
    }
}

