/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.internal.wizards.XMind2008Exporter;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class XMind2008ExportWizard
extends AbstractMindMapExportWizard {
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.xmind2008";
    private static final String PAGE_NAME = "htmlExportPage";
    private static final String FILE_EXT = ".xmap";
    private static final String FILTER = "*.xmap";
    private IWorkbook sourceWorkbook;
    private XMind2008ExportPage page;

    public XMind2008ExportWizard() {
        this.setWindowTitle(WizardMessages.XMind2008ExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
    }

    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        super.setSourceEditor(sourceEditor);
        this.sourceWorkbook = this.findWorkbook(sourceEditor);
    }

    public boolean hasSource() {
        return this.getSourceEditor() != null && this.sourceWorkbook != null;
    }

    private IWorkbook findWorkbook(IGraphicalEditor editor) {
        if (editor == null) {
            return null;
        }
        return (IWorkbook)editor.getAdapter(IWorkbook.class);
    }

    protected void addValidPages() {
        this.page = new XMind2008ExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    protected String getFormatName() {
        return WizardMessages.XMind2008ExportWizard_formatName;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        XMind2008Exporter exporter = new XMind2008Exporter(this.sourceWorkbook, this.getTargetPath());
        exporter.setMonitor(monitor);
        exporter.export();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XMind2008ExportPage
    extends AbstractExportPage {
        public XMind2008ExportPage() {
            super(XMind2008ExportWizard.PAGE_NAME, WizardMessages.XMind2008ExportPage_title, null);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.updateStatus();
        }

        @Override
        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, WizardMessages.XMind2008ExportPage_filterName);
            filterExtensions.add(0, XMind2008ExportWizard.FILTER);
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        @Override
        protected String getSuggestedFileName() {
            String file = XMind2008ExportWizard.this.sourceWorkbook.getFile();
            if (file == null) {
                file = XMind2008ExportWizard.this.getSourceEditor().getTitle();
            }
            return String.valueOf(FileUtils.getNoExtensionFileName((String)new File(file).getName())) + XMind2008ExportWizard.FILE_EXT;
        }
    }
}

