/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.wizards.MarkerGroupContentProvider;
import org.xmind.ui.internal.wizards.MarkerGroupLabelProvider;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.wizards.AbstractExportWizard;

public class MarkerExportWizard
extends AbstractExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.MarkerExportWizardPage";
    private static final String SECTION_NAME = "org.xmind.ui.markerExportWizard";
    private MarkerExportWizardPage page;

    public MarkerExportWizard() {
        this.setWindowTitle(WizardMessages.MarkerExportWizard_windowTitle);
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(SECTION_NAME));
    }

    public void addPages() {
        this.page = new MarkerExportWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        List<IMarkerGroup> selection;
        if (this.hasTargetPath() && !(selection = this.page.getSelection()).isEmpty()) {
            final boolean[] b = new boolean[1];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    MarkerImpExpUtils.exportMarkerPackage(selection, MarkerExportWizard.this.getTargetPath(), true);
                    String dir = new File(MarkerExportWizard.this.getTargetPath()).getParent();
                    Program.launch((String)dir);
                    b[0] = true;
                }

                public void handleException(Throwable e) {
                    b[0] = false;
                    super.handleException(e);
                }
            });
            return b[0];
        }
        return false;
    }

    protected boolean hasSource() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MarkerExportWizardPage
    extends AbstractExportPage {
        private TableViewer viewer;

        protected MarkerExportWizardPage() {
            super(MarkerExportWizard.PAGE_NAME, WizardMessages.MarkerExportPage_title, null);
            this.setDescription(WizardMessages.MarkerExportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            this.setControl((Control)composite);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(WizardMessages.MarkerExportPage_ChooseMarkerGroups_label);
            this.viewer = new TableViewer(composite, 67586);
            this.viewer.setContentProvider((IContentProvider)new MarkerGroupContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new MarkerGroupLabelProvider());
            this.viewer.setInput((Object)MindMapUI.getResourceManager().getUserMarkerSheet());
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            Control fileControl = this.createFileControls(composite);
            fileControl.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        @Override
        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.clear();
            String ext = "*.xmp";
            filterNames.add(NLS.bind((String)"{0} ({1})", (Object)DialogMessages.MarkerPackageFilterName, (Object)ext));
            filterExtensions.clear();
            filterExtensions.add(ext);
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        @Override
        protected String getSuggestedFileName() {
            return "Package.xmp";
        }

        public List<IMarkerGroup> getSelection() {
            ArrayList<IMarkerGroup> list = new ArrayList<IMarkerGroup>();
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                for (Object o : ((IStructuredSelection)selection).toList()) {
                    if (!(o instanceof IMarkerGroup)) continue;
                    list.add((IMarkerGroup)o);
                }
            }
            return list;
        }
    }
}

