/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.FreeMindExporter;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class FreeMindExportWizard
extends AbstractMindMapExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.freemindeExportWizard";
    private static final String SECTION_NAME = "org.xmind.ui.export.freemind";
    private static final String FILE_TEXT = ".mm";
    private FreeMindExportWizardPage page;

    public FreeMindExportWizard() {
        this.setWindowTitle(WizardMessages.FreeMindWizard_windowTitle);
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected void addValidPages() {
        this.page = new FreeMindExportWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        IMindMap mindMap = this.getSourceMindMap();
        FreeMindExporter exporter = new FreeMindExporter(mindMap.getSheet(), this.getTargetPath());
        monitor.beginTask(null, 100);
        exporter.setMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 99));
        exporter.build();
    }

    protected String getFormatName() {
        return WizardMessages.FreeMindWizard_formatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && FILE_TEXT.equalsIgnoreCase(extension);
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FreeMindExportWizardPage
    extends AbstractExportPage {
        protected FreeMindExportWizardPage() {
            super(FreeMindExportWizard.PAGE_NAME, WizardMessages.FreeMindPage_title, null);
            this.setDescription(WizardMessages.FreeMindPage_description);
        }

        @Override
        protected String getSuggestedFileName() {
            IMindMap mindMap = this.getCastedWizard().getSourceMindMap();
            String fileName = mindMap.getCentralTopic().getTitleText();
            return String.valueOf(fileName) + FreeMindExportWizard.FILE_TEXT;
        }

        @Override
        protected FreeMindExportWizard getCastedWizard() {
            return (FreeMindExportWizard)super.getCastedWizard();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.updateStatus();
        }

        @Override
        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, WizardMessages.FreeMindPage_filterName);
            filterExtensions.add(0, "*.mm");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

