/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPointPair;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.GradientPattern;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;

public class StyleFigureUtils {
    public static final int BOUNDARY_STEP = 16;
    public static final int BOUNDARY_PADDING = 8;
    public static final float CALLOUT_RRECT_PARAM = 0.2f;
    public static final float CALLOUT_ELLIPSE_STARTANGLE = -130.0f;
    public static final float CALLOUT_ELLIPSE_ARCANGLE = 345.0f;
    public static final int SPINY_WIDTH = 2;
    public static final int ROUNDED_CORNER = 7;
    public static final int ROUNDED_CORNER_ADAPTER = 30;
    private static final IStyleSheet defaultStyles = MindMapUI.getResourceManager().getDefaultStyleSheet();
    public static final IStyle defaultSheetStyle = StyleFigureUtils.findOrCreateDefaultStyle("map", "map");
    public static final IStyle defaultCentralStyle = StyleFigureUtils.findOrCreateDefaultStyle("centralTopic", "topic");
    public static final IStyle defaultMainStyle = StyleFigureUtils.findOrCreateDefaultStyle("mainTopic", "topic");

    private StyleFigureUtils() {
    }

    private static IStyle findOrCreateDefaultStyle(String family, String type) {
        IStyle style = defaultStyles.findStyle(family);
        if (style == null) {
            style = defaultStyles.createStyle(type);
        }
        return style;
    }

    public static void angledRel(org.xmind.gef.draw2d.graphics.Path shape, Rectangle relBounds, Point c1, Point c2) {
        int dx = relBounds.width / 8;
        int dy = relBounds.height / 8;
        shape.moveTo(relBounds.getBottomLeft());
        c1.setLocation(relBounds.getCenter().translate(-dx, -dy));
        shape.lineTo(c1);
        c2.setLocation(relBounds.getCenter().translate(dx, dy));
        shape.lineTo(c2);
        shape.lineTo(relBounds.getTopRight());
    }

    public static void calloutEllipse(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        Rectangle outlineBox = r;
        shape.addArc((float)outlineBox.x, (float)outlineBox.y, (float)outlineBox.width, (float)outlineBox.height, -130.0f, 345.0f);
        float h = outlineBox.height;
        shape.lineTo((float)outlineBox.x, (float)outlineBox.y + h);
        shape.close();
    }

    public static void calloutRoundRect(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        Rectangle box = r;
        float x = box.x;
        float y = box.y;
        float w = box.width;
        float h = box.height;
        float dy = h - (float)box.height / 4.0f;
        float c = StyleFigureUtils.getAppliedCorner(r);
        shape.moveTo(x + w * 0.2f, y + dy);
        shape.lineTo(x + w - c, y + dy);
        shape.addArc(x + w - c, y + dy - c, c, c, -90.0f, 90.0f);
        shape.lineTo(x + w, y + c);
        shape.addArc(x + w - c, y, c, c, 0.0f, 90.0f);
        shape.lineTo(x + c, y);
        shape.addArc(x, y, c, c, 90.0f, 90.0f);
        shape.lineTo(x, y + dy - c);
        shape.addArc(x, y + dy - c, c, c, 180.0f, 90.0f);
        shape.lineTo((float)box.x, (float)box.y + h);
        shape.close();
    }

    protected static int getAppliedCorner(Rectangle r) {
        int t = Math.min(r.height, r.width);
        return 7 * t / 30;
    }

    public static void curvedRel(org.xmind.gef.draw2d.graphics.Path shape, Rectangle relBounds, Point c1, Point c2) {
        int dx = -relBounds.width / 10;
        int dy = relBounds.height / 10;
        shape.moveTo(relBounds.getBottomLeft());
        Point p1 = relBounds.getTop().translate(-dx, -dy);
        Point p2 = relBounds.getBottom().translate(dx, dy);
        shape.cubicTo(p1, p2, relBounds.getTopRight());
        c1.setLocation(p1.translate(0, dy));
        c2.setLocation(p2.translate(0, -dy));
    }

    public static void diamondTopic(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        Rectangle r2 = r;
        shape.moveTo(r2.getLeft());
        shape.lineTo(r2.getBottom());
        shape.lineTo(r2.getRight());
        shape.lineTo(r2.getTop());
        shape.close();
    }

    public static void diamondArrow(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        int side1 = lineWidth + 3;
        int side2 = lineWidth + 2;
        PrecisionPoint p = new PrecisionPoint(head);
        PrecisionPoint p1 = p.getMoved(angle, (double)side1);
        PrecisionPoint p2 = p.getMoved(angle - 1.5707963267948966, (double)side2);
        PrecisionPoint p3 = p.getMoved(angle + Math.PI, (double)side1);
        PrecisionPoint p4 = p.getMoved(angle + 1.5707963267948966, (double)side2);
        shape.moveTo(p1);
        shape.lineTo(p2);
        shape.lineTo(p3);
        shape.lineTo(p4);
        shape.close();
    }

    public static void dotArrow(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        PrecisionRectangle bounds = new PrecisionRectangle((double)head.x, (double)head.y, 0.0, 0.0).expand((double)lineWidth, (double)lineWidth);
        shape.addArc(bounds, 0.0f, 360.0f);
    }

    public static void drawArrow(Graphics graphics, String arrowValue, Point head, Point tail, int lineWidth) {
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        boolean fill = true;
        double angle = new PrecisionPoint(tail).getAngle(new PrecisionPoint(head));
        if ("org.xmind.arrowShape.diamond".equals(arrowValue)) {
            StyleFigureUtils.diamondArrow(shape, head, angle, lineWidth);
        } else if ("org.xmind.arrowShape.dot".equals(arrowValue)) {
            StyleFigureUtils.dotArrow(shape, head, angle, lineWidth);
        } else if ("org.xmind.arrowShape.herringbone".equals(arrowValue)) {
            StyleFigureUtils.herringBone(shape, head, angle, lineWidth);
            fill = false;
        } else if ("org.xmind.arrowShape.spearhead".equals(arrowValue)) {
            StyleFigureUtils.spearhead(shape, head, angle, lineWidth);
        } else if ("org.xmind.arrowShape.square".equals(arrowValue)) {
            StyleFigureUtils.square(shape, head, angle, lineWidth);
        } else if ("org.xmind.arrowShape.triangle".equals(arrowValue)) {
            StyleFigureUtils.triangle(shape, head, angle, lineWidth);
        } else {
            StyleFigureUtils.normalArrow(shape, head, angle, lineWidth);
            fill = false;
        }
        if (fill) {
            graphics.setBackgroundColor(graphics.getForegroundColor());
            graphics.fillPath((Path)shape);
        }
        graphics.drawPath((Path)shape);
        shape.dispose();
    }

    public static void drawBoundary(Graphics graphics, Rectangle bounds, IStyle style, IStyle template) {
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        String shapeValue = StyleFigureUtils.getValue("shape-class", style, template);
        if (shapeValue == null || "org.xmind.boundaryShape.roundedRect".equals(shapeValue)) {
            StyleFigureUtils.roundedRect(shape, bounds);
        } else if ("org.xmind.boundaryShape.rect".equals(shapeValue)) {
            StyleFigureUtils.rectangle(shape, bounds);
        } else if ("org.xmind.boundaryShape.scallops".equals(shapeValue)) {
            StyleFigureUtils.scallops(shape, bounds);
        } else if ("org.xmind.boundaryShape.tension".equals(shapeValue)) {
            StyleFigureUtils.tension(shape, bounds);
        } else if ("org.xmind.boundaryShape.waves".equals(shapeValue)) {
            StyleFigureUtils.waves(shape, bounds);
        } else {
            StyleFigureUtils.roundedRect(shape, bounds);
        }
        String fillColorValue = StyleFigureUtils.getValue("svg:fill", style, template);
        if (fillColorValue != null) {
            Color fillColor = ColorUtils.getColor((String)fillColorValue);
            String opacityValue = StyleFigureUtils.getValue("svg:opacity", style, template);
            double opacity = NumberUtils.safeParseDouble((String)opacityValue, (double)1.0);
            int alpha = (int)(opacity * 255.0);
            graphics.setAlpha(alpha);
            graphics.setBackgroundColor(fillColor);
            graphics.fillPath((Path)shape);
        }
        Color lineColor = StyleFigureUtils.getLineColor(style, template, ColorConstants.gray);
        String lineWidthValue = StyleFigureUtils.getValue("line-width", style, template);
        int lineWidth = NumberUtils.safeParseInt((String)lineWidthValue, (int)3);
        graphics.setLineWidth(lineWidth);
        String linePatternValue = StyleFigureUtils.getValue("line-pattern", style, template);
        int linePattern = StyleUtils.toSWTLineStyle(linePatternValue, 2);
        graphics.setLineStyle(linePattern);
        graphics.setAlpha(255);
        graphics.setForegroundColor(lineColor);
        graphics.drawPath((Path)shape);
        shape.dispose();
    }

    public static void drawMainBranches(Graphics graphics, Rectangle bounds, boolean spiny, boolean rainbow) {
        PrecisionPoint center = new PrecisionPoint(bounds.getCenter());
        double length = Math.min(bounds.width, bounds.height) / 3;
        int i = 0;
        while (i < 6) {
            double angle = Math.PI * (double)(i - 1) / 3.0;
            PrecisionPoint p = center.getMoved(angle, length);
            if (p.y < center.y) {
                p.y += (center.y - p.y) / 6.0;
            } else if (p.y > center.y) {
                p.y -= (p.y - center.y) / 6.0;
            }
            if (Math.abs(p.y - center.y) > 1.0E-6) {
                if (p.x < center.x) {
                    p.x -= (center.x - p.x) / 6.0;
                } else if (p.y > center.x) {
                    p.x += (p.x - center.x) / 6.0;
                }
            }
            Color c = rainbow ? ColorUtils.getRainbowColor((int)i, (int)6) : ColorConstants.gray;
            graphics.setAlpha(255);
            graphics.setForegroundColor(c);
            graphics.setLineWidth(1);
            graphics.setLineStyle(1);
            if (spiny) {
                PrecisionPoint c1 = center.getMoved(angle + 1.0471975511965976, 2.0);
                PrecisionPoint c2 = center.getMoved(angle - 1.0471975511965976, 2.0);
                org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
                shape.moveTo(p);
                shape.lineTo(c1);
                shape.lineTo(c2);
                shape.close();
                graphics.setBackgroundColor(c);
                graphics.fillPath((Path)shape);
                graphics.drawPath((Path)shape);
                shape.dispose();
            } else {
                graphics.drawLine(center.toDraw2DPoint(), p.toDraw2DPoint());
            }
            graphics.setBackgroundColor(ColorConstants.white);
            Rectangle oval = new PrecisionRectangle(center, center).getExpanded(4.0, 3.0).toDraw2DRectangle();
            graphics.fillOval(oval);
            ++i;
        }
    }

    public static void drawSheetBackground(Graphics graphics, Rectangle bounds, IStyle style, IStyle template) {
        StyleFigureUtils.drawSheetBackground(graphics, bounds, style, template, true);
    }

    public static void drawSheetBackground(Graphics graphics, Rectangle bounds, IStyle style, IStyle template, boolean withMainBranches) {
        Color fillColor = null;
        String fillColorValue = StyleFigureUtils.getValue("svg:fill", style, template);
        if (fillColorValue != null) {
            fillColor = ColorUtils.getColor((String)fillColorValue);
        }
        if (fillColor != null) {
            graphics.setAlpha(255);
            graphics.setBackgroundColor(fillColor);
            graphics.fillRectangle(bounds);
        }
    }

    public static void drawRelationship(Graphics graphics, Rectangle bounds, IStyle style, IStyle template) {
        String endArrowValue;
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        Point c1 = new Point();
        Point c2 = new Point();
        String shapeValue = StyleFigureUtils.getValue("shape-class", style, template);
        if ("org.xmind.relationshipShape.angled".equals(shapeValue)) {
            StyleFigureUtils.angledRel(shape, bounds, c1, c2);
        } else if ("org.xmind.relationshipShape.straight".equals(shapeValue)) {
            StyleFigureUtils.straightRel(shape, bounds, c1, c2);
        } else {
            StyleFigureUtils.curvedRel(shape, bounds, c1, c2);
        }
        Color lineColor = StyleFigureUtils.getLineColor(style, template, ColorConstants.gray);
        String lineWidthValue = StyleFigureUtils.getValue("line-width", style, template);
        int lineWidth = NumberUtils.safeParseInt((String)lineWidthValue, (int)3);
        graphics.setLineWidth(lineWidth);
        String linePatternValue = StyleFigureUtils.getValue("line-pattern", style, template);
        int linePattern = StyleUtils.toSWTLineStyle(linePatternValue, 3);
        graphics.setLineStyle(linePattern);
        graphics.setAlpha(255);
        graphics.setForegroundColor(lineColor);
        graphics.drawPath((Path)shape);
        shape.dispose();
        graphics.setLineStyle(1);
        String beginArrowValue = StyleFigureUtils.getValue("arrow-begin-class", style, template);
        if (beginArrowValue != null && !"org.xmind.arrowShape.none".equals(beginArrowValue)) {
            StyleFigureUtils.drawArrow(graphics, beginArrowValue, bounds.getBottomLeft(), c1, lineWidth);
        }
        if ((endArrowValue = StyleFigureUtils.getValue("arrow-end-class", style, template)) == null) {
            endArrowValue = "org.xmind.arrowShape.normal";
        }
        if (!"org.xmind.arrowShape.none".equals(endArrowValue)) {
            StyleFigureUtils.drawArrow(graphics, endArrowValue, bounds.getTopRight(), c2, lineWidth);
        }
    }

    public static Color getBranchConnectionColor(IStyle style, IStyle template, IStyle parentStyle, IStyle parentTemplate, int preferredIndex, Color defaultLineColor) {
        Color lineColor = null;
        if (preferredIndex >= 0 && parentStyle != null) {
            String[] colors;
            String multiColors = StyleFigureUtils.getValue("multi-line-colors", parentStyle, parentTemplate);
            if (multiColors == null) {
                multiColors = template.getProperty("multi-line-colors");
            }
            if (multiColors != null && (colors = (multiColors = multiColors.trim()).split("[\\s]+")).length > 0) {
                String color = colors[preferredIndex %= colors.length].trim();
                lineColor = ColorUtils.getColor((String)color);
            }
        }
        if (lineColor == null) {
            lineColor = StyleFigureUtils.getLineColor(style, template, defaultLineColor);
        }
        return lineColor;
    }

    public static Color getLineColor(IStyle style, IStyle template, Color defaultLineColor) {
        Color lineColor = null;
        String lineColorValue = StyleFigureUtils.getValue("line-color", style, template);
        if (lineColorValue != null) {
            lineColor = ColorUtils.getColor((String)lineColorValue);
        }
        if (lineColor == null) {
            lineColor = defaultLineColor;
        }
        return lineColor;
    }

    public static String getValue(String key, IStyle style, IStyle template) {
        String value;
        String string = value = style == null ? null : style.getProperty(key);
        if (value == null) {
            value = template == null ? null : template.getProperty(key);
        }
        return value;
    }

    public static void drawLine(Graphics g, Rectangle srcBounds, IStyle srcStyle, IStyle srcTemplate, boolean srcCenterUnderline, Rectangle tgtBounds, IStyle tgtStyle, IStyle tgtTemplate, boolean tgtCenterUnderline, boolean tapered) {
        String line = StyleFigureUtils.getValue("line-class", srcStyle, srcTemplate);
        if ("org.xmind.branchConnection.none".equals(line)) {
            return;
        }
        String lineWidth = StyleFigureUtils.getValue("line-width", srcStyle, srcTemplate);
        int width = NumberUtils.safeParseInt((String)lineWidth, (int)1);
        srcBounds = srcBounds.getExpanded(-width / 2, -width / 2);
        int tgtWidth = NumberUtils.safeParseInt((String)StyleFigureUtils.getValue("line-width", tgtStyle, tgtTemplate), (int)1);
        tgtBounds = tgtBounds.getExpanded(-tgtWidth / 2, -tgtWidth / 2);
        String srcShape = StyleFigureUtils.getValue("shape-class", srcStyle, srcTemplate);
        String tgtShape = StyleFigureUtils.getValue("shape-class", tgtStyle, tgtTemplate);
        Point srcPos = StyleFigureUtils.getSourcePos(srcBounds, srcShape, tgtBounds, tgtShape, srcCenterUnderline);
        Point tgtPos = StyleFigureUtils.getTargetPos(tgtBounds, tgtShape, srcBounds, srcShape, tgtCenterUnderline);
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        if ("org.xmind.branchConnection.elbow".equals(line)) {
            StyleFigureUtils.elbow(shape, srcPos, tgtPos, tapered, width);
        } else if ("org.xmind.branchConnection.roundedElbow".equals(line)) {
            StyleFigureUtils.roundElbow(shape, srcPos, tgtPos, tapered, width);
        } else if ("org.xmind.branchConnection.curve".equals(line) || "org.xmind.branchConnection.arrowedCurve".equals(line)) {
            StyleFigureUtils.curveConn(shape, srcPos, tgtPos, tapered, width);
        } else {
            StyleFigureUtils.straightConn(shape, srcPos, tgtPos, tapered, width);
        }
        g.setLineWidth(width);
        g.setLineStyle(1);
        g.setAlpha(255);
        if (tapered) {
            g.setBackgroundColor(g.getForegroundColor());
            g.fillPath((Path)shape);
        } else {
            g.drawPath((Path)shape);
        }
        shape.dispose();
    }

    public static Point getSourcePos(Rectangle srcBounds, String srcShape, Rectangle tgtBounds, String tgtShape, boolean centerUnderline) {
        if ("org.xmind.topicShape.underline".equals(srcShape)) {
            if (centerUnderline) {
                if (tgtBounds.getCenter().x < srcBounds.getCenter().x) {
                    return srcBounds.getLeft();
                }
                return srcBounds.getRight();
            }
            if (tgtBounds.getCenter().x < srcBounds.getCenter().x) {
                return srcBounds.getBottomLeft();
            }
            return srcBounds.getBottomRight();
        }
        return Geometry.getChopBoxLocation((Point)tgtBounds.getCenter(), (Rectangle)srcBounds);
    }

    public static Point getTargetPos(Rectangle tgtBounds, String tgtShape, Rectangle srcBounds, String srcShape, boolean centerUnderline) {
        if ("org.xmind.topicShape.underline".equals(tgtShape)) {
            if (centerUnderline) {
                if (tgtBounds.getCenter().x < srcBounds.getCenter().x) {
                    return tgtBounds.getRight();
                }
                return tgtBounds.getLeft();
            }
            if (tgtBounds.getCenter().x < srcBounds.getCenter().x) {
                return tgtBounds.getBottomRight();
            }
            return tgtBounds.getBottomLeft();
        }
        if (tgtBounds.getCenter().x < srcBounds.getCenter().x) {
            return tgtBounds.getRight();
        }
        return tgtBounds.getLeft();
    }

    public static void drawTopic(Graphics graphics, Rectangle bounds, IStyle style, IStyle template, boolean centerUnderline) {
        Color fillColor;
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        boolean outline = true;
        boolean fill = true;
        String shapeValue = StyleFigureUtils.getValue("shape-class", style, template);
        if (shapeValue == null || "org.xmind.topicShape.roundedRect".equals(shapeValue)) {
            StyleFigureUtils.roundedRect(shape, bounds);
        } else if ("org.xmind.topicShape.ellipse".equals(shapeValue)) {
            StyleFigureUtils.ellipse(shape, bounds);
        } else if ("org.xmind.topicShape.rect".equals(shapeValue)) {
            StyleFigureUtils.rectangle(shape, bounds);
        } else if ("org.xmind.topicShape.underline".equals(shapeValue)) {
            StyleFigureUtils.underline(shape, bounds, centerUnderline);
            fill = false;
        } else if ("org.xmind.topicShape.noBorder".equals(shapeValue)) {
            StyleFigureUtils.noBorder(shape, bounds);
            outline = false;
        } else if ("org.xmind.topicShape.diamond".equals(shapeValue)) {
            StyleFigureUtils.diamondTopic(shape, bounds);
        } else if ("org.xmind.topicShape.callout.ellipse".equals(shapeValue)) {
            StyleFigureUtils.calloutEllipse(shape, bounds);
        } else if ("org.xmind.topicShape.callout.roundedRect".equals(shapeValue)) {
            StyleFigureUtils.calloutRoundRect(shape, bounds);
        } else {
            StyleFigureUtils.roundedRect(shape, bounds);
        }
        String fillColorValue = StyleFigureUtils.getValue("svg:fill", style, template);
        graphics.setAlpha(255);
        if (fillColorValue != null && fill && (fillColor = ColorUtils.getColor((String)fillColorValue)) != null) {
            int x = bounds.x;
            int y1 = bounds.y - bounds.height / 4;
            int y2 = bounds.y + bounds.height;
            GradientPattern bgPattern = new GradientPattern((Device)Display.getCurrent(), (float)x, (float)y1, (float)x, (float)y2, ColorConstants.white, 255, fillColor, 255);
            graphics.setBackgroundPattern((Pattern)bgPattern);
            graphics.fillPath((Path)shape);
            bgPattern.dispose();
        }
        if (outline) {
            Color lineColor = StyleFigureUtils.getLineColor(style, template, ColorConstants.gray);
            String lineWidthValue = StyleFigureUtils.getValue("line-width", style, template);
            int lineWidth = NumberUtils.safeParseInt((String)lineWidthValue, (int)1);
            graphics.setLineWidth(lineWidth);
            graphics.setLineStyle(1);
            graphics.setForegroundColor(lineColor);
            graphics.drawPath((Path)shape);
        }
        shape.dispose();
    }

    public static void ellipse(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        shape.addArc(r, 0.0f, 360.0f);
    }

    public static int getBoundaryPadding() {
        return 8;
    }

    public static void elbow(org.xmind.gef.draw2d.graphics.Path shape, Point p1, Point p2, boolean tapered, int width) {
        Point c = new Point(p1.x, p2.y);
        if (tapered) {
            PrecisionPoint _c = new PrecisionPoint(c);
            PrecisionPoint _p1 = new PrecisionPoint(p1);
            PrecisionPoint _p2 = new PrecisionPoint(p2);
            PrecisionPointPair _cc = Geometry.calculatePositionPair((PrecisionPoint)_c, (PrecisionPoint)_p2, (double)0.5);
            PrecisionPointPair _pp2 = Geometry.calculatePositionPair((PrecisionPoint)_p2, (PrecisionPoint)_c, (double)0.5).swap();
            PrecisionPointPair _pp1 = Geometry.calculatePositionPair((PrecisionPoint)_p1, (PrecisionPoint)_c, (double)width);
            double d = p1.x > p2.x == p1.y > p2.y ? (double)width * 0.5 : (double)(-width) * 0.5;
            _cc.p1().x -= d;
            _cc.p2().x += d;
            shape.moveTo(_pp1.p1());
            shape.lineTo(_cc.p1());
            shape.lineTo(_pp2.p1());
            shape.lineTo(_pp2.p2());
            shape.lineTo(_cc.p2());
            shape.lineTo(_pp1.p2());
            shape.close();
        } else {
            shape.moveTo(p1);
            shape.lineTo(c);
            shape.lineTo(p2);
        }
    }

    public static void roundElbow(org.xmind.gef.draw2d.graphics.Path shape, Point p1, Point p2, boolean tapered, int width) {
        Point c = new Point(p1.x, p2.y);
        int corner = StyleFigureUtils.getAppliedCorner(new Rectangle(p1, p2)) * 2;
        Point q1 = new Point(c.x, p1.y > p2.y ? c.y + corner : c.y - corner);
        Point q2 = new Point(p1.x > p2.x ? c.x - corner : c.x + corner, c.y);
        if (tapered) {
            PrecisionPoint _p1 = new PrecisionPoint(p1);
            PrecisionPoint _p2 = new PrecisionPoint(p2);
            PrecisionPoint _q1 = new PrecisionPoint(q1);
            PrecisionPoint _q2 = new PrecisionPoint(q2);
            PrecisionPoint _c1 = new PrecisionPoint(_q1.x, _q1.y + ((double)c.y - _q1.y) * 3.0 / 4.0);
            PrecisionPoint _c2 = new PrecisionPoint(_q2.x + ((double)c.x - _q2.x) * 3.0 / 4.0, _q2.y);
            PrecisionPoint _pc1 = new PrecisionPoint(_p1.x, _p1.y + (_c1.y - _p1.y) * 2.0);
            PrecisionPoint _pc2 = new PrecisionPoint(_p2.x + (_c2.x - _p2.x) * 2.0, _p2.y);
            PrecisionPointPair _pp1 = Geometry.calculatePositionPair((PrecisionPoint)_p1, (PrecisionPoint)_c1, (double)width);
            PrecisionPointPair _qq1 = Geometry.calculatePositionPair((PrecisionPoint)_q1, (PrecisionPoint)_c1, (double)width);
            PrecisionPointPair _cc1 = Geometry.calculatePositionPair((PrecisionPoint)_c1, (PrecisionPoint)_pc1, (double)width);
            PrecisionPointPair _pp2 = Geometry.calculatePositionPair((PrecisionPoint)_p2, (PrecisionPoint)_c2, (double)0.5).swap();
            PrecisionPointPair _qq2 = Geometry.calculatePositionPair((PrecisionPoint)_q2, (PrecisionPoint)_c2, (double)0.5).swap();
            PrecisionPointPair _cc2 = Geometry.calculatePositionPair((PrecisionPoint)_c2, (PrecisionPoint)_pc2, (double)0.5).swap();
            double d = p1.x > p2.x == p1.y > p2.y ? (double)width * 0.5 : (double)(-width) * 0.5;
            _qq2.p1().x -= d;
            _qq2.p2().x += d;
            _cc2.p1().x -= d;
            _cc2.p2().x += d;
            shape.moveTo(_pp1.p1());
            shape.lineTo(_qq1.p1());
            shape.cubicTo(_cc1.p1(), _cc2.p1(), _qq2.p1());
            shape.lineTo(_pp2.p1());
            shape.lineTo(_pp2.p2());
            shape.lineTo(_qq2.p2());
            shape.cubicTo(_cc2.p2(), _cc1.p2(), _qq1.p2());
            shape.lineTo(_pp1.p2());
            shape.close();
        } else {
            shape.moveTo(p1);
            shape.lineTo(q1);
            shape.cubicTo((float)q1.x, (float)(q1.y + (c.y - q1.y) * 3 / 4), (float)(q2.x + (c.x - q2.x) * 3 / 4), (float)q2.y, (float)q2.x, (float)q2.y);
            shape.lineTo(p2);
        }
    }

    public static void straightConn(org.xmind.gef.draw2d.graphics.Path shape, Point p1, Point p2, boolean tapered, int width) {
        if (tapered) {
            PrecisionPoint _p1 = new PrecisionPoint(p1);
            PrecisionPoint _p2 = new PrecisionPoint(p2);
            PrecisionPointPair _pp1 = Geometry.calculatePositionPair((PrecisionPoint)_p1, (PrecisionPoint)_p2, (double)width);
            PrecisionPointPair _pp2 = Geometry.calculatePositionPair((PrecisionPoint)_p2, (PrecisionPoint)_p1, (double)0.5).swap();
            shape.moveTo(_pp1.p1());
            shape.lineTo(_pp2.p1());
            shape.lineTo(_pp2.p2());
            shape.moveTo(_pp1.p2());
            shape.close();
        } else {
            shape.moveTo(p1);
            shape.lineTo(p2);
        }
    }

    public static void curveConn(org.xmind.gef.draw2d.graphics.Path shape, Point p1, Point p2, boolean tapered, int width) {
        if (tapered) {
            PrecisionPoint _p1 = new PrecisionPoint(p1);
            PrecisionPoint _p2 = new PrecisionPoint(p2);
            PrecisionPoint _c = new PrecisionPoint(_p1.x + (_p2.x - _p1.x) * 2.0 / 10.0, _p2.y);
            PrecisionPointPair _pp1 = Geometry.calculatePositionPair((PrecisionPoint)_p1, (PrecisionPoint)_p2, (double)width);
            PrecisionPointPair _pp2 = Geometry.calculatePositionPair((PrecisionPoint)_p2, (PrecisionPoint)_c, (double)0.5).swap();
            PrecisionPointPair _cc = Geometry.calculatePositionPair((PrecisionPoint)_c, (PrecisionPoint)_p2, (double)0.5);
            double d = p1.x > p2.x == p1.y > p2.y ? (double)width * 0.5 : (double)(-width) * 0.5;
            _cc.p1().x -= d;
            _cc.p2().x += d;
            shape.moveTo(_pp1.p1());
            shape.quadTo(_cc.p1(), _pp2.p1());
            shape.lineTo(_pp2.p2());
            shape.quadTo(_cc.p2(), _pp1.p2());
            shape.close();
        } else {
            Point c = new Point(p1.x, p2.y);
            c.x += (p2.x - c.x) * 2 / 10;
            shape.moveTo(p1);
            shape.quadTo(c, p2);
        }
    }

    public static void herringBone(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        int l = lineWidth * 2 + 4;
        int w = lineWidth * 2 + 2;
        PrecisionPoint p = new PrecisionPoint(head);
        PrecisionPoint p1 = p.getMoved(angle, (double)(l / 2));
        PrecisionPoint p2 = p.getMoved(angle, (double)l);
        PrecisionPoint p01 = p.getMoved(angle - 2.0943951023931953, (double)w);
        PrecisionPoint p02 = p.getMoved(angle + 2.0943951023931953, (double)w);
        PrecisionPoint p11 = p1.getMoved(angle - 2.0943951023931953, (double)w);
        PrecisionPoint p12 = p1.getMoved(angle + 2.0943951023931953, (double)w);
        PrecisionPoint p21 = p2.getMoved(angle - 2.0943951023931953, (double)w);
        PrecisionPoint p22 = p2.getMoved(angle + 2.0943951023931953, (double)w);
        shape.moveTo(p01);
        shape.lineTo(head);
        shape.lineTo(p02);
        shape.moveTo(p11);
        shape.lineTo(p1);
        shape.lineTo(p12);
        shape.moveTo(p21);
        shape.lineTo(p2);
        shape.lineTo(p22);
        shape.moveTo(head);
        shape.lineTo(p2);
    }

    public static void noBorder(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        shape.addRectangle(r);
    }

    public static void normalArrow(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        int side = lineWidth * 2 + 4;
        PrecisionPoint p = new PrecisionPoint(head);
        PrecisionPoint p1 = p.getMoved(angle - 0.5235987755982988, (double)side);
        PrecisionPoint p2 = p.getMoved(angle + 0.5235987755982988, (double)side);
        shape.moveTo(p1);
        shape.lineTo(head);
        shape.lineTo(p2);
    }

    public static void rectangle(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        shape.addRectangle(r);
    }

    public static void roundedRect(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r) {
        shape.addRoundedRectangle(r, (float)StyleFigureUtils.getAppliedCorner(r));
    }

    public static void scallops(org.xmind.gef.draw2d.graphics.Path shape, Rectangle box) {
        int margin = StyleFigureUtils.getBoundaryPadding() * 3 / 5;
        if (box.width <= margin * 2 || box.height <= margin * 2) {
            return;
        }
        float width = box.width - margin * 2;
        float height = box.height - margin * 2;
        float stepX = 16.0f;
        float stepY = 12.0f;
        int numX = Math.max(1, (int)(width / stepX));
        int numY = Math.max(1, (int)(height / stepY));
        stepX = width / (float)numX;
        stepY = height / (float)numY;
        float x = box.x + margin;
        float y = box.y + margin;
        shape.moveTo(x, y);
        int i = 0;
        while (i < numX) {
            shape.cubicTo(x + stepX / 4.0f, y - (float)margin, x + stepX * 3.0f / 4.0f, y - (float)margin, x + stepX, y);
            x += stepX;
            ++i;
        }
        i = 0;
        while (i < numY) {
            shape.cubicTo(x + (float)margin, y + stepY / 4.0f, x + (float)margin, y + stepY * 3.0f / 4.0f, x, y + stepY);
            y += stepY;
            ++i;
        }
        i = 0;
        while (i < numX) {
            shape.cubicTo(x - stepX / 4.0f, y + (float)margin, x - stepX * 3.0f / 4.0f, y + (float)margin, x - stepX, y);
            x -= stepX;
            ++i;
        }
        i = 0;
        while (i < numY) {
            shape.cubicTo(x - (float)margin, y - stepY / 4.0f, x - (float)margin, y - stepY * 3.0f / 4.0f, x, y - stepY);
            y -= stepY;
            ++i;
        }
        shape.close();
    }

    public static void spearhead(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        int side = lineWidth * 2 + 6;
        PrecisionPoint p = new PrecisionPoint(head);
        PrecisionPoint p1 = p.getMoved(angle - 0.39269908169872414, (double)side);
        PrecisionPoint p2 = p.getMoved(angle + 0.39269908169872414, (double)side);
        PrecisionPoint cp = p.getMoved(angle, (double)(side / 2));
        shape.moveTo(head);
        shape.lineTo(p1);
        shape.quadTo(cp, p2);
        shape.close();
    }

    public static void square(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        int side = lineWidth + 2;
        PrecisionPoint p = new PrecisionPoint(head);
        PrecisionPoint p1 = p.getMoved(angle - 0.7853981633974483, (double)side);
        PrecisionPoint p2 = p.getMoved(angle - 2.356194490192345, (double)side);
        PrecisionPoint p3 = p.getMoved(angle + 2.356194490192345, (double)side);
        PrecisionPoint p4 = p.getMoved(angle + 0.7853981633974483, (double)side);
        shape.moveTo(p1);
        shape.lineTo(p2);
        shape.lineTo(p3);
        shape.lineTo(p4);
        shape.close();
    }

    public static void straightRel(org.xmind.gef.draw2d.graphics.Path shape, Rectangle relBounds, Point c1, Point c2) {
        Point p = relBounds.getBottomLeft();
        shape.moveTo(p);
        c2.setLocation(p);
        p = relBounds.getTopRight();
        c1.setLocation(p);
        shape.lineTo(p);
    }

    public static void tension(org.xmind.gef.draw2d.graphics.Path shape, Rectangle box) {
        int margin = StyleFigureUtils.getBoundaryPadding() / 2;
        int margin2 = Math.max(1, margin / 4);
        if (box.width <= margin * 2 || box.height <= margin * 2) {
            return;
        }
        float width = box.width - margin2 * 2;
        float height = box.height - margin2 * 2;
        float stepX = 16.0f;
        float stepY = 16.0f;
        int numX = Math.max(1, (int)(width / stepX));
        int numY = Math.max(1, (int)(height / stepY));
        stepX = width / (float)numX;
        stepY = height / (float)numY;
        float x = box.x + margin2;
        float y = box.y + margin2;
        shape.moveTo(x, y);
        int i = 0;
        while (i < numX) {
            shape.cubicTo(x + stepX / 4.0f, y + (float)margin, x + stepX * 3.0f / 4.0f, y + (float)margin, x + stepX, y);
            x += stepX;
            ++i;
        }
        i = 0;
        while (i < numY) {
            shape.cubicTo(x - (float)margin, y + stepY / 4.0f, x - (float)margin, y + stepY * 3.0f / 4.0f, x, y + stepY);
            y += stepY;
            ++i;
        }
        i = 0;
        while (i < numX) {
            shape.cubicTo(x - stepX / 4.0f, y - (float)margin, x - stepX * 3.0f / 4.0f, y - (float)margin, x - stepX, y);
            x -= stepX;
            ++i;
        }
        i = 0;
        while (i < numY) {
            shape.cubicTo(x + (float)margin, y - stepY / 4.0f, x + (float)margin, y - stepY * 3.0f / 4.0f, x, y - stepY);
            y -= stepY;
            ++i;
        }
        shape.close();
    }

    public static void triangle(org.xmind.gef.draw2d.graphics.Path shape, Point head, double angle, int lineWidth) {
        int side = lineWidth * 2 + 4;
        PrecisionPoint p = new PrecisionPoint(head);
        PrecisionPoint p1 = p.getMoved(angle - 0.5235987755982988, (double)side);
        PrecisionPoint p2 = p.getMoved(angle + 0.5235987755982988, (double)side);
        shape.moveTo(p1);
        shape.lineTo(head);
        shape.lineTo(p2);
        shape.close();
    }

    public static void underline(org.xmind.gef.draw2d.graphics.Path shape, Rectangle r, boolean center) {
        Rectangle r2 = r;
        if (center) {
            shape.moveTo(r2.getLeft());
            shape.lineTo(r2.getRight());
        } else {
            shape.moveTo(r2.getBottomLeft());
            shape.lineTo(r2.getBottomRight());
        }
    }

    public static void waves(org.xmind.gef.draw2d.graphics.Path shape, Rectangle box) {
        int margin = StyleFigureUtils.getBoundaryPadding() / 4;
        if (box.width <= margin * 2 || box.height <= margin * 2) {
            return;
        }
        float width = box.width - margin * 2;
        float height = box.height - margin * 2;
        float stepX = 16.0f;
        float stepY = 16.0f;
        int numX = Math.max(1, (int)(width / stepX));
        int numY = Math.max(1, (int)(height / stepY));
        stepX = width / (float)numX;
        stepY = height / (float)numY;
        float x = box.x + margin;
        float y = box.y + margin;
        float h = (float)StyleFigureUtils.getBoundaryPadding() / 4.0f;
        shape.moveTo(x, y);
        int i = 0;
        while (i < numX) {
            shape.cubicTo(x + stepX / 8.0f, y - h, x + stepX * 3.0f / 8.0f, y - h, x + stepX / 2.0f, y);
            shape.cubicTo(x + stepX * 5.0f / 8.0f, y + h, x + stepX * 7.0f / 8.0f, y + h, x + stepX, y);
            x += stepX;
            ++i;
        }
        i = 0;
        while (i < numY) {
            shape.cubicTo(x + h, y + stepY / 8.0f, x + h, y + stepY * 3.0f / 8.0f, x, y + stepY / 2.0f);
            shape.cubicTo(x - h, y + stepY * 5.0f / 8.0f, x - h, y + stepY * 7.0f / 8.0f, x, y + stepY);
            y += stepY;
            ++i;
        }
        i = 0;
        while (i < numX) {
            shape.cubicTo(x - stepX / 8.0f, y + h, x - stepX * 3.0f / 8.0f, y + h, x - stepX / 2.0f, y);
            shape.cubicTo(x - stepX * 5.0f / 8.0f, y - h, x - stepX * 7.0f / 8.0f, y - h, x - stepX, y);
            x -= stepX;
            ++i;
        }
        i = 0;
        while (i < numY) {
            shape.cubicTo(x - h, y - stepY / 8.0f, x - h, y - stepY * 3.0f / 8.0f, x, y - stepY / 2.0f);
            shape.cubicTo(x + h, y - stepY * 5.0f / 8.0f, x + h, y - stepY * 7.0f / 8.0f, x, y - stepY);
            y -= stepY;
            ++i;
        }
        shape.close();
    }
}

