/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.INotes;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.gef.EditDomain;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyNotesCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.FindReplaceAction;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.findreplace.IFindReplaceOperationProvider;
import org.xmind.ui.internal.notes.NotesFindReplaceOperationProvider;
import org.xmind.ui.internal.notes.NotesViewer;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.internal.views.NotesHyperlinkDialog;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.richtext.FullRichTextActionBarContributor;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.util.Logger;

public class NotesView
extends ViewPart
implements IPartListener,
ISelectionListener,
ICoreEventListener,
IDocumentListener,
IRichDocumentListener,
IContributedContentsView,
ISelectionChangedListener {
    private static boolean DEBUG = false;
    private IGraphicalEditor contributingEditor;
    private ISelection currentSelection;
    private ITopicPart currentTopicPart;
    private NotesViewer viewer;
    private RichDocumentNotesAdapter adapter;
    private IRichTextActionBarContributor contributor;
    private ICoreEventRegister eventRegister;
    private boolean savingNotes;
    private NotesFindReplaceOperationProvider notesOperationProvider = null;
    private ICoreEventRegistration saveNotesReg = null;
    private List<String> textActionIds = new ArrayList<String>(7);
    private boolean updating;

    public IWorkbenchPart getContributingPart() {
        return this.contributingEditor;
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addSelectionListener((ISelectionListener)this);
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.contributor = new NotesViewRichTextActionBarContributor();
        this.viewer = new NotesViewer();
        this.viewer.setContributor(this.contributor);
        this.viewer.createControl(parent);
        this.contributor.fillMenu(this.getViewSite().getActionBars().getMenuManager());
        this.viewer.setInput(null);
        this.createActions();
        this.viewer.getImplementation().addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.showBootstrapContent();
    }

    private void createActions() {
        TextAction undo = new TextAction(1);
        undo.setText(MindMapMessages.NotesView_UndoTyping_text);
        undo.setToolTipText(MindMapMessages.NotesView_UndoTyping_toolTip);
        this.setTextActionHandler(ActionFactory.UNDO.getId(), undo);
        TextAction redo = new TextAction(2);
        redo.setText(MindMapMessages.NotesView_RedoTyping_text);
        redo.setToolTipText(MindMapMessages.NotesView_RedoTyping_toolTip);
        this.setTextActionHandler(ActionFactory.REDO.getId(), redo);
        this.setTextActionHandler(ActionFactory.SELECT_ALL.getId(), new TextAction(7));
        this.setTextActionHandler(ActionFactory.COPY.getId(), new TextAction(4));
        this.setTextActionHandler(ActionFactory.CUT.getId(), new TextAction(3));
        this.setTextActionHandler(ActionFactory.PASTE.getId(), new TextAction(5));
        this.setTextActionHandler(ActionFactory.DELETE.getId(), new TextAction(6));
        FindReplaceAction findReplaceAction = new FindReplaceAction((IViewPart)this);
        this.setTextActionHandler(ActionFactory.FIND.getId(), findReplaceAction);
    }

    private void setTextActionHandler(String id, Action action) {
        this.textActionIds.add(id);
        this.getViewSite().getActionBars().setGlobalActionHandler(id, (IAction)action);
    }

    private void showBootstrapContent() {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null) {
            this.partActivated((IWorkbenchPart)activeEditor);
            ISelection selection = this.contributingEditor == null ? null : this.contributingEditor.getSite().getSelectionProvider().getSelection();
            this.editorSelectionChanged(selection);
        }
    }

    public void dispose() {
        this.editorSelectionChanged(null);
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
        this.textActionIds.clear();
        if (this.adapter != null) {
            this.adapter.dispose();
            this.adapter = null;
        }
        this.viewer = null;
        if (this.notesOperationProvider != null) {
            this.notesOperationProvider = null;
        }
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getImplementation().getFocusControl().setFocus();
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (DEBUG) {
            System.out.println("Part activated: " + part);
        }
        if (part == this || !(part instanceof IEditorPart)) {
            return;
        }
        if (part instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)part);
        }
    }

    private void setContributingEditor(IGraphicalEditor editor) {
        this.contributingEditor = editor;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (DEBUG) {
            System.out.println("Part closed: " + part);
        }
        if (part == this.contributingEditor) {
            this.selectionChanged(part, null);
            this.setContributingEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (DEBUG) {
            System.out.println("Part deactivated: " + part);
        }
        if (part == this) {
            this.saveNotes();
        }
    }

    private void saveNotes() {
        if (this.adapter == null || this.currentTopicPart == null || this.viewer == null || this.viewer.getControl().isDisposed() || !this.viewer.hasModified()) {
            this.deactivateJob();
            return;
        }
        if (DEBUG) {
            System.out.println("Start saving notes");
        }
        this.savingNotes = true;
        ITopic topic = this.currentTopicPart.getTopic();
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            this.doSaveNotes(topic, cs);
        } else {
            this.forceSaveNotes(topic);
        }
        this.savingNotes = false;
        this.deactivateJob();
        if (DEBUG) {
            System.out.println("End saving notes");
        }
    }

    private void forceSaveNotes(ITopic topic) {
        INotes notes = topic.getNotes();
        notes.setContent("html", this.adapter.makeNewHtmlContent());
        notes.setContent("plain", this.adapter.makeNewPlainContent());
    }

    private void doSaveNotes(ITopic topic, ICommandStack cs) {
        ModifyNotesCommand modifyHtml = new ModifyNotesCommand(topic, this.adapter.makeNewHtmlContent(), "html");
        ModifyNotesCommand modifyPlain = new ModifyNotesCommand(topic, this.adapter.makeNewPlainContent(), "plain");
        CompoundCommand cmd = new CompoundCommand(new Command[]{modifyHtml, modifyPlain});
        cmd.setLabel(CommandMessages.Command_ModifyNotes);
        cs.execute((Command)cmd);
    }

    private ICommandStack getCommandStack() {
        EditDomain domain = this.currentTopicPart.getSite().getViewer().getEditDomain();
        if (domain != null) {
            return domain.getCommandStack();
        }
        return null;
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        if (adapter == ISaveablePart.class) {
            return this.getSaveablePart();
        }
        if (adapter == IFindReplaceOperationProvider.class) {
            if (this.notesOperationProvider == null) {
                this.notesOperationProvider = new NotesFindReplaceOperationProvider(this.viewer);
            }
            return this.notesOperationProvider;
        }
        return super.getAdapter(adapter);
    }

    private ISaveablePart getSaveablePart() {
        if (this.getContributingPart() instanceof ISaveablePart) {
            return (ISaveablePart)this.getContributingPart();
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this.contributingEditor) {
            return;
        }
        this.editorSelectionChanged(selection);
    }

    private void editorSelectionChanged(ISelection selection) {
        if (selection == this.currentSelection || selection != null && selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        this.setCurrentTopicPart(this.findSelectedTopicPart());
    }

    private void setCurrentTopicPart(ITopicPart topicPart) {
        if (topicPart == this.currentTopicPart) {
            return;
        }
        this.unhookTopic();
        this.saveNotes();
        this.currentTopicPart = topicPart;
        this.forceRefreshViewer();
        this.hookTopic();
    }

    private void forceRefreshViewer() {
        RichDocumentNotesAdapter oldAdapter = this.adapter;
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.adapter = this.createNotesAdapter();
            if (DEBUG && this.adapter != null) {
                System.out.println("New adapter created");
            }
            this.unhookDocument();
            this.viewer.setInput(this.adapter);
            if (this.adapter != null) {
                this.hookDocument();
            }
        } else {
            this.adapter = null;
        }
        if (oldAdapter != null) {
            oldAdapter.dispose();
            if (DEBUG) {
                System.out.println("Old adapter disposed");
            }
        }
        this.update();
    }

    private void hookDocument() {
        IRichDocument document = this.viewer.getImplementation().getDocument();
        if (document != null) {
            document.addDocumentListener((IDocumentListener)this);
            document.addRichDocumentListener((IRichDocumentListener)this);
            if (DEBUG) {
                System.out.println("Document hooked");
            }
        }
    }

    private void unhookDocument() {
        IRichDocument document = this.viewer.getImplementation().getDocument();
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
            document.removeRichDocumentListener((IRichDocumentListener)this);
            if (DEBUG) {
                System.out.println("Document unhooked");
            }
        }
    }

    private void unhookTopic() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            if (DEBUG) {
                System.out.println("Model listeners uninstalled");
            }
            this.eventRegister = null;
        }
    }

    private void hookTopic() {
        ITopic topic;
        if (this.currentTopicPart != null && (topic = this.currentTopicPart.getTopic()) instanceof ICoreEventSource) {
            if (this.eventRegister == null) {
                this.eventRegister = new CoreEventRegister((ICoreEventSource)topic, (ICoreEventListener)this);
            }
            this.eventRegister.register("topicNotes");
            if (DEBUG) {
                System.out.println("Model listeners installed");
            }
        }
    }

    private RichDocumentNotesAdapter createNotesAdapter() {
        if (this.currentTopicPart == null) {
            return null;
        }
        ITopic topic = this.currentTopicPart.getTopic();
        return new RichDocumentNotesAdapter(topic);
    }

    private ITopicPart findSelectedTopicPart() {
        if (this.contributingEditor == null) {
            return null;
        }
        if (this.currentSelection == null || this.currentSelection.isEmpty() || !(this.currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = ((IStructuredSelection)this.currentSelection).getFirstElement();
        IGraphicalEditorPage page = this.contributingEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        IPart part = page.getViewer().findPart(o);
        if (part instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }

    public void handleCoreEvent(CoreEvent event) {
        String eventType = event.getType();
        if ("topicNotes".equals(eventType)) {
            this.handleNotesChanged();
        }
    }

    private void handleNotesChanged() {
        if (this.savingNotes) {
            return;
        }
        this.forceRefreshViewer();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.update();
    }

    private void updateJob() {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        if (this.viewer.hasModified()) {
            this.activateJob();
        } else {
            this.deactivateJob();
        }
    }

    private void activateJob() {
        if (this.saveNotesReg != null && this.saveNotesReg.isValid()) {
            return;
        }
        this.saveNotesReg = null;
        IWorkbook workbook = (IWorkbook)this.contributingEditor.getAdapter(IWorkbook.class);
        if (workbook instanceof ICoreEventSource2) {
            this.saveNotesReg = ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", (ICoreEventListener)new SaveNotesJob());
            if (DEBUG) {
                System.out.println("Job acitvated");
            }
        }
    }

    private void deactivateJob() {
        if (this.saveNotesReg != null) {
            this.saveNotesReg.unregister();
            this.saveNotesReg = null;
        }
    }

    private void updateTextActions() {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        TextViewer textViewer = this.viewer.getImplementation().getTextViewer();
        if (textViewer != null) {
            IActionBars actionBars = this.getViewSite().getActionBars();
            for (String id : this.textActionIds) {
                IAction handler = actionBars.getGlobalActionHandler(id);
                if (!(handler instanceof TextAction)) continue;
                ((TextAction)handler).update(textViewer);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void imageChanged(IRichDocument document, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages) {
        this.update();
    }

    public void lineStyleChanged(IRichDocument document, LineStyle[] oldLineStyles, LineStyle[] newLineStyles) {
        this.update();
    }

    public void textStyleChanged(IRichDocument document, StyleRange[] oldTextStyles, StyleRange[] newTextStyles) {
        this.update();
    }

    public void hyperlinkChanged(IRichDocument document, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
        this.update();
    }

    private void update() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                NotesView.this.updateJob();
                NotesView.this.updateTextActions();
                NotesView.this.updating = false;
            }
        });
    }

    private class InsertHyperlinkAction
    extends Action
    implements IRichTextAction {
        private IRichTextEditViewer viewer;

        public InsertHyperlinkAction(IRichTextEditViewer viewer) {
            super(MindMapMessages.InsertHyperlinkAction_text, MindMapUI.getImages().get("discovery.gif", true));
            this.setToolTipText(MindMapMessages.InserthyperlinkAction_toolTip);
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("discovery.gif", false));
            this.viewer = viewer;
        }

        public void run() {
            NotesHyperlinkDialog dialog;
            int ret;
            IRichTextRenderer renderer = this.viewer.getRenderer();
            ITextSelection selection = (ITextSelection)this.viewer.getSelection();
            String oldText = selection.getText();
            int start = selection.getOffset();
            int end = start + selection.getLength();
            Hyperlink[] oldHyperlinks = renderer.getSelectionHyperlinks();
            String oldHref = null;
            Hyperlink oldHyperlink = null;
            if (oldHyperlinks.length == 1) {
                Hyperlink link = oldHyperlinks[0];
                if (link.start <= selection.getOffset() && link.end() >= selection.getOffset() + selection.getLength()) {
                    oldHyperlink = link;
                    oldHref = link.href;
                    try {
                        oldText = this.viewer.getDocument().get(link.start, link.length);
                        start = link.start;
                        end = start + link.length;
                    }
                    catch (BadLocationException e) {
                        String message = String.format("Unexpected hyperlink range: start=%d, length=%d", link.start, link.length);
                        Logger.log(e, message);
                    }
                }
            }
            ImagePlaceHolder[] images = this.viewer.getDocument().getImages();
            int temp = -1;
            int i = 0;
            while (i < images.length) {
                ImagePlaceHolder image = images[i];
                if (image.offset >= end) break;
                if (image.offset >= start && image.offset <= end) {
                    int offset = image.offset - start;
                    oldText = String.valueOf(oldText.substring(0, offset - ++temp)) + oldText.substring(offset + 1 - temp);
                }
                ++i;
            }
            if ((ret = (dialog = new NotesHyperlinkDialog(NotesView.this.getSite().getShell(), oldHref, oldText)).open()) == 0) {
                String newText = dialog.getDisplayText();
                String newHref = dialog.getHref();
                if (oldHyperlink != null && newText.equals(oldText)) {
                    if (!oldHyperlink.href.equals(newHref)) {
                        RichTextUtils.replaceHyperlinkHref((IRichDocument)this.viewer.getDocument(), (Hyperlink)oldHyperlink, (String)newHref);
                    }
                } else {
                    if ("".equals(newText)) {
                        newText = newHref;
                    }
                    renderer.insertHyperlink(newHref, newText);
                }
            }
        }

        public void dispose() {
            this.viewer = null;
        }

        public void selctionChanged(IRichTextEditViewer viewer, ISelection selection) {
        }
    }

    private class InsertImageAction
    extends Action
    implements IRichTextAction {
        private IRichTextEditViewer viewer;

        public InsertImageAction(IRichTextEditViewer viewer) {
            super(MindMapMessages.InsertImage_text, MindMapUI.getImages().get("insertimage.gif", true));
            this.viewer = viewer;
            this.setToolTipText(MindMapMessages.NotesView_InsertImage_toolTip);
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("insertimage.gif", false));
        }

        public void run() {
            if (this.viewer == null || this.viewer.getControl().isDisposed() || NotesView.this.adapter == null) {
                return;
            }
            String path = this.getPath();
            if (path == null) {
                return;
            }
            Image image = NotesView.this.adapter.createImageFromFile(path);
            if (image == null) {
                return;
            }
            this.viewer.getRenderer().insertImage(image);
        }

        private String getPath() {
            FileDialog fd = new FileDialog(NotesView.this.getSite().getShell(), 4096);
            DialogUtils.makeDefaultImageSelectorDialog(fd, true);
            return fd.open();
        }

        public void dispose() {
            this.viewer = null;
        }

        public void selctionChanged(IRichTextEditViewer viewer, ISelection selection) {
        }
    }

    private class NotesViewRichTextActionBarContributor
    extends FullRichTextActionBarContributor {
        private IRichTextAction insertImageAction;
        private IRichTextAction insertHyperlinkAction;

        private NotesViewRichTextActionBarContributor() {
        }

        protected void makeActions(IRichTextEditViewer viewer) {
            super.makeActions(viewer);
            this.insertImageAction = new InsertImageAction(viewer);
            this.addRichTextAction(this.insertImageAction);
            this.insertHyperlinkAction = new InsertHyperlinkAction(viewer);
            this.addRichTextAction(this.insertHyperlinkAction);
        }

        public void fillToolBar(IToolBarManager toolbar) {
            super.fillToolBar(toolbar);
            toolbar.add((IContributionItem)new Separator());
            toolbar.add((IAction)this.insertImageAction);
            toolbar.add((IAction)this.insertHyperlinkAction);
        }
    }

    private class SaveNotesJob
    implements ICoreEventListener {
        private SaveNotesJob() {
        }

        public void handleCoreEvent(CoreEvent event) {
            NotesView.this.saveNotes();
        }
    }

    private class TextAction
    extends Action {
        private int op;

        public TextAction(int op) {
            this.op = op;
        }

        public void run() {
            if (NotesView.this.viewer == null || NotesView.this.viewer.getControl().isDisposed()) {
                return;
            }
            TextViewer textViewer = NotesView.this.viewer.getImplementation().getTextViewer();
            if (textViewer.canDoOperation(this.op)) {
                textViewer.doOperation(this.op);
            }
        }

        public void update(TextViewer textViewer) {
            this.setEnabled(textViewer.canDoOperation(this.op));
        }
    }
}

