/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dnd.MindMapElementTransfer;
import org.xmind.ui.internal.wizards.MarkerExportWizard;
import org.xmind.ui.internal.wizards.MarkerImportWizard;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkerView
extends ViewPart
implements IContributedContentsView {
    private WidgetFactory factory;
    private ScrolledForm form;
    private MarkerGroupPart recentPart;
    private MarkerSheetPart systemPart;
    private MarkerSheetPart userPart;
    private Map<IMarkerGroup, MarkerGroupPart> groupToPart = new HashMap<IMarkerGroup, MarkerGroupPart>();
    private IAction showMarkerManagerAction;
    private IAction importMarkerAction;
    private IAction exportMarkerAction;

    public void createPartControl(Composite parent) {
        this.factory = new WidgetFactory(parent.getDisplay());
        this.form = this.createForm(parent, this.factory);
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MarkerView.this.factory != null) {
                    MarkerView.this.factory.dispose();
                    MarkerView.this.factory = null;
                }
            }
        });
        Composite composite = this.form.getBody();
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createRecentSection(composite, this.factory);
        this.createSystemSection(composite, this.factory);
        this.createUserSection(composite, this.factory);
        this.form.reflow(true);
        this.showMarkerManagerAction = new ShowMarkerManagerAction();
        this.importMarkerAction = new ImportMarkerAction();
        this.exportMarkerAction = new ExportMarkerAction();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add(this.showMarkerManagerAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.importMarkerAction);
        menu.add(this.exportMarkerAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add(this.showMarkerManagerAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.importMarkerAction);
        toolBar.add(this.exportMarkerAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IContributionItem)new Separator("additions"));
    }

    private ScrolledForm createForm(Composite parent, WidgetFactory factory) {
        return factory.createScrolledForm(parent);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private void createUserSection(Composite composite, WidgetFactory factory) {
        this.userPart = new MarkerSheetPart(MindMapUI.getResourceManager().getUserMarkerSheet());
        this.createSection(composite, MindMapMessages.MarkerView_UserMarkers_label, this.userPart, factory);
    }

    private void createSystemSection(Composite composite, WidgetFactory factory) {
        this.systemPart = new MarkerSheetPart(MindMapUI.getResourceManager().getSystemMarkerSheet());
        this.createSection(composite, MindMapMessages.MarkerView_XMindMarkers_label, this.systemPart, factory);
    }

    private void createRecentSection(Composite composite, WidgetFactory factory) {
        this.recentPart = new MarkerGroupPart(MindMapUI.getResourceManager().getRecentMarkerGroup(), false);
        this.createSection(composite, MindMapMessages.MarkerView_RecentlyUsed_label, this.recentPart, factory);
    }

    private void createSection(Composite parent, String title, ISectionPart part, WidgetFactory factory) {
        Section section = factory.createSection(parent, 2370);
        section.setText(title);
        section.setLayoutData((Object)new GridData(768));
        Control c = part.createControl((Composite)section);
        section.setClient(c);
    }

    public void setFocus() {
        if (this.form != null) {
            this.form.setFocus();
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    public void dispose() {
        super.dispose();
        this.factory = null;
        this.form = null;
        this.recentPart = null;
        this.systemPart = null;
        this.userPart = null;
        this.groupToPart.clear();
    }

    private IStructuredSelection getCurrentSelection() {
        ISelection selection = this.getSite().getPage().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private class ExportMarkerAction
    extends Action {
        public ExportMarkerAction() {
            super(MindMapMessages.ExportMarkers_text);
            this.setToolTipText(MindMapMessages.ExportMarkers_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("export_wiz.gif", true));
        }

        public void run() {
            MarkerExportWizard wizard = new MarkerExportWizard();
            wizard.init(PlatformUI.getWorkbench(), MarkerView.this.getCurrentSelection());
            WizardDialog dialog = new WizardDialog(MarkerView.this.getSite().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    private static interface ISectionPart {
        public Control createControl(Composite var1);

        public Control getControl();

        public void refresh();

        public void dispose();
    }

    private class ImportMarkerAction
    extends Action {
        public ImportMarkerAction() {
            super(MindMapMessages.ImportMarkers_text);
            this.setToolTipText(MindMapMessages.ImportMarkers_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("import_wiz.gif", true));
        }

        public void run() {
            MarkerImportWizard wizard = new MarkerImportWizard(false);
            wizard.init(PlatformUI.getWorkbench(), MarkerView.this.getCurrentSelection());
            WizardDialog dialog = new WizardDialog(MarkerView.this.getSite().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    private class MarkerAction
    extends Action {
        private IMarker marker;

        public MarkerAction(IMarker marker) {
            this.marker = marker;
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(marker, 32, 32));
            this.setToolTipText(marker.getName());
        }

        public IMarker getMarker() {
            return this.marker;
        }

        public void run() {
            EditDomain domain = this.getEditDomain();
            if (domain != null) {
                Request req = new Request("add marker");
                req.setParameter("markerId", (Object)this.marker.getId());
                domain.handleRequest(req);
                MindMapUI.getResourceManager().getRecentMarkerGroup().addMarker(this.marker);
            }
        }

        private EditDomain getEditDomain() {
            IGraphicalEditor ge;
            IGraphicalEditorPage gp;
            IEditorPart editor;
            IWorkbenchPage page = MarkerView.this.getSite().getPage();
            if (page != null && (editor = page.getActiveEditor()) != null && editor instanceof IGraphicalEditor && (gp = (ge = (IGraphicalEditor)editor).getActivePageInstance()) != null) {
                return gp.getEditDomain();
            }
            return null;
        }
    }

    private class MarkerGroupPart
    implements ISectionPart,
    ICoreEventListener {
        private IMarkerGroup group;
        private boolean hasTitle;
        private ToolBarManager toolbar = null;
        private Control control = null;
        private ICoreEventRegister eventRegister = null;

        public MarkerGroupPart(IMarkerGroup group) {
            this(group, true);
        }

        public MarkerGroupPart(IMarkerGroup group, boolean hasTitle) {
            this.group = group;
            this.hasTitle = hasTitle;
        }

        public IMarkerGroup getMarkerGroup() {
            return this.group;
        }

        public Control createControl(Composite parent) {
            if (this.control == null) {
                if (this.toolbar == null) {
                    this.toolbar = new ToolBarManager(8519744);
                }
                Composite c = MarkerView.this.factory.createComposite(parent);
                GridLayout layout = new GridLayout(1, true);
                layout.marginHeight = 2;
                layout.marginWidth = 2;
                c.setLayout((Layout)layout);
                if (this.hasTitle) {
                    MarkerView.this.factory.createLabel(c, this.group.getName());
                    layout.verticalSpacing = 0;
                } else {
                    layout.verticalSpacing = 2;
                }
                ToolBar tb = this.toolbar.createControl(c);
                GridData data = new GridData(768);
                data.widthHint = 250;
                tb.setLayoutData((Object)data);
                this.addDragSource(tb);
                this.control = c;
                this.refresh();
                this.installListeners();
                this.control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MarkerGroupPart.this.dispose();
                    }
                });
            }
            return this.control;
        }

        private void addDragSource(final ToolBar toolbar) {
            final DragSource dragSource = new DragSource((Control)toolbar, 1);
            dragSource.setTransfer(new Transfer[]{MindMapElementTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){
                ToolItem sourceItem;

                public void dragStart(DragSourceEvent event) {
                    this.sourceItem = toolbar.getItem(new Point(event.x, event.y));
                    if (this.sourceItem == null) {
                        event.doit = false;
                    } else {
                        event.image = this.sourceItem.getImage();
                    }
                }

                public void dragSetData(DragSourceEvent event) {
                    if (this.sourceItem == null) {
                        return;
                    }
                    int index = toolbar.indexOf(this.sourceItem);
                    IMarker marker = (IMarker)MarkerGroupPart.this.group.getMarkers().get(index);
                    event.data = new Object[]{marker};
                }

                public void dragFinished(DragSourceEvent event) {
                }
            });
            toolbar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dragSource.dispose();
                }
            });
        }

        private void installListeners() {
            if (this.group instanceof ICoreEventSource) {
                this.eventRegister = new CoreEventRegister((ICoreEventSource)this.group, (ICoreEventListener)this);
                this.eventRegister.register("markerAdd");
                this.eventRegister.register("markerRemove");
            }
        }

        private void uninstallListeners() {
            if (this.eventRegister != null) {
                this.eventRegister.unregisterAll();
            }
        }

        public Control getControl() {
            return this.control;
        }

        public void refresh() {
            if (this.toolbar == null || this.control == null || this.control.isDisposed()) {
                return;
            }
            this.toolbar.removeAll();
            for (IMarker marker : this.group.getMarkers()) {
                this.toolbar.add((IAction)new MarkerAction(marker));
            }
            this.toolbar.update(false);
            ToolBar tb = this.toolbar.getControl();
            GridData data = (GridData)tb.getLayoutData();
            data.exclude = this.toolbar.isEmpty();
            MarkerView.this.form.reflow(true);
        }

        public void dispose() {
            this.uninstallListeners();
            if (this.toolbar != null) {
                this.toolbar.dispose();
                this.toolbar = null;
            }
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
        }

        public void handleCoreEvent(CoreEvent event) {
            String type = event.getType();
            if ("markerAdd".equals(type) || "markerRemove".equals(type)) {
                this.refresh();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MarkerSheetPart
    implements ISectionPart,
    ICoreEventListener {
        private IMarkerSheet sheet;
        private Composite composite;
        private List<MarkerGroupPart> groupParts = new ArrayList<MarkerGroupPart>();
        private ICoreEventRegister eventRegister = null;

        public MarkerSheetPart(IMarkerSheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public Control getControl() {
            return this.composite;
        }

        @Override
        public Control createControl(Composite parent) {
            if (this.composite == null) {
                this.composite = this.createComposite(parent);
                this.refresh();
                this.installListeners();
                this.composite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MarkerSheetPart.this.dispose();
                    }
                });
            }
            return this.composite;
        }

        private Composite createComposite(Composite parent) {
            Composite composite = MarkerView.this.factory.createComposite(parent);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 1;
            layout.marginWidth = 1;
            layout.verticalSpacing = 7;
            composite.setLayout((Layout)layout);
            return composite;
        }

        @Override
        public void refresh() {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            this.composite.setRedraw(false);
            List newGroups = this.sheet.getMarkerGroups();
            int i = 0;
            while (i < newGroups.size()) {
                MarkerGroupPart part;
                IMarkerGroup g;
                IMarkerGroup group = (IMarkerGroup)newGroups.get(i);
                if (i >= this.groupParts.size() || !group.equals(g = (part = this.groupParts.get(i)).getMarkerGroup())) {
                    part = (MarkerGroupPart)MarkerView.this.groupToPart.get(group);
                    if (part != null) {
                        this.reorderChild(part, i);
                    } else {
                        part = this.createChild(group);
                        this.addChild(part, i);
                    }
                }
                ++i;
            }
            Object[] toTrim = this.groupParts.toArray();
            while (i < toTrim.length) {
                this.removeChild((MarkerGroupPart)toTrim[i]);
                ++i;
            }
            this.composite.setRedraw(true);
            MarkerView.this.form.reflow(true);
        }

        public List<MarkerGroupPart> getGroupParts() {
            return this.groupParts;
        }

        private void reorderChild(MarkerGroupPart part, int index) {
            Control c = part.getControl();
            if (c == null) {
                c = part.createControl(this.composite);
                c.setLayoutData((Object)new GridData(768));
            }
            this.groupParts.remove(part);
            this.groupParts.add(index, part);
            if (index == 0) {
                c.moveAbove(null);
            } else {
                MarkerGroupPart g = this.groupParts.get(index - 1);
                c.moveAbove(g.getControl());
            }
        }

        private MarkerGroupPart createChild(IMarkerGroup group) {
            MarkerGroupPart part = new MarkerGroupPart(group, true);
            MarkerView.this.groupToPart.put(group, part);
            return part;
        }

        private void addChild(MarkerGroupPart part, int index) {
            this.groupParts.add(index, part);
            Control c = part.createControl(this.composite);
            c.setLayoutData((Object)new GridData(768));
        }

        private void removeChild(MarkerGroupPart part) {
            this.groupParts.remove(part);
            MarkerView.this.groupToPart.remove(part.getMarkerGroup());
            part.dispose();
        }

        private void installListeners() {
            if (this.sheet instanceof ICoreEventSource) {
                this.eventRegister = new CoreEventRegister((ICoreEventSource)this.sheet, (ICoreEventListener)this);
                this.eventRegister.register("markerGroupAdd");
                this.eventRegister.register("markerGroupRemove");
            }
        }

        private void uninstallListeners() {
            if (this.eventRegister != null) {
                this.eventRegister.unregisterAll();
            }
        }

        @Override
        public void dispose() {
            this.uninstallListeners();
            if (this.composite != null) {
                this.composite.dispose();
                this.composite = null;
            }
            Object[] objectArray = this.groupParts.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                MarkerGroupPart groupPart = (MarkerGroupPart)o;
                MarkerView.this.groupToPart.remove(groupPart.getMarkerGroup());
                groupPart.dispose();
                ++n2;
            }
            this.groupParts.clear();
        }

        public void handleCoreEvent(CoreEvent event) {
            String type = event.getType();
            if ("markerGroupAdd".equals(type) || "markerGroupRemove".equals(type)) {
                this.refresh();
            }
        }
    }

    private class ShowMarkerManagerAction
    extends Action {
        public ShowMarkerManagerAction() {
            super(MindMapMessages.ShowMarkerManager_text);
            this.setToolTipText(MindMapMessages.ShowMarkerManager_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("add_marker.gif", true));
        }

        public void run() {
            PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.MarkersPrefPage", null, null).open();
        }
    }
}

