/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.draw2d.SelectionFigure;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.service.IAnimationService;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.branch.IInsertableBranchStructureExtension;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.internal.mindmap.DecoratedAnchor;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.tools.ITopicMoveToolHelper;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.tools.ToolHelperBase;

public class TopicMoveToolHelper
extends ToolHelperBase
implements ITopicMoveToolHelper {
    private IBranchPart parent = null;
    private boolean showConnection = true;
    private IBranchConnectionDecoration connection = null;
    private IFigure connectionFigure = null;
    private boolean cursorOverParent = false;
    private IFeedbackService feedbackService = null;
    private IAnimationService animationService = null;
    private IInsertion insertion = null;
    private IAnchor sourceAnchor = null;
    private IAnchorListener sourceAnchorListener = null;
    private DummyAnchor targetAnchor = null;
    private IAnchorListener targetAnchorListener = null;

    public void activate(EditDomain domain, IViewer viewer) {
        super.activate(domain, viewer);
        this.feedbackService = (IFeedbackService)viewer.getService(IFeedbackService.class);
        Layer layer = ((IGraphicalViewer)viewer).getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            this.createConnectionFigure((IFigure)layer);
        }
        this.animationService = (IAnimationService)viewer.getService(IAnimationService.class);
        if (this.animationService != null) {
            this.animationService.stop();
        }
    }

    public void deactivate(EditDomain domain, IViewer viewer) {
        if (this.connectionFigure != null) {
            if (this.connectionFigure.getParent() != null) {
                this.connectionFigure.getParent().remove(this.connectionFigure);
            }
            this.connectionFigure = null;
        }
        if (this.feedbackService != null) {
            if (this.parent != null && this.parent.getStatus().isActive()) {
                this.feedbackService.removeSelection(this.parent.getTopicPart().getFigure());
            }
            this.feedbackService = null;
        }
        if (this.animationService != null) {
            this.animationService.stop();
            this.animationService = null;
        }
        if (this.insertion != null) {
            this.insertion.pullOut();
            this.insertion = null;
        }
        this.setSourceAnchor(null);
        if (this.targetAnchor != null) {
            if (this.targetAnchorListener != null) {
                this.targetAnchor.removeAnchorListener(this.targetAnchorListener);
            }
            this.targetAnchor.setOwner(null);
            this.targetAnchor = null;
        }
        this.connection = null;
        this.parent = null;
        super.deactivate(domain, viewer);
    }

    public void update(IBranchPart targetParent, ParentSearchKey key) {
        IInsertion newInsertion;
        IInsertion oldInsertion;
        IBranchPart oldParent = this.parent;
        this.parent = targetParent;
        if (this.feedbackService != null && oldParent != null && oldParent.getStatus().isActive()) {
            this.feedbackService.removeSelection(oldParent.getTopicPart().getFigure());
        }
        IFigure parentTopicFigure = targetParent == null ? null : targetParent.getTopicPart().getFigure();
        this.cursorOverParent = parentTopicFigure != null && parentTopicFigure.containsPoint(key.getCursorPos());
        this.setSourceAnchor(targetParent == null ? null : targetParent.getConnections().getSourceAnchor());
        if (this.connectionFigure != null) {
            if (parentTopicFigure != null) {
                Rectangle bounds = parentTopicFigure.getBounds().getUnion(key.getFigure().getBounds()).expand(10, 10);
                this.connectionFigure.setBounds(bounds);
                this.connectionFigure.setVisible(targetParent != null);
            } else {
                this.connectionFigure.setVisible(false);
            }
            if (targetParent != null) {
                this.updateConnection(targetParent, key.getFeedback());
            }
        }
        if (this.feedbackService != null && parentTopicFigure != null) {
            SelectionFigure selectionFigure = this.feedbackService.addSelection(parentTopicFigure);
            selectionFigure.setPreselectionColor(ColorUtils.getColor((String)"#f00000"));
            selectionFigure.setPreselectionFillColor(ColorUtils.getColor((String)"#f00000"));
            selectionFigure.setPreselectionFillAlpha(16);
            selectionFigure.setPreselected(true);
        }
        if (!((oldInsertion = this.insertion) == (newInsertion = this.calcInsertion(this.parent, key)) || newInsertion != null && newInsertion.equals(oldInsertion))) {
            this.insertion = newInsertion;
            this.animInsertion(oldInsertion, newInsertion);
        }
    }

    private void setSourceAnchor(IAnchor anchor) {
        if (anchor == this.sourceAnchor) {
            return;
        }
        if (this.sourceAnchor != null && this.sourceAnchorListener != null) {
            this.sourceAnchor.removeAnchorListener(this.sourceAnchorListener);
        }
        this.sourceAnchor = anchor;
        if (anchor != null) {
            if (this.sourceAnchorListener == null) {
                this.sourceAnchorListener = new IAnchorListener(){

                    public void anchorMoved(IAnchor anchor) {
                        if (TopicMoveToolHelper.this.connection != null && TopicMoveToolHelper.this.connectionFigure != null) {
                            TopicMoveToolHelper.this.connection.reroute(TopicMoveToolHelper.this.connectionFigure);
                        }
                    }
                };
            }
            anchor.addAnchorListener(this.sourceAnchorListener);
        }
    }

    private void updateConnection(IBranchPart parent, IBranchPart feedback) {
        IBranchConnections connections = parent.getConnections();
        String connectionId = connections.getId();
        if (!StyleUtils.isSameDecoration((IDecoration)this.connection, connectionId)) {
            this.connection = StyleUtils.createBranchConnection(parent, connectionId);
        }
        if (this.connection != null) {
            this.connection.setId(connectionId);
            this.connection.setSourceAnchor(this.connectionFigure, this.sourceAnchor);
            if (this.targetAnchor == null) {
                this.targetAnchor = new DummyAnchor();
                if (this.targetAnchorListener == null) {
                    this.targetAnchorListener = new IAnchorListener(){

                        public void anchorMoved(IAnchor anchor) {
                            if (TopicMoveToolHelper.this.connection != null && TopicMoveToolHelper.this.connectionFigure != null) {
                                TopicMoveToolHelper.this.connection.reroute(TopicMoveToolHelper.this.connectionFigure);
                            }
                        }
                    };
                }
                this.targetAnchor.addAnchorListener(this.targetAnchorListener);
            }
            this.targetAnchor.setOwner(feedback.getTopicPart().getFigure());
            this.connection.setTargetAnchor(this.connectionFigure, (IAnchor)this.targetAnchor);
            this.connection.setLineStyle(this.connectionFigure, connections.getLineStyle());
            this.connection.setLineWidth(this.connectionFigure, Math.max(3, connections.getLineWidth()));
            this.connection.setSourceOrientation(this.connectionFigure, connections.getSourceOrientation());
            this.connection.setSourceExpansion(this.connectionFigure, connections.getSourceExpansion());
            int targetOrientation = 0;
            IStructure structure = parent.getBranchPolicy().getStructure(parent);
            if (structure instanceof IBranchStructureExtension) {
                targetOrientation = ((IBranchStructureExtension)structure).getChildTargetOrientation(parent, feedback);
            }
            this.connection.setTargetOrientation(this.connectionFigure, targetOrientation);
            this.connection.setTargetExpansion(this.connectionFigure, 0);
            this.connection.setLineColor(this.connectionFigure, ColorUtils.getColor((String)"#f00000"));
            if (this.connectionFigure.getParent() instanceof IUseTransparency) {
                this.connection.setAlpha(this.connectionFigure, ((IUseTransparency)this.connectionFigure.getParent()).getMainAlpha());
            }
            if (this.connection instanceof ICorneredDecoration) {
                ((ICorneredDecoration)this.connection).setCornerSize(this.connectionFigure, connections.getCornerSize());
            }
            this.connection.setVisible(this.connectionFigure, !this.cursorOverParent && this.connectionFigure.isVisible() && this.connection.getSourceAnchor() != null && this.connection.getTargetAnchor() != null);
            this.connection.reroute(this.connectionFigure);
        }
    }

    public boolean isShowConnection() {
        return this.showConnection;
    }

    public void setShowConnection(boolean showConnection) {
        this.showConnection = showConnection;
    }

    protected void createConnectionFigure(IFigure layer) {
        if (layer != null && this.showConnection) {
            this.connectionFigure = new DummyConnectionFigure();
            layer.add(this.connectionFigure);
        }
    }

    private IInsertion calcInsertion(IBranchPart parent, ParentSearchKey key) {
        IStructure structure;
        UpdateManager um = key.getFigure().getUpdateManager();
        if (um != null) {
            um.performValidation();
        }
        if (parent != null && (structure = parent.getBranchPolicy().getStructure(parent)) instanceof IInsertableBranchStructureExtension) {
            return ((IInsertableBranchStructureExtension)structure).calcInsertion(parent, key);
        }
        return null;
    }

    private void animInsertion(final IInsertion oldInsertion, final IInsertion newInsertion) {
        Runnable job = new Runnable(){

            public void run() {
                if (oldInsertion != null) {
                    oldInsertion.pullOut();
                }
                if (newInsertion != null) {
                    newInsertion.pushIn();
                }
            }
        };
        if (MindMapUI.isAnimationEnabled() && this.animationService != null && this.animationService.isActive()) {
            this.animationService.start(job, null, null);
        } else {
            job.run();
        }
    }

    private class DummyAnchor
    extends DecoratedAnchor {
        public DummyAnchor() {
            super(null);
        }

        public void setOwner(IFigure figure) {
            super.setOwner(figure);
        }
    }

    private class DummyConnectionFigure
    extends Figure {
        private DummyConnectionFigure() {
        }

        public void paintFigure(Graphics graphics) {
            graphics.setAntialias(1);
            if (TopicMoveToolHelper.this.parent != null) {
                if (TopicMoveToolHelper.this.connection != null) {
                    TopicMoveToolHelper.this.connection.paint((IFigure)this, graphics);
                }
                if (!TopicMoveToolHelper.this.cursorOverParent) {
                    this.paintExpandedLine(graphics, TopicMoveToolHelper.this.parent);
                }
            }
            super.paintFigure(graphics);
        }

        private void paintExpandedLine(Graphics graphics, IBranchPart parent) {
            IBranchConnections connections = parent.getConnections();
            if (connections == null) {
                return;
            }
            int orientation = connections.getSourceOrientation();
            if (orientation == 0) {
                return;
            }
            IAnchor anc = connections.getSourceAnchor();
            if (anc == null) {
                return;
            }
            PrecisionPoint p1 = anc.getLocation(orientation, 0.0);
            PrecisionPoint p2 = anc.getLocation(orientation, (double)connections.getSourceExpansion());
            graphics.setLineStyle(1);
            graphics.setLineWidth(Math.max(3, connections.getLineWidth()));
            graphics.setForegroundColor(ColorUtils.getColor((String)"#f00000"));
            graphics.setAlpha(connections.getAlpha());
            org.xmind.gef.draw2d.graphics.Path p = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            p.moveTo(p1);
            p.lineTo(p2);
            graphics.drawPath((Path)p);
            p.dispose();
        }
    }
}

