/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.IRelationshipEnd;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.tools.RelationshipDummy;
import org.xmind.ui.mindmap.IMindMapImages;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tools.DummyCreateTool;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.SWTUtils;

public class RelationshipCreateTool
extends DummyCreateTool {
    private IPart sourceNode = null;
    private IPart targetNode = null;
    private Point targetPosition = null;
    private RelationshipDummy relDummy = null;

    protected boolean shouldCancel(KeyEvent ke) {
        return SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)27);
    }

    protected boolean canCancelOnRightMouseDown(MouseEvent me) {
        return true;
    }

    protected boolean canFinishOnLeftMouseDown(MouseEvent me) {
        IPart host = me.target;
        if (this.sourceNode == null) {
            this.sourceNode = this.getRelationshipEndPart(host);
            if (this.sourceNode != null) {
                this.createDummy();
            }
        } else if (this.targetNode == null || this.targetPosition == null) {
            if (host == null || host instanceof IRootPart || host instanceof ISheetPart) {
                Point origin;
                IFigure figure;
                this.targetPosition = me.cursorLocation;
                ISheetPart sheet = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class);
                if (sheet != null && (figure = sheet.getFigure()) instanceof IOriginBased && (origin = ((IOriginBased)figure).getOrigin()) != null) {
                    this.targetPosition = new Point(this.targetPosition.x - origin.x, this.targetPosition.y - origin.y);
                }
            } else {
                IPart node = this.getRelationshipEndPart(host);
                if (node != null && node != this.sourceNode) {
                    this.targetNode = node;
                }
            }
        }
        return this.canFinish();
    }

    protected IFigure doCreateDummy() {
        Layer layer;
        if (this.relDummy == null && this.sourceNode instanceof IGraphicalPart && (layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION)) != null) {
            this.relDummy = new RelationshipDummy((IFigure)layer, (IGraphicalPart)this.sourceNode, this.getCursorPosition(), this.getTargetViewer());
        }
        if (this.relDummy != null) {
            return this.relDummy.getRelDummy().getFigure();
        }
        return null;
    }

    protected void destroyDummy() {
        if (this.relDummy != null) {
            this.relDummy.dispose();
            this.relDummy = null;
        }
        super.destroyDummy();
    }

    private IPart getRelationshipEndPart(IPart part) {
        Object m;
        if (part != null && part instanceof IPart && (m = MindMapUtils.getRealModel(part)) instanceof IRelationshipEnd) {
            return part;
        }
        return null;
    }

    protected boolean canFinish(String requestType) {
        return this.canFinish();
    }

    private boolean canFinish() {
        return this.sourceNode != null && (this.targetNode != null || this.targetPosition != null);
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        List selectedParts = this.getSelectedParts((IViewer)this.getTargetViewer());
        IPart sourceNode = null;
        for (IPart p : selectedParts) {
            sourceNode = this.getRelationshipEndPart(p);
            if (sourceNode != null) break;
        }
        this.getTargetViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        if (sourceNode != null) {
            this.sourceNode = sourceNode;
            this.createDummy();
        }
    }

    protected boolean handleMouseEntered(MouseEvent me) {
        boolean ret = super.handleMouseEntered(me);
        IPart node = this.getRelationshipEndPart(me.target);
        if (node != null) {
            this.getTargetViewer().setPreselected((Object)node);
        }
        return ret;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.getRelationshipEndPart(host) != null) {
            return Cursors.HAND;
        }
        return MindMapUI.getImages().getCursor(IMindMapImages.CURSOR_RELATIONSHIP);
    }

    protected void recover() {
        super.recover();
        this.sourceNode = null;
        this.targetNode = null;
        this.targetPosition = null;
    }

    protected Request createRequest() {
        ISheetPart sheet;
        if (this.sourceNode != null && (sheet = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class)) != null) {
            Request request = new Request("create relationship");
            request.setDomain(this.getDomain());
            request.setViewer((IViewer)this.getTargetViewer());
            request.setPrimaryTarget((IPart)sheet);
            request.setParameter("sourceNode", (Object)this.sourceNode);
            if (this.targetNode != null) {
                request.setParameter("targetNode", (Object)this.targetNode);
            } else if (this.targetPosition != null) {
                request.setParameter("position", (Object)this.targetPosition);
            }
            return request;
        }
        return null;
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        boolean ret = super.handleMouseDrag(me);
        if (this.getDummy() != null) {
            this.updateDummyPosition(this.getDummy(), this.getCursorPosition());
        }
        return ret;
    }

    protected void updateDummyPosition(IFigure dummy, Point pos) {
        if (this.relDummy != null) {
            IFigure fig = this.relDummy.getTargetNodeDummy().getFigure();
            if (fig instanceof IReferencedFigure) {
                ((IReferencedFigure)fig).setReference(pos);
            } else {
                fig.setLocation(pos);
            }
        }
    }

    protected boolean handleMouseUp(MouseEvent me) {
        IPart node;
        boolean ret = super.handleMouseUp(me);
        if (this.sourceNode != null && this.targetNode == null && this.targetPosition == null && (node = this.getRelationshipEndPart(me.target)) != null && node != this.sourceNode) {
            this.targetNode = node;
            if (this.canFinish()) {
                this.finish();
            }
        }
        return ret;
    }
}

