/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.event.DragDropEvent;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.tool.AbstractTool;
import org.xmind.gef.tool.IDragDropHandler;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;
import org.xmind.ui.branch.IBranchDoubleClickSupport;
import org.xmind.ui.branch.IBranchMoveSupport;
import org.xmind.ui.internal.actions.GroupMarkers;
import org.xmind.ui.internal.dialogs.HyperlinkDialog2;
import org.xmind.ui.internal.mindmap.IconTipPart;
import org.xmind.ui.internal.mindmap.MindMapRevealService;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.SWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapSelectTool
extends SelectTool {
    private IBranchPart movingSourceBranch = null;

    public MindMapSelectTool() {
        this.setContextId("org.xmind.ui.context.mindmap.edit");
    }

    public String getType() {
        return "select tool";
    }

    public boolean handleMouseDown(MouseEvent me) {
        if (me.target instanceof IPlusMinusPart && me.target.getParent() instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)me.target.getParent();
            this.handleMouseDownOnPlusMinus(me, branch);
            return true;
        }
        return super.handleMouseDown(me);
    }

    protected void handleMouseDownOnPlusMinus(MouseEvent me, IBranchPart branch) {
        this.getStatus().setStatus(64, true);
        this.getStatus().setStatus(256, !me.leftOrRight);
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            this.selectSingle((IPart)topic);
        }
        this.sendFoldedRequest(branch);
        me.consume();
    }

    protected void sendFoldedRequest(IBranchPart branch) {
        String reqType = branch.getTopic().isFolded() ? "extend" : "collapse";
        Request request = new Request(reqType);
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)branch);
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        this.handleRequest(request);
    }

    public boolean handleMouseUp(final MouseEvent me) {
        if (me.target instanceof IconTipPart) {
            if (me.leftOrRight) {
                this.getStatus().setStatus(2048, false);
                this.getStatus().setStatus(64, false);
                if (!me.leftOrRight) {
                    this.getStatus().setStatus(256, false);
                }
                IconTipPart iconTip = (IconTipPart)me.target;
                this.selectSingle((IPart)iconTip.getTopicPart());
                final IAction iconTipAction = iconTip.getAction();
                if (iconTipAction != null) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            iconTipAction.run();
                            me.consume();
                        }
                    });
                    if (me.isConsumed()) {
                        this.setToSelectOnMouseUp(null);
                        return true;
                    }
                }
            }
        } else if (me.target instanceof IMarkerPart && me.leftOrRight) {
            this.showMarkerMenu((IMarkerPart)me.target);
        }
        return super.handleMouseUp(me);
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        if (me.leftOrRight && (me.target == null || me.target == this.getTargetViewer().getRootPart() || me.target instanceof ISheetPart)) {
            IBranchPart branch = this.findBranch((IPart)this.getTargetViewer().getRootPart(), me.cursorLocation);
            if (branch == null || !this.handleDoubleClickOnBranch(branch, me.cursorLocation)) {
                this.handleCreateFloatingTopicRequest(me.cursorLocation);
            }
            me.consume();
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    private IBranchPart findBranch(IPart part, Point pos) {
        if (!part.getStatus().isActive()) {
            return null;
        }
        if (part instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)part;
            if (branch.getFigure().isVisible() && branch.getFigure().containsPoint(pos)) {
                if (branch.canSearchChild()) {
                    IBranchPart b;
                    for (IBranchPart sub : branch.getSubBranches()) {
                        b = this.findBranch((IPart)sub, pos);
                        if (b == null) continue;
                        return b;
                    }
                    for (IBranchPart sub : branch.getSummaryBranches()) {
                        b = this.findBranch((IPart)sub, pos);
                        if (b == null) continue;
                        return b;
                    }
                }
                return branch;
            }
        } else if (!(part instanceof IGraphicalPart) || ((IGraphicalPart)part).getFigure().isVisible()) {
            for (IPart child : part.getChildren()) {
                IBranchPart branch = this.findBranch(child, pos);
                if (branch == null) continue;
                return branch;
            }
        }
        return null;
    }

    private boolean handleDoubleClickOnBranch(IBranchPart branch, Point pos) {
        do {
            IStructure structure;
            if (!((structure = branch.getBranchPolicy().getStructure(branch)) instanceof IBranchDoubleClickSupport) || !((IBranchDoubleClickSupport)structure).handleDoubleClick(branch, pos)) continue;
            return true;
        } while ((branch = branch.getParentBranch()) != null);
        return false;
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        boolean handled = super.handleKeyDown(ke);
        if (!handled) {
            int keyCode = ke.keyCode;
            int stateMask = ke.getState();
            IPart p = this.getTargetViewer().getFocusedPart();
            if (p != null && p.hasRole("editable role") && (MindMapUtils.isTopicTextChar(ke.character) || keyCode == 229)) {
                ITool activeTool;
                Request req = new Request("edit");
                req.setDomain(this.getDomain());
                req.setViewer((IViewer)this.getTargetViewer());
                this.startEditing(p, req);
                if (!SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)32) && (activeTool = this.getDomain().getActiveTool()) != this) {
                    activeTool.keyDown(ke, (IViewer)this.getTargetViewer());
                }
                return true;
            }
        }
        return handled;
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        this.movingSourceBranch = null;
        return super.handleMouseDrag(me);
    }

    protected boolean canMove(IPart host, MouseDragEvent me) {
        IBranchPart branch;
        boolean canMove = super.canMove(host, me);
        if (!canMove && (branch = this.findBranch(host, me.startingLocation)) != null) {
            return this.canMoveInBranch(branch, me);
        }
        return canMove;
    }

    private boolean canMoveInBranch(IBranchPart branch, MouseDragEvent me) {
        do {
            IStructure structure;
            if (!((structure = branch.getBranchPolicy().getStructure(branch)) instanceof IBranchMoveSupport)) continue;
            boolean canMove = ((IBranchMoveSupport)structure).canMove(branch, me);
            if (canMove) {
                this.movingSourceBranch = branch;
            }
            return canMove;
        } while ((branch = branch.getParentBranch()) != null);
        return false;
    }

    protected String getMoveTool(IPart source, MouseDragEvent me) {
        if (this.movingSourceBranch != null) {
            return ((IBranchMoveSupport)this.movingSourceBranch.getBranchPolicy().getStructure(this.movingSourceBranch)).getMoveTool(this.movingSourceBranch, me);
        }
        if (source instanceof ITopicPart) {
            return "org.xmind.ui.tool.moveTopic";
        }
        if (source instanceof IRelationshipPart) {
            return "org.xmind.ui.tool.moveRelationship";
        }
        if (source instanceof IBranchRangePart) {
            return "org.xmind.ui.tool.resizeRange";
        }
        if (source instanceof IMarkerPart) {
            return "org.xmind.ui.tool.moveMarker";
        }
        if (source instanceof IImagePart) {
            int orientation;
            IImagePart imagePart = (IImagePart)source;
            Object feedback = imagePart.getAdapter(IFeedback.class);
            if (feedback instanceof IBendPointsFeedback && (orientation = ((IBendPointsFeedback)feedback).getOrientation(me.startingLocation)) == 0) {
                return "org.xmind.ui.tool.moveImage";
            }
            return "org.xmind.ui.tool.resizeImage";
        }
        if (source instanceof ILegendPart || source instanceof ILegendItemPart) {
            return "org.xmind.ui.tool.moveLegend";
        }
        return super.getMoveTool(source, me);
    }

    protected void changeToMoveTool(String moveToolType, ITool moveTool, IPart dragSource, MouseDragEvent me) {
        if ("move tool".equals(moveToolType)) {
            if (!this.canMove(dragSource, me)) {
                return;
            }
            if (!dragSource.getStatus().isSelected()) {
                this.selectSingle(dragSource);
            }
            this.getTargetViewer().setFocused((Object)dragSource);
        }
        if (this.movingSourceBranch != null) {
            super.changeToMoveTool(moveToolType, moveTool, (IPart)this.movingSourceBranch, me);
        } else {
            super.changeToMoveTool(moveToolType, moveTool, dragSource, me);
        }
        this.movingSourceBranch = null;
    }

    protected List<IPart> getSequenceParts(IPart start, IPart end) {
        return MindMapUtils.getSequenceTopics(start, end);
    }

    protected Request fillTargets(Request request, IViewer viewer, boolean includeRootPartIfEmpty) {
        return super.fillTargets(request, viewer, includeRootPartIfEmpty).setParameter("withAnimation", (Object)Boolean.TRUE);
    }

    protected void handleNonTargetedRequest(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer != null) {
            String requestType = request.getType();
            if ("create floating".equals(requestType)) {
                this.handleCreateFloatingTopic(request, viewer);
                return;
            }
            if ("select brothers".equals(requestType)) {
                this.handleSelectBrothers(request);
                return;
            }
            if ("select children".equals(requestType)) {
                this.handleSelectChildren(request);
                return;
            }
            if ("select central".equals(requestType)) {
                this.handleSelectCentral(request);
                return;
            }
            if ("extend all".equals(requestType) || "collapse all".equals(requestType)) {
                request = this.createExtendOrCollapseAllRequest(request, viewer);
            } else {
                if ("select central".equals(requestType)) {
                    this.handleSelectCentral(viewer);
                    return;
                }
                if ("modify hyperlink".equals(requestType)) {
                    request = this.createModifyHyperlinkRequest(request, viewer);
                } else if ("add attachment".equals(requestType)) {
                    request = this.createAddAttachmentRequest(request, viewer);
                } else {
                    if ("create relationship".equals(requestType)) {
                        this.handleCreateRelationship(requestType, viewer);
                        return;
                    }
                    if ("create boundary".equals(requestType)) {
                        request = this.createCreateBoundaryRequest(request, viewer);
                    } else if ("create summary".equals(requestType)) {
                        request = this.createCreateSummaryRequest(request, viewer);
                    } else {
                        if ("edit label".equals(requestType)) {
                            this.handleEditLabelRequest(request, viewer);
                            return;
                        }
                        if ("drill down".equals(requestType)) {
                            this.handleDrillDown(viewer);
                            return;
                        }
                        if ("drill up".equals(requestType)) {
                            this.handleDrillUp(viewer);
                            return;
                        }
                        if ("traverse".equals(requestType)) {
                            this.handleTraverse(viewer);
                            return;
                        }
                    }
                }
            }
            if (request == null) {
                return;
            }
            if (request.hasTargets()) {
                this.handleTargetedRequest(request);
                return;
            }
        }
        super.handleNonTargetedRequest(request);
    }

    private void handleCreateFloatingTopic(Request request, IViewer viewer) {
        this.changeActiveTool("org.xmind.ui.tool.createFloatingTopic");
        ITool activeTool = this.getDomain().getActiveTool();
        if (activeTool != null && activeTool != this) {
            activeTool.handleRequest(request);
        }
    }

    private void handleSelectCentral(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        ITopicPart centralTopic = (ITopicPart)viewer.getAdapter(ITopicPart.class);
        if (centralTopic == null) {
            return;
        }
        IRevealService service = (IRevealService)viewer.getService(IRevealService.class);
        if (service instanceof MindMapRevealService) {
            ((MindMapRevealService)service).startCenteredReveal();
        }
        this.select(Arrays.asList(centralTopic), (IPart)centralTopic);
    }

    private void handleSelectBrothers(Request request) {
        List parts = this.getSelectedParts(request.getTargetViewer());
        ArrayList<ITopicPart> toSelect = new ArrayList<ITopicPart>();
        for (IPart p : parts) {
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null) continue;
            this.collectBrothers(branch, toSelect);
        }
        if (!toSelect.isEmpty()) {
            this.select(toSelect, (IPart)toSelect.get(0));
        }
    }

    private void collectBrothers(IBranchPart branch, List<ITopicPart> toSelect) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            for (IBranchPart child : parent.getSubBranches()) {
                toSelect.add(child.getTopicPart());
            }
        }
    }

    private void handleSelectChildren(Request request) {
        List parts = this.getSelectedParts(request.getTargetViewer());
        ArrayList<ITopicPart> toSelect = new ArrayList<ITopicPart>();
        for (IPart p : parts) {
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null) continue;
            this.collectChildren(branch, toSelect);
        }
        if (!toSelect.isEmpty()) {
            this.select(toSelect, (IPart)toSelect.get(0));
        }
    }

    private void collectChildren(IBranchPart branch, List<ITopicPart> toSelect) {
        for (IBranchPart child : branch.getSubBranches()) {
            toSelect.add(child.getTopicPart());
        }
    }

    private void handleTraverse(IViewer viewer) {
        IPart focusedPart = viewer.getFocusedPart();
        if (focusedPart != null && focusedPart instanceof IGraphicalEditPart && focusedPart.getStatus().isActive() && focusedPart.hasRole("traversable role")) {
            IGraphicalEditPart source = (IGraphicalEditPart)focusedPart;
            ITool tool = this.getTool("traverse tool");
            if (tool != null) {
                if (tool instanceof ISourceTool) {
                    ((ISourceTool)tool).setSource(source);
                }
                this.changeActiveTool("traverse tool");
            }
        }
    }

    protected void handleTargetedRequest(Request request) {
        ISheetPart sheet;
        String requestType = request.getType();
        if ("drill down".equals(requestType)) {
            this.handleDrillDown(request.getTargetViewer(), request.getTargets());
            return;
        }
        if ("show legend".equals(requestType) && request.getPrimaryTarget() instanceof ISheetPart && !(sheet = (ISheetPart)request.getPrimaryTarget()).getSheet().getLegend().hasPosition()) {
            this.createLegend(request);
            return;
        }
        super.handleTargetedRequest(request);
    }

    protected void navigateTo(List<IPart> toSelect, boolean sequential) {
        List<IBranchPart> branchesToExpand = this.findBranchesNeedsExpand(toSelect);
        if (branchesToExpand != null && !branchesToExpand.isEmpty()) {
            this.expand(branchesToExpand);
        }
        if (!this.canNavigateTo(toSelect)) {
            return;
        }
        super.navigateTo(toSelect, sequential);
    }

    protected boolean canNavigateTo(List<IPart> toSelect) {
        for (IPart p : toSelect) {
            IFigure figure;
            if (!(p instanceof IGraphicalPart) || (figure = ((IGraphicalPart)p).getFigure()).isVisible()) continue;
            return false;
        }
        return true;
    }

    protected List<IBranchPart> findBranchesNeedsExpand(List<IPart> parts) {
        ArrayList<IBranchPart> branches = null;
        for (IPart p : parts) {
            IBranchPart toExpand;
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null || (toExpand = this.findBranchNeedsExpand(branch)) == null) continue;
            if (branches == null) {
                branches = new ArrayList<IBranchPart>();
            }
            branches.add(toExpand);
        }
        return branches;
    }

    private IBranchPart findBranchNeedsExpand(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            if (parent.isFolded()) {
                return parent;
            }
            return this.findBranchNeedsExpand(parent);
        }
        return null;
    }

    protected void expand(List<IBranchPart> branches) {
        this.handleSingleRequest(new Request("extend").setTargets(branches));
    }

    protected Request createAddAttachmentRequest(Request request, IViewer viewer) {
        List<ITopicPart> topics = this.getTopicParts(this.getSelectedParts(viewer));
        if (topics.isEmpty()) {
            return request;
        }
        FileDialog dialog = new FileDialog(viewer.getControl().getShell(), 4098);
        String ret = dialog.open();
        if (ret == null) {
            return request;
        }
        String parentPath = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        ArrayList<String> paths = new ArrayList<String>(fileNames.length);
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String path = new File(parentPath, fileName).getAbsolutePath();
            paths.add(path);
            ++n2;
        }
        request.setTargets(topics);
        request.setParameter("paths", (Object)paths.toArray(new String[0]));
        return request;
    }

    protected Request createModifyHyperlinkRequest(Request request, IViewer viewer) {
        List<ITopicPart> topics = this.getTopicParts(this.getSelectedParts(viewer));
        if (topics.isEmpty()) {
            return null;
        }
        if (request.hasParameter("text")) {
            return request.setTargets(topics);
        }
        Shell parentShell = viewer.getControl().getShell();
        HyperlinkDialog2 dialog = new HyperlinkDialog2(parentShell, (IStructuredSelection)new StructuredSelection(topics));
        int retCode = dialog.open();
        if (retCode == 0) {
            return request.setTargets(topics).setParameter("text", (Object)dialog.getValue());
        }
        if (retCode == 3) {
            return request.setTargets(topics).setParameter("text", null);
        }
        return null;
    }

    protected List<ITopicPart> getTopicParts(List<IPart> parts) {
        ArrayList<ITopicPart> topics = new ArrayList<ITopicPart>(parts.size());
        for (IPart p : parts) {
            if (!(p instanceof ITopicPart)) continue;
            topics.add((ITopicPart)p);
        }
        topics.trimToSize();
        return topics;
    }

    protected void handleSelectCentral(IViewer viewer) {
        ITopic centralTopic = (ITopic)viewer.getAdapter(ITopic.class);
        if (centralTopic != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)centralTopic));
        }
    }

    protected Request createExtendOrCollapseAllRequest(Request request, IViewer viewer) {
        ArrayList<IBranchPart> selectedParts = this.getSelectedParts(viewer);
        if (this.isSheetSelected((List<IPart>)selectedParts, viewer)) {
            ISheetPart sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class);
            if (sheet == null) {
                return request;
            }
            IBranchPart centralBranch = sheet.getCentralBranch();
            if (centralBranch == null) {
                return request;
            }
            selectedParts = new ArrayList<IBranchPart>();
            selectedParts.add(centralBranch);
            selectedParts.addAll(sheet.getFloatingBranches());
        }
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        request.setTargets((List)selectedParts);
        return request;
    }

    protected boolean isSheetSelected(List<IPart> parts, IViewer viewer) {
        if (parts.isEmpty()) {
            return true;
        }
        for (IPart p : parts) {
            if (!(p instanceof ISheetPart) && p != viewer.getRootPart()) continue;
            return true;
        }
        return false;
    }

    protected void handleCreateFloatingTopicRequest(Point location) {
        if (location == null) {
            return;
        }
        ISheetPart sheet = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class);
        if (sheet == null) {
            return;
        }
        Point position = new Point();
        IFigure figure = sheet.getFigure();
        if (figure instanceof IOriginBased) {
            Point origin = ((IOriginBased)figure).getOrigin();
            position.setLocation(location.x - origin.x, location.y - origin.y);
        }
        Request request = new Request("create floating");
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)sheet);
        request.setParameter("position", (Object)position);
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        this.handleRequest(request);
    }

    protected boolean isSelectableOnSelectAll(IPart child) {
        if (!(child instanceof ITopicPart)) {
            return false;
        }
        return super.isSelectableOnSelectAll(child);
    }

    protected void handleCreateRelationship(String reqType, IViewer viewer) {
        ITool next = this.getTool("org.xmind.ui.tool.createRelationship");
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).setTargetViewer(viewer);
        }
        this.changeActiveTool("org.xmind.ui.tool.createRelationship");
    }

    protected Request createCreateBoundaryRequest(Request request, IViewer viewer) {
        List selectedParts = this.getSelectedParts(viewer);
        List<ITopic> topics = MindMapUtils.getTopics(selectedParts);
        if (!topics.isEmpty()) {
            List<IPart> parts = MindMapUtils.getParts(topics, viewer);
            request.setTargets(parts);
            request.setParameter("withAnimation", (Object)Boolean.TRUE);
            return request;
        }
        ITool next = this.getTool("org.xmind.ui.tool.createBoundary");
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).setTargetViewer(viewer);
        }
        this.changeActiveTool("org.xmind.ui.tool.createBoundary");
        return null;
    }

    private Request createCreateSummaryRequest(Request request, IViewer viewer) {
        List selectedParts = this.getSelectedParts((IViewer)this.getTargetViewer());
        List<ITopic> topics = MindMapUtils.getTopics(selectedParts);
        if (!topics.isEmpty()) {
            List<IPart> parts = MindMapUtils.getParts(topics, (IViewer)this.getTargetViewer());
            request.setTargets(parts);
            request.setParameter("withAnimation", (Object)Boolean.TRUE);
            return request;
        }
        ITool next = this.getTool("org.xmind.ui.tool.createSummary");
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).setTargetViewer(viewer);
        }
        this.changeActiveTool("org.xmind.ui.tool.createSummary");
        return null;
    }

    protected void handleDrillDown(IViewer viewer) {
        Object obj;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
            ITopic rootTopic = (ITopic)obj;
            this.drillDown(viewer, sheet, rootTopic);
        }
    }

    private void handleDrillDown(IViewer viewer, List<IPart> sources) {
        if (sources.isEmpty()) {
            return;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        IPart p = sources.get(0);
        Object m = MindMapUtils.getRealModel(p);
        if (m instanceof ITopic) {
            this.drillDown(viewer, sheet, (ITopic)m);
            if (viewer.getEditDomain() != null) {
                viewer.getEditDomain().handleRequest("select central", viewer);
            }
        }
    }

    private void drillDown(IViewer viewer, ISheet sheet, ITopic newRoot) {
        MindMap newInput = new MindMap(sheet, newRoot);
        viewer.setInput((Object)newInput);
    }

    protected void handleDrillUp(IViewer viewer) {
        IDrillDownTraceService traceService;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null && (traceService = (IDrillDownTraceService)viewer.getService(IDrillDownTraceService.class)) != null) {
            ITopic newRoot = traceService.getPreviousCentralTopic();
            this.drillDown(viewer, sheet, newRoot);
        }
    }

    private void createLegend(Request request) {
        this.changeActiveTool("org.xmind.ui.tool.createLegend");
    }

    protected void handleEditLabelRequest(Request request, IViewer viewer) {
        this.handleEditRequest(this.fillTargets(request, viewer, false));
    }

    protected String getEditTool(IPart source, Request request) {
        String requestType;
        String string = requestType = request == null ? null : request.getType();
        if (source instanceof ITopicPart) {
            if ("edit label".equals(requestType)) {
                return "org.xmind.ui.tool.editLabel";
            }
            return "org.xmind.ui.tool.editTopicTitle";
        }
        if (source instanceof ILegendItemPart) {
            return "org.xmind.ui.tool.editLegendItem";
        }
        return super.getEditTool(source, request);
    }

    protected Request createEditRequestOnDoubleClick(IPart source, MouseEvent me) {
        if (source instanceof ILabelPart) {
            ITopicPart topic;
            ILabelPart label = (ILabelPart)source;
            IBranchPart branch = label.getOwnedBranch();
            if (branch != null && (topic = branch.getTopicPart()) != null) {
                return new Request("edit label").setPrimaryTarget((IPart)topic).setDomain(this.getDomain()).setViewer((IViewer)this.getTargetViewer());
            }
        } else if (source instanceof ILegendItemPart) {
            ILegendItemPart item = (ILegendItemPart)source;
            return new Request("edit legend item").setPrimaryTarget((IPart)item).setDomain(this.getDomain()).setViewer((IViewer)this.getTargetViewer());
        }
        return super.createEditRequestOnDoubleClick(source, me);
    }

    protected boolean handleDragStarted(DragDropEvent de) {
        ITool dndTool = this.getTool("dnd tool");
        if (dndTool != null) {
            this.changeActiveTool("dnd tool");
            if (this.getDomain().getActiveTool() == dndTool && dndTool instanceof IDragDropHandler) {
                ((IDragDropHandler)dndTool).dragStarted(de, (IViewer)this.getTargetViewer());
            }
            return true;
        }
        return super.handleDragStarted(de);
    }

    protected void showMarkerMenu(IMarkerPart target) {
        if (this.getTargetViewer() == null || this.getTargetViewer().getEditDomain() == null || this.getTargetViewer().getEditDomain().getCommandStack() == null) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        GroupMarkers markersItem = new GroupMarkers();
        markersItem.setSourceMarkerRef(target.getMarkerRef());
        markersItem.setSelectionProvider((ISelectionProvider)this.getTargetViewer());
        menuManager.add((IContributionItem)markersItem);
        final Menu menu = menuManager.createContextMenu(this.getTargetViewer().getControl());
        Point p = this.getTargetViewer().computeToDisplay(target.getFigure().getBounds().getBottomLeft(), true);
        menu.setLocation(p.x, p.y);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        menu.dispose();
                    }
                });
            }
        });
        menu.getDisplay().asyncExec(new Runnable(){

            public void run() {
                menu.setVisible(true);
            }
        });
    }
}

