/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.gef.Request;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.internal.properties.DecorationLabelProvider;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.viewers.MComboViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicShapePropertySectionPart
extends StyledPropertySectionPart {
    private static List<IDecorationDescriptor> TopicShapes;
    private MComboViewer shapeViewer;
    private ColorPicker fillColorPicker;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        line1.setLayout((Layout)layout);
        this.createLineContent(line1);
    }

    private void createLineContent(Composite parent) {
        this.shapeViewer = new MComboViewer(parent, 0);
        this.shapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.shapeViewer.getControl().setToolTipText(PropertyMessages.TopicShape_toolTip);
        this.shapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.shapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.shapeViewer.setInput(TopicShapePropertySectionPart.getTopicShapes());
        this.shapeViewer.addSelectionChangedListener((ISelectionChangedListener)new ShapeSelectionChangedListener());
        this.fillColorPicker = new ColorPicker(7, PaletteContents.getDefault());
        this.fillColorPicker.getAction().setToolTipText(PropertyMessages.TopicFillColor_toolTip);
        this.fillColorPicker.addOpenListener((IOpenListener)new FillColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.fillColorPicker);
        ToolBar barControl = colorBar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    public void setFocus() {
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            this.shapeViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.shapeViewer = null;
        this.fillColorPicker = null;
    }

    @Override
    protected void doRefresh() {
        String shapeId = null;
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            shapeId = this.getStyleValue("shape-class", null);
            IDecorationDescriptor element = this.getSelectableShape(shapeId);
            if (element == null) {
                this.shapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.shapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        }
        if (this.fillColorPicker != null) {
            if (shapeId == null) {
                shapeId = this.getStyleValue("shape-class", null);
            }
            this.updateColorPicker(this.fillColorPicker, "svg:fill", shapeId);
        }
    }

    private IDecorationDescriptor getSelectableShape(String shapeId) {
        if (shapeId == null) {
            return null;
        }
        IDecorationDescriptor descriptor = MindMapUI.getDecorationManager().getDecorationDescriptor(shapeId);
        if (!TopicShapePropertySectionPart.getTopicShapes().contains(descriptor)) {
            return null;
        }
        return descriptor;
    }

    private void changeShape(String newShape) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyTopicShape);
        this.addStyle(request, "shape-class", newShape);
        this.sendRequest(request);
    }

    protected void changeFillColor(IColorSelection selection) {
        this.changeColor(selection, "svg:fill", CommandMessages.Command_ModifyFillColor);
    }

    private static List<IDecorationDescriptor> getTopicShapes() {
        if (TopicShapes == null) {
            TopicShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.topicDecorations");
        }
        return TopicShapes;
    }

    private class FillColorOpenListener
    implements IOpenListener {
        private FillColorOpenListener() {
        }

        public void open(OpenEvent event) {
            TopicShapePropertySectionPart.this.changeFillColor((IColorSelection)event.getSelection());
        }
    }

    private class ShapeSelectionChangedListener
    implements ISelectionChangedListener {
        private ShapeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (TopicShapePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof IDecorationDescriptor) {
                TopicShapePropertySectionPart.this.changeShape(((IDecorationDescriptor)o).getId());
            }
        }
    }
}

