/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.core.ITopic;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchPolicyDescriptor;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTopicStructureCommand;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.MindMapPropertySectionPartBase;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.ImageCachedLabelProvider;
import org.xmind.ui.viewers.MComboViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructurePropertySectionPart
extends MindMapPropertySectionPartBase {
    private static final List<IBranchPolicyDescriptor> NO_BRANCH_POLICY = Collections.emptyList();
    private MComboViewer structureViewer;
    private Button followParentStructureCheck;

    @Override
    protected GridLayout createLayout(Composite parent) {
        GridLayout layout = super.createLayout(parent);
        layout.verticalSpacing = 7;
        return layout;
    }

    @Override
    protected void createContent(Composite parent) {
        this.structureViewer = new MComboViewer(parent, 0);
        this.structureViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.structureViewer.getControl().setToolTipText(PropertyMessages.Structure_toolTip);
        this.structureViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.structureViewer.setLabelProvider((IBaseLabelProvider)new BranchPolicyLabelProvider());
        this.structureViewer.addSelectionChangedListener((ISelectionChangedListener)new BranchPolicySelectionChangedListener());
        this.followParentStructureCheck = new Button(parent, 32);
        this.followParentStructureCheck.setText(PropertyMessages.FollowParentStructure_text);
        this.followParentStructureCheck.setToolTipText(PropertyMessages.FollowParentStructure_toolTip);
        this.followParentStructureCheck.setLayoutData((Object)new GridData(4, 2, true, false));
        this.followParentStructureCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StructurePropertySectionPart.this.doFollowParentStructure();
            }
        });
    }

    public void setFocus() {
        if (this.structureViewer != null && !this.structureViewer.getControl().isDisposed()) {
            this.structureViewer.getControl().setFocus();
        }
    }

    @Override
    protected void doRefresh() {
        if (this.structureViewer != null && !this.structureViewer.getControl().isDisposed()) {
            List<IBranchPolicyDescriptor> enableds = this.getCurrentStructures();
            this.structureViewer.setInput(enableds);
            this.structureViewer.setSelection(this.getCurrentStructure());
            this.structureViewer.getControl().setEnabled(!enableds.isEmpty());
        }
        if (this.followParentStructureCheck != null && !this.followParentStructureCheck.isDisposed()) {
            boolean follow = this.getCurrentFollowParentStructure();
            this.followParentStructureCheck.setSelection(follow);
            this.followParentStructureCheck.setEnabled(!follow);
            this.followParentStructureCheck.setVisible(!follow);
        }
    }

    @Override
    protected void registerEventListener(ICoreEventSource source, ICoreEventRegister register) {
        if (source instanceof ITopic) {
            register.register("structureClass");
        }
    }

    private void changeStructure(IBranchPolicyDescriptor descriptor) {
        this.changeStructureClass(descriptor.getId());
    }

    private void changeStructureClass(String newStructureClass) {
        List<ITopic> topics = this.getTopics();
        if (!topics.isEmpty()) {
            ModifyTopicStructureCommand cmd = new ModifyTopicStructureCommand(topics, newStructureClass);
            cmd.setLabel(CommandMessages.Command_ModifyTopicStructure);
            this.saveAndRun((Command)cmd);
        }
    }

    private List<ITopic> getTopics() {
        Object[] elements = this.getSelectedElements();
        ArrayList<ITopic> list = new ArrayList<ITopic>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ITopic && !list.contains(o)) {
                list.add((ITopic)o);
            }
            ++n2;
        }
        return list;
    }

    private List<IBranchPolicyDescriptor> getCurrentStructures() {
        ArrayList<IBranchPolicyDescriptor> list = null;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchPart branch;
                Object o = objectArray[n2];
                if (o instanceof ITopic && (branch = MindMapUtils.findBranch((IPart)this.getGraphicalPart(o, (IViewer)viewer))) != null) {
                    List<IBranchPolicyDescriptor> applicables = MindMapUI.getBranchPolicyManager().getApplicableBranchPolicyDescriptors(branch);
                    if (applicables.isEmpty()) {
                        return NO_BRANCH_POLICY;
                    }
                    if (list == null) {
                        list = new ArrayList<IBranchPolicyDescriptor>(applicables);
                    } else {
                        list.retainAll(applicables);
                    }
                    if (list.isEmpty()) {
                        return NO_BRANCH_POLICY;
                    }
                }
                ++n2;
            }
        }
        if (list == null || list.isEmpty()) {
            return NO_BRANCH_POLICY;
        }
        return list;
    }

    private ISelection getCurrentStructure() {
        IBranchPolicyDescriptor descriptor;
        String branchPolicyId = null;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchPart branch;
                Object o = objectArray[n2];
                if (o instanceof ITopic && (branch = MindMapUtils.findBranch((IPart)this.getGraphicalPart(o, (IViewer)viewer))) != null) {
                    String thisId = branch.getBranchPolicyId();
                    if (branchPolicyId == null) {
                        branchPolicyId = thisId;
                    } else if (!branchPolicyId.equals(thisId)) {
                        branchPolicyId = null;
                        break;
                    }
                }
                ++n2;
            }
        }
        if (branchPolicyId != null && (descriptor = MindMapUI.getBranchPolicyManager().getBranchPolicyDescriptor(branchPolicyId)) != null) {
            return new StructuredSelection((Object)descriptor);
        }
        return StructuredSelection.EMPTY;
    }

    private boolean getCurrentFollowParentStructure() {
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer == null) {
            return false;
        }
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof ITopic)) {
                return false;
            }
            IBranchPart branch = MindMapUtils.findBranch((IPart)this.getGraphicalPart(o, (IViewer)viewer));
            if (branch == null || !this.isFollowParentStructure(branch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isFollowParentStructure(IBranchPart branch) {
        return branch.isCentral() || branch.getTopic().getStructureClass() == null;
    }

    private void doFollowParentStructure() {
        this.changeStructureClass(null);
    }

    public void dispose() {
        super.dispose();
        this.structureViewer = null;
        this.followParentStructureCheck = null;
    }

    private static class BranchPolicyLabelProvider
    extends ImageCachedLabelProvider {
        private BranchPolicyLabelProvider() {
        }

        protected Image createImage(Object element) {
            IBranchPolicyDescriptor desc;
            ImageDescriptor icon;
            if (element instanceof IBranchPolicyDescriptor && (icon = (desc = (IBranchPolicyDescriptor)element).getIcon()) != null) {
                return icon.createImage(false);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IBranchPolicyDescriptor) {
                IBranchPolicyDescriptor desc = (IBranchPolicyDescriptor)element;
                return desc.getName();
            }
            return super.getText(element);
        }
    }

    private class BranchPolicySelectionChangedListener
    implements ISelectionChangedListener {
        private BranchPolicySelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (StructurePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof IBranchPolicyDescriptor) {
                StructurePropertySectionPart.this.changeStructure((IBranchPolicyDescriptor)o);
            }
        }
    }
}

