/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.SimpleRectangleFigure;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.service.AbstractBendPointsFeedback;
import org.xmind.gef.service.IRectangleProvider;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.internal.mindmap.RangeMoveHandleFigure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.resources.ColorUtils;

public abstract class RangeFeedback
extends AbstractBendPointsFeedback {
    public static final int[] HORIZONTAL = new int[]{16, 8};
    public static final int[] VERTICAL = new int[]{1, 4};
    public static final int[] SIDES = new int[]{16, 8, 1, 4};
    private IBranchRangePart host;
    private int alpha = 255;
    protected SimpleRectangleFigure border = new SimpleRectangleFigure();
    private IRectangleProvider originalBoundsProvider;

    public RangeFeedback(IBranchRangePart host) {
        this.host = host;
        this.setHidePointLength(28);
        this.originalBoundsProvider = new IRectangleProvider(){

            public Rectangle getRectangle() {
                return RangeFeedback.this.getRangeBounds().getExpanded(3, 3);
            }
        };
        this.setBoundsProvider(this.originalBoundsProvider);
        this.border.setForegroundColor(ColorUtils.getColor((String)"#b0b0b0"));
        this.border.setLineWidth(1);
    }

    protected abstract Rectangle getRangeBounds();

    public void addToLayer(IFigure layer) {
        layer.add((IFigure)this.border);
        super.addToLayer(layer);
    }

    public void removeFromLayer(IFigure layer) {
        super.removeFromLayer(layer);
        layer.remove((IFigure)this.border);
    }

    public void update() {
        if (this.host.getStatus().isSelected() && (this.host.getStatus().isPreSelected() || this.getBoundsProvider() != this.originalBoundsProvider)) {
            this.setAlpha(255);
            this.border.setMainAlpha(216);
            this.border.setVisible(true);
        } else if (this.host.getStatus().isSelected() || this.host.getStatus().isPreSelected()) {
            this.setAlpha(80);
            this.border.setMainAlpha(48);
            this.border.setVisible(true);
        } else {
            this.border.setVisible(false);
        }
        this.setOrientations(this.getBendPointOrientations());
        super.update();
    }

    protected void updateWithBounds(Rectangle clientBounds) {
        super.updateWithBounds(clientBounds);
        this.border.setBounds(clientBounds);
    }

    private int[] getBendPointOrientations() {
        IStructure sa;
        IBranchPart branch = this.host.getOwnedBranch();
        if (branch != null && (sa = branch.getBranchPolicy().getStructure(branch)) instanceof IBranchStructureExtension) {
            int direction = ((IBranchStructureExtension)sa).getRangeGrowthDirection(branch, this.host);
            switch (direction) {
                case 8: 
                case 16: {
                    return HORIZONTAL;
                }
                case 1: 
                case 4: {
                    return VERTICAL;
                }
            }
        }
        return SIDES;
    }

    public IBranchRangePart getHost() {
        return this.host;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    protected IReferencedFigure createPointFigure(int orientation) {
        return new RangeMoveHandleFigure(orientation);
    }

    protected void preUpdatePointFigure(IReferencedFigure figure, int orientation, Rectangle bounds, Point preferredPosition) {
        super.preUpdatePointFigure(figure, orientation, bounds, preferredPosition);
        ((RangeMoveHandleFigure)figure).setClientSize(bounds.getSize());
    }

    protected void updatePointFigure(IReferencedFigure figure, int orientation) {
        figure.repaint();
        ((RangeMoveHandleFigure)figure).setAlpha((int)((double)this.getAlpha() * 0.85));
    }
}

