/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IImageRegistryService;
import org.xmind.ui.internal.mindmap.MarkerDecorator;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.SelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.SimpleSelectionFeedback;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkerPart
extends MindMapPartBase
implements IMarkerPart {
    private ImageDescriptor imgDesc = null;
    private Image image = null;
    private boolean imageCreatable = true;
    private boolean imageNeedsDispose = false;

    public MarkerPart() {
        this.setDecorator((IDecorator)MarkerDecorator.getInstance());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IMarkerRef.class)) {
            return this.getMarkerRef();
        }
        if (adapter.isAssignableFrom(IMarker.class)) {
            return this.getMarker();
        }
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == Image.class) {
            return this.getImage();
        }
        return super.getAdapter(adapter);
    }

    protected IFigure createFigure() {
        return new SizeableImageFigure();
    }

    public IMarkerRef getMarkerRef() {
        return (IMarkerRef)super.getRealModel();
    }

    protected void register() {
        this.registerModel(this.getMarkerRef());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getMarkerRef());
    }

    public IMarker getMarker() {
        IMarkerRef markerRef = this.getMarkerRef();
        return markerRef == null ? null : markerRef.getMarker();
    }

    public ITopic getTopic() {
        return this.getMarkerRef().getParent();
    }

    public ITopicPart getTopicPart() {
        if (this.getParent() instanceof ITopicPart) {
            return (ITopicPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof TopicPart) {
            ((TopicPart)this.getParent()).removeMarker(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof TopicPart) {
            ((TopicPart)this.getParent()).addMarker(this);
        }
    }

    public Image getImage() {
        if (this.image == null && this.imageCreatable) {
            this.image = this.createImage();
        }
        return this.image;
    }

    private Image createImage() {
        IImageRegistryService service;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (service = (IImageRegistryService)viewer.getService(IImageRegistryService.class)) != null) {
            return service.getImage(this.getImageDescriptor(), false, (Object)this);
        }
        this.imageNeedsDispose = true;
        return this.getImageDescriptor().createImage(false, (Device)Display.getCurrent());
    }

    protected void onDeactivated() {
        IImageRegistryService service;
        this.imageCreatable = false;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (service = (IImageRegistryService)viewer.getService(IImageRegistryService.class)) != null) {
            service.decreaseRef(this.getImageDescriptor(), (Object)this);
        }
        if (this.image != null && this.imageNeedsDispose) {
            this.image.dispose();
            this.image = null;
        }
        super.onDeactivated();
    }

    private ImageDescriptor getImageDescriptor() {
        if (this.imgDesc == null) {
            this.imgDesc = MarkerImageDescriptor.createFromMarkerRef(this.getMarkerRef());
        }
        return this.imgDesc;
    }

    protected void updateView() {
        this.updateToolTip();
        super.updateView();
    }

    public IFigure findTooltipAt(Point position) {
        if (this.containsPoint(position)) {
            IFigure toolTip = this.getFigure().getToolTip();
            if (toolTip != null) {
                return toolTip;
            }
            return new Label(this.getMarkerRef().getDescription());
        }
        return null;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.markerMovable");
    }

    protected IFeedback createFeedback() {
        return new SimpleSelectionFeedback(this);
    }

    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new SelectionFeedbackHelper();
    }
}

