/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.xmind.core.marker.IMarker;
import org.xmind.gef.IDecorator;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.ui.internal.decorators.LegendItemDecorator;
import org.xmind.ui.internal.figures.LegendItemFigure;
import org.xmind.ui.internal.mindmap.LegendItem;
import org.xmind.ui.internal.mindmap.LegendPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.util.MarkerImageDescriptor;

public class LegendItemPart
extends MindMapPartBase
implements ILegendItemPart {
    private ImageDescriptor icon = null;
    private Image image = null;
    private boolean deactivated = false;

    public LegendItemPart() {
        this.setDecorator((IDecorator)LegendItemDecorator.getInstance());
    }

    protected IFigure createFigure() {
        return new LegendItemFigure();
    }

    public void setParent(IPart parent) {
        LegendPart legend;
        if (this.getParent() instanceof LegendPart) {
            legend = (LegendPart)this.getParent();
            legend.removeItem(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof LegendPart) {
            legend = (LegendPart)this.getParent();
            legend.addItem(this);
        }
    }

    public ILegendPart getOwnedLegend() {
        if (this.getParent() instanceof ILegendPart) {
            return (ILegendPart)this.getParent();
        }
        return null;
    }

    public LegendItem getItem() {
        return (LegendItem)super.getModel();
    }

    public String getMarkerId() {
        return this.getItem().getMarkerId();
    }

    public String getDescription() {
        return this.getItem().getDescription();
    }

    public Image getIconImage() {
        if (this.image == null && !this.deactivated) {
            this.image = this.createImage();
        }
        return this.image;
    }

    private Image createImage() {
        if (this.icon == null) {
            IMarker marker = this.getItem().getMarker();
            if (marker == null) {
                return null;
            }
            this.icon = MarkerImageDescriptor.createFromMarker(marker);
        }
        if (this.icon == null) {
            return null;
        }
        return this.icon.createImage(false);
    }

    protected void onDeactivated() {
        this.deactivated = true;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.onDeactivated();
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.legendMovable");
        reqHandler.installEditPolicy("editable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.legendItemModifiable");
    }
}

