/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.core.IImage;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.mindmap.IImagePart;

public class ImageDecorator
extends Decorator {
    private static final ImageDecorator instance = new ImageDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (part instanceof IImagePart) {
            IImagePart imagePart = (IImagePart)part;
            if (figure instanceof SizeableImageFigure) {
                SizeableImageFigure imageFigure = (SizeableImageFigure)figure;
                this.decorateImageFigure(imagePart, imageFigure);
            }
        }
    }

    private void decorateImageFigure(IImagePart imagePart, SizeableImageFigure imageFigure) {
        imageFigure.setStretched(true);
        imageFigure.setConstrained(false);
        imageFigure.setImage(imagePart.getImage());
        IImage imageModel = imagePart.getImageModel();
        int width = imageModel.getWidth();
        int height = imageModel.getHeight();
        if (imagePart.getImageDescriptor() instanceof AttachmentImageDescriptor) {
            if (width >= 0 && height >= 0) {
                imageFigure.setPreferredSize(width, height);
            } else {
                Dimension imageSize = imageFigure.getImageSize();
                if (width >= 0) {
                    imageFigure.setPreferredSize(width, imageSize.height);
                } else if (height >= 0) {
                    imageFigure.setPreferredSize(imageSize.width, height);
                } else {
                    imageFigure.setPreferredSize(imageSize);
                }
            }
        } else {
            imageFigure.setPreferredSize(imageFigure.getImageSize());
        }
    }

    public static ImageDecorator getInstance() {
        return instance;
    }
}

