/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.HashMap;
import java.util.Map;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.mindmap.ICacheValueProvider;

public class CacheManager
implements ICacheManager {
    private Map<String, Object> caches = null;
    private Map<String, ICacheValueProvider> valueProviders = null;
    private IPart part;

    public CacheManager(IPart part) {
        this.part = part;
    }

    public void flush(String key) {
        if (this.caches == null) {
            return;
        }
        this.caches.remove(key);
    }

    public Object getCache(String key) {
        ICacheValueProvider valueProvider;
        if (this.caches == null || key == null) {
            return null;
        }
        Object cache = this.caches.get(key);
        if (cache == null && (valueProvider = this.getValueProvider(key)) != null) {
            cache = valueProvider.getValue(this.part, key);
            this.setCache(key, cache);
        }
        return cache;
    }

    public void setCache(String key, Object cache) {
        if (key == null) {
            return;
        }
        if (this.caches == null) {
            this.caches = new HashMap<String, Object>();
        }
        if (cache == null) {
            this.caches.remove(key);
        } else {
            this.caches.put(key, cache);
        }
    }

    public ICacheValueProvider getValueProvider(String key) {
        if (this.valueProviders == null) {
            return null;
        }
        return this.valueProviders.get(key);
    }

    public void setValueProvider(String key, ICacheValueProvider valueProvider) {
        if (key == null || valueProvider == null) {
            return;
        }
        if (this.valueProviders == null) {
            this.valueProviders = new HashMap<String, ICacheValueProvider>();
        }
        this.valueProviders.put(key, valueProvider);
    }

    public void removeValueProvider(String key) {
        if (key == null || this.valueProviders == null) {
            return;
        }
        this.valueProviders.remove(key);
    }
}

