/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.xmind.core.IBoundary;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.util.Point;
import org.xmind.gef.IDecorator;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.ui.branch.IBranchPolicy;
import org.xmind.ui.branch.IBranchStyleSelector;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.internal.decorations.BranchConnections;
import org.xmind.ui.internal.decorators.BranchDecorator;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.layouts.BranchLayout;
import org.xmind.ui.internal.mindmap.BoundaryPart;
import org.xmind.ui.internal.mindmap.ChildSorter;
import org.xmind.ui.internal.mindmap.LabelPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.PlusMinusPart;
import org.xmind.ui.internal.mindmap.SheetPart;
import org.xmind.ui.internal.mindmap.SummaryPart;
import org.xmind.ui.internal.mindmap.SummaryViewerModel;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchPart
extends MindMapPartBase
implements IBranchPart {
    private ITopicPart topicPart = null;
    private List<IBranchPart> subBranches = null;
    private IPlusMinusPart plusMinus = null;
    private List<IBoundaryPart> boundaries = null;
    private List<ISummaryPart> summaries = null;
    private List<IBranchPart> summaryBranches = null;
    private ILabelPart label = null;
    private boolean central = false;
    private ChildSorter sorter = new ChildSorter((IPart)this);
    private BranchConnections connections = null;
    private String branchPolicyId = null;
    private int level = -1;

    public BranchPart() {
        this.setDecorator((IDecorator)BranchDecorator.getInstanceo());
    }

    @Override
    public ITopic getTopic() {
        return (ITopic)this.getRealModel();
    }

    @Override
    public IBranchPart getParentBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    @Override
    public ITopicPart getTopicPart() {
        return this.topicPart;
    }

    public void setTopicPart(ITopicPart topicPart) {
        this.topicPart = topicPart;
    }

    @Override
    public IPlusMinusPart getPlusMinus() {
        return this.plusMinus;
    }

    public void setPlusMinus(IPlusMinusPart plusMinus) {
        this.plusMinus = plusMinus;
    }

    @Override
    public List<IBranchPart> getSubBranches() {
        if (this.subBranches == null) {
            this.subBranches = new ArrayList<IBranchPart>();
        }
        return this.subBranches;
    }

    public void addSubBranch(IBranchPart subBranch) {
        this.getSubBranches().add(subBranch);
        this.sorter.sort(this.getSubBranches());
        int index = this.getSubBranches().indexOf(subBranch);
        this.getConnections().add(this.getFigure(), index, null);
    }

    public void removeSubBranch(IBranchPart subBranch) {
        int index = this.getSubBranches().indexOf(subBranch);
        this.getConnections().remove(this.getFigure(), index);
        this.getSubBranches().remove(subBranch);
    }

    @Override
    public List<ISummaryPart> getSummaries() {
        if (this.summaries == null) {
            this.summaries = new ArrayList<ISummaryPart>();
        }
        return this.summaries;
    }

    public void addSummary(ISummaryPart summary) {
        this.getSummaries().add(summary);
        this.sorter.sort(this.getSummaries());
    }

    public void removeSummary(ISummaryPart summary) {
        this.getSummaries().remove(summary);
    }

    @Override
    public List<IBranchPart> getSummaryBranches() {
        if (this.summaryBranches == null) {
            this.summaryBranches = new ArrayList<IBranchPart>();
        }
        return this.summaryBranches;
    }

    public void addSummaryBranch(IBranchPart summaryBranch) {
        this.getSummaryBranches().add(summaryBranch);
        this.sorter.sort(this.getSummaryBranches());
    }

    public void removeSummaryBranch(IBranchPart summaryBranch) {
        this.getSummaryBranches().remove(summaryBranch);
    }

    @Override
    public ILabelPart getLabel() {
        return this.label;
    }

    public void setLabel(ILabelPart label) {
        this.label = label;
    }

    protected IFigure createFigure() {
        return new BranchFigure();
    }

    public void setParent(IPart parent) {
        SheetPart sheet;
        BranchPart parentBranch;
        if (this.getParent() instanceof BranchPart) {
            parentBranch = (BranchPart)this.getParent();
            parentBranch.removeSubBranch(this);
            parentBranch.removeSummaryBranch(this);
        } else if (this.getParent() instanceof SheetPart) {
            sheet = (SheetPart)this.getParent();
            sheet.removeFloatingBranch(this);
            if (sheet.getCentralBranch() == this) {
                sheet.setCentralBranch(null);
            }
        }
        super.setParent(parent);
        this.central = this.getTopic().equals(this.getSite().getViewer().getAdapter(ITopic.class));
        if (this.getParent() instanceof BranchPart) {
            parentBranch = (BranchPart)this.getParent();
            this.level = parentBranch.getLevel() + 1;
            if ("attached".equals(this.getTopic().getType())) {
                parentBranch.addSubBranch(this);
            } else if ("summary".equals(this.getTopic().getType())) {
                parentBranch.addSummaryBranch(this);
            }
        } else if (this.getParent() instanceof SheetPart) {
            sheet = (SheetPart)this.getParent();
            if (this.getTopic().equals(sheet.getCentralTopic())) {
                this.level = 0;
                sheet.setCentralBranch(this);
            } else if ("detached".equals(this.getTopic().getType())) {
                this.level = 1;
                sheet.addFloatingBranch(this);
            }
        }
        this.setBranchPolicyId(this.findNewBranchPolicyId());
    }

    @Override
    public int getBranchIndex() {
        IBranchPart parentBranch = this.getParentBranch();
        if (parentBranch != null) {
            return parentBranch.getSubBranches().indexOf(this);
        }
        return 0;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public List<IBoundaryPart> getBoundaries() {
        if (this.boundaries == null) {
            this.boundaries = new ArrayList<IBoundaryPart>();
        }
        return this.boundaries;
    }

    public void addBoundary(IBoundaryPart boundary) {
        this.getBoundaries().add(boundary);
        this.sorter.sort(this.getBoundaries());
    }

    public void removeBoundary(IBoundaryPart boundary) {
        this.getBoundaries().remove(boundary);
    }

    @Override
    public boolean isCentral() {
        return this.central;
    }

    @Override
    public boolean isFolded() {
        return ((BranchFigure)this.getFigure()).isFolded();
    }

    @Override
    public String getBranchType() {
        if (this.isCentral()) {
            return "centralBranch";
        }
        IPart p = this.getParent();
        if (p instanceof IBranchPart) {
            IBranchPart parentBranch = (IBranchPart)p;
            if (parentBranch.isCentral() && parentBranch.getSubBranches().contains(this)) {
                return "mainBranch";
            }
            if (parentBranch.getSummaryBranches().contains(this)) {
                return "summaryBranch";
            }
        }
        if (p instanceof ISheetPart && ((ISheetPart)p).getFloatingBranches().contains(this)) {
            return "floatingBranch";
        }
        return "subBranch";
    }

    protected LayoutManager createLayoutManager() {
        return new BranchLayout(this);
    }

    protected Object[] getModelChildren(Object model) {
        ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
        ITopic topic = this.getTopic();
        boolean showsSubTopics = this.showsSubTopics();
        if (showsSubTopics) {
            for (IBoundary b : MindMapUtils.getSortedBoundaries(topic)) {
                list.add(new ViewerModel(BoundaryPart.class, b));
            }
        } else {
            for (IBoundary b : topic.getBoundaries()) {
                if (!b.isMasterBoundary()) continue;
                list.add(new ViewerModel(BoundaryPart.class, b));
                break;
            }
        }
        list.add(new ViewerModel(TopicPart.class, topic));
        if (!topic.getLabels().isEmpty()) {
            list.add(new ViewerModel(LabelPart.class, topic));
        }
        if (showsSubTopics) {
            List children = topic.getChildren("attached");
            if (!children.isEmpty()) {
                list.add(new ViewerModel(PlusMinusPart.class, topic));
            }
            for (ITopic subtopic : children) {
                list.add(new ViewerModel(BranchPart.class, subtopic));
            }
            for (ISummary summary : topic.getSummaries()) {
                ITopic summaryTopic = summary.getTopic();
                if (summaryTopic == null) continue;
                list.add(new SummaryViewerModel(SummaryPart.class, summary, summaryTopic));
            }
            for (ITopic summaryTopic : topic.getChildren("summary")) {
                list.add(new ViewerModel(BranchPart.class, summaryTopic));
            }
        }
        return list.toArray();
    }

    private boolean showsSubTopics() {
        int maxLevel = this.getSite().getViewer().getProperties().getInteger("maxTopicLevel", -1);
        return maxLevel < 0 || this.level < maxLevel;
    }

    protected void addChild(IPart child, int index) {
        super.addChild(child, index);
        this.update();
        if (child instanceof IBranchPart) {
            child.update();
        }
    }

    protected void removeChild(IPart child) {
        super.removeChild(child);
        this.update();
    }

    protected void reorderChild(IPart child, int index) {
        int oldBranchIndex = this.getSubBranches().indexOf(child);
        super.reorderChild(child, index);
        if (oldBranchIndex >= 0) {
            this.sorter.sort(this.getSubBranches());
            int newBranchIndex = this.getSubBranches().indexOf(child);
            IBranchConnections connections = this.getConnections();
            connections.move(this.getFigure(), oldBranchIndex, newBranchIndex);
        } else if (this.getBoundaries().contains(child)) {
            this.sorter.sort(this.getBoundaries());
        } else if (this.getSummaries().contains(child)) {
            this.sorter.sort(this.getSummaries());
        } else if (this.getSummaryBranches().contains(child)) {
            this.sorter.sort(this.getSummaryBranches());
        }
        this.update();
    }

    @Override
    protected void registerCoreEvents(ICoreEventSource source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("topicFolded");
        register.register("topicAdd");
        register.register("topicRemove");
        register.register("position");
        register.register("boundaryAdd");
        register.register("boundaryRemove");
        register.register("summaryAdd");
        register.register("summaryRemove");
        register.register("style");
        register.register("structureClass");
        register.register("labels");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("topicFolded".equals(type)) {
            this.treeUpdate(true);
        } else if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
            Object topicType = event.getData();
            if ("attached".equals(topicType)) {
                this.refresh();
            } else if ("summary".equals(topicType)) {
                this.refresh();
            }
        } else if ("position".equals(type)) {
            Point newPosition = (Point)event.getNewValue();
            org.eclipse.draw2d.geometry.Point p = MindMapUtils.toGraphicalPosition(newPosition);
            this.getCacheManager().setCache("org.xmind.ui.cache.preferredPosition", p);
            this.getFigure().revalidate();
        } else if ("boundaryAdd".equals(type) || "boundaryRemove".equals(type) || "summaryAdd".equals(type) || "summaryRemove".equals(type)) {
            this.refresh();
        } else if ("style".equals(type)) {
            this.refreshStyles();
        } else if ("structureClass".equals(type)) {
            this.treeUpdateBranchPolicy();
            this.sendFakeStyleEvent();
        } else if ("labels".equals(type)) {
            this.refresh();
            if (this.getLabel() != null) {
                this.getLabel().refresh();
            }
        } else {
            super.handleCoreEvent(event);
        }
    }

    private void sendFakeStyleEvent() {
        ICoreEventSupport coreEventSupport = (ICoreEventSupport)this.getTopic().getOwnedWorkbook().getAdapter(ICoreEventSupport.class);
        if (coreEventSupport != null) {
            ICoreEventSource source = (ICoreEventSource)this.getTopic();
            String styleId = this.getTopic().getStyleId();
            CoreEvent event = new CoreEvent(source, "style", (Object)styleId, (Object)styleId);
            coreEventSupport.dispatch(source, event);
        }
    }

    public void refreshStyles() {
        this.treeFlushStyleCaches();
        this.treeUpdate(true);
    }

    private void treeFlushStyleCaches() {
        IStyleSelector ss = this.getGraphicalPolicy().getStyleSelector((IGraphicalPart)this);
        if (ss instanceof IBranchStyleSelector) {
            ((IBranchStyleSelector)ss).flushStyleCaches(this);
        }
        for (IBranchPart subBranch : this.getSubBranches()) {
            ((BranchPart)subBranch).treeFlushStyleCaches();
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            ((BranchPart)summaryBranch).treeFlushStyleCaches();
        }
    }

    protected void treeUpdateBranchPolicy() {
        this.updateBranchPolicy();
        this.updateView();
        this.refreshChildren();
        for (IBranchPart subBranch : this.getSubBranches()) {
            ((BranchPart)subBranch).treeUpdateBranchPolicy();
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            ((BranchPart)summaryBranch).treeUpdateBranchPolicy();
        }
        this.updateChildren();
    }

    private void updateBranchPolicy() {
        String newId = this.findNewBranchPolicyId();
        this.setBranchPolicyId(newId);
    }

    private void setBranchPolicyId(String newId) {
        IBranchPolicy newPolicy = MindMapUI.getBranchPolicyManager().getBranchPolicy(newId);
        this.branchPolicyId = newId;
        this.setGraphicalPolicy(newPolicy);
        this.getFigure().revalidate();
    }

    @Override
    public void setGraphicalPolicy(IGraphicalPolicy graphicalPolicy) {
        IGraphicalPolicy oldPolicy = this.getGraphicalPolicy();
        super.setGraphicalPolicy(graphicalPolicy);
        if (oldPolicy instanceof IBranchPolicy) {
            ((IBranchPolicy)oldPolicy).postDeactivate(this);
        }
    }

    @Override
    public String getBranchPolicyId() {
        if (this.branchPolicyId == null) {
            this.branchPolicyId = this.findNewBranchPolicyId();
        }
        return this.branchPolicyId;
    }

    private String findNewBranchPolicyId() {
        return MindMapUI.getBranchPolicyManager().calculateBranchPolicyId(this, this.getTopic().getStructureClass());
    }

    @Override
    public IBranchPolicy getBranchPolicy() {
        IGraphicalPolicy gp = this.getGraphicalPolicy();
        if (gp instanceof IBranchPolicy) {
            return (IBranchPolicy)gp;
        }
        return MindMapUI.getBranchPolicyManager().getDefaultBranchPolicy();
    }

    public void setModel(Object model) {
        super.setModel(model);
        org.eclipse.draw2d.geometry.Point p = MindMapUtils.toGraphicalPosition(this.getTopic().getPosition());
        this.getCacheManager().setCache("org.xmind.ui.cache.preferredPosition", p);
    }

    @Override
    protected void onActivated() {
        super.onActivated();
    }

    @Override
    protected void onDeactivated() {
        super.onDeactivated();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.getTopicPart() != null) {
            this.getTopicPart().update();
        }
        if (this.getPlusMinus() != null) {
            this.getPlusMinus().update();
        }
        if (this.getLabel() != null) {
            this.getLabel().update();
        }
        for (IBoundaryPart b : this.getBoundaries()) {
            b.update();
        }
        for (ISummaryPart s : this.getSummaries()) {
            s.update();
        }
    }

    @Override
    public void treeUpdate(boolean updateParent) {
        IBranchPart parentBranch;
        if (updateParent && (parentBranch = this.getParentBranch()) != null) {
            ((BranchPart)parentBranch).updateChildren();
        }
        this.updateView();
        for (IBranchPart subBranch : this.getSubBranches()) {
            subBranch.treeUpdate(false);
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            summaryBranch.treeUpdate(false);
        }
        this.updateChildren();
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("creatable role", "org.xmind.ui.editPolicy.topicCreatable");
        reqHandler.installEditPolicy("extendable role", "org.xmind.ui.editPolicy.extendable");
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
    }

    @Override
    public boolean isPropertyModifiable(String propertyName) {
        return this.isPropertyModifiable(propertyName, null);
    }

    @Override
    public boolean isPropertyModifiable(String propertyName, String secondaryKey) {
        return this.getBranchPolicy().isPropertyModifiable(this, propertyName, secondaryKey);
    }

    public IPart findAt(org.eclipse.draw2d.geometry.Point position) {
        IPart ret;
        IPart focusedPart = this.getSite().getViewer().getFocusedPart();
        if (focusedPart instanceof IGraphicalEditPart && this.getBoundaries().contains(focusedPart) && (ret = ((IGraphicalEditPart)focusedPart).findAt(position)) != null) {
            return ret;
        }
        ret = super.findAt(position);
        if (ret == this) {
            return null;
        }
        return ret;
    }

    @Override
    public boolean canSearchChild() {
        BranchFigure figure = (BranchFigure)this.getFigure();
        return !figure.isFolded() && !figure.isMinimized() && figure.isVisible() && figure.isEnabled() && (!this.getSubBranches().isEmpty() || !this.getSummaryBranches().isEmpty());
    }

    @Override
    protected boolean isFigureAnimatable() {
        return true;
    }

    @Override
    public IBranchConnections getConnections() {
        if (this.connections == null) {
            this.connections = new BranchConnections();
        }
        return this.connections;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == ITopicPart.class) {
            return this.getTopicPart();
        }
        if (adapter == IPlusMinusPart.class) {
            return this.getPlusMinus();
        }
        if (adapter == ILabelPart.class) {
            return this.getLabel();
        }
        return super.getAdapter(adapter);
    }
}

