/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.findreplace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.findreplace.IFindReplaceOperationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindReplaceDialog
extends Dialog
implements IPartListener {
    private static final String EMPTY = "";
    private static final String STRING_NOT_FOUND = DialogMessages.FindReplaceDialog_StringNotFound;
    private static Map<Shell, FindReplaceDialog> SINGLETONS = new HashMap<Shell, FindReplaceDialog>();
    private static final int TEXT_WIDTH = 120;
    private static final int FIND_ID = 1025;
    private static final int FIND_ALL_ID = 1026;
    private static final int REPLACE_ID = 1027;
    private static final int REPLACE_ALL_ID = 1028;
    private static List<String> FindHistory = new ArrayList<String>();
    private static List<String> ReplaceHistory = new ArrayList<String>();
    private IFindReplaceOperationProvider operationProvider;
    private Combo findInput;
    private Combo replaceInput;
    private Label infoLabel;
    private Map<Integer, Button> opButtons = new HashMap<Integer, Button>();
    private Map<Integer, List<Button>> paramWidgets = new HashMap<Integer, List<Button>>();
    private String initialFindText = null;
    private IWorkbenchWindow window;
    private IWorkbenchPart currentPart;

    private FindReplaceDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.setShellStyle(96);
        final Shell shell = window.getShell();
        SINGLETONS.put(shell, this);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SINGLETONS.remove(shell);
            }
        });
        this.window = window;
    }

    private void startListeningToPartChanges() {
        this.window.getPartService().addPartListener((IPartListener)this);
    }

    private void stopListeningToPartChanges() {
        this.window.getPartService().removePartListener((IPartListener)this);
    }

    public void setInitialFindText(String initialFindText) {
        this.initialFindText = initialFindText;
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? FindReplaceDialog.getDialogCenter(parent.getBounds()) : FindReplaceDialog.getDialogCenter(monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y / 2, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private static Point getDialogCenter(Rectangle rect) {
        return new Point(rect.x + rect.width * 2 / 3, rect.y + rect.height / 2);
    }

    public void create() {
        super.create();
        IWorkbenchPart activePart = this.window.getActivePage().getActivePart();
        this.partActivated(activePart);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = 10;
        layout.marginTop = layout.marginHeight;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        this.createInputGroup(composite);
        this.createParameterGroups(composite);
        this.createOperationButtonGroup(composite);
        return composite;
    }

    protected void createInputGroup(Composite parent) {
        Composite composite = new Composite(parent, 524288);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout inputLayout = new GridLayout(2, false);
        inputLayout.marginWidth = 0;
        inputLayout.marginHeight = 0;
        composite.setLayout((Layout)inputLayout);
        this.findInput = this.createInputWidget(composite, DialogMessages.FindReplaceDialog_Find_label, FindHistory, this.initialFindText);
        this.replaceInput = this.createInputWidget(composite, DialogMessages.FindReplaceDialog_ReplaceWith_label, ReplaceHistory, null);
    }

    private Combo createInputWidget(Composite parent, String label, List<String> history, String initText) {
        Label labelWidget = new Label(parent, 0);
        labelWidget.setText(label);
        labelWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Combo input = new Combo(parent, 2052);
        GridData layoutData = new GridData(4, 0x1000000, true, true);
        layoutData.widthHint = 120;
        input.setLayoutData((Object)layoutData);
        for (String t : history) {
            input.add(t);
        }
        if (initText != null) {
            input.setText(initText);
        } else if (!history.isEmpty()) {
            input.setText(history.get(0));
        }
        input.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FindReplaceDialog.this.updateOperationButtons();
                FindReplaceDialog.this.infoLabel.setText(FindReplaceDialog.EMPTY);
            }
        });
        return input;
    }

    protected void createParameterGroups(Composite parent) {
        Composite composite = new Composite(parent, 524288);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Composite optionGroup = this.createParameterGroup(composite, DialogMessages.FindReplaceDialog_OptionGroup);
        ((GridData)optionGroup.getLayoutData()).horizontalSpan = 2;
        this.createParameterWidget(optionGroup, 32, DialogMessages.FindReplaceDialog_CaseSensitive, 1);
        this.createParameterWidget(optionGroup, 32, DialogMessages.FindReplaceDialog_WholeWord, 2);
        Composite directionGroup = this.createParameterGroup(composite, DialogMessages.FindReplaceDialog_DirectionGroup);
        this.createParameterWidget(directionGroup, 16, DialogMessages.FindReplaceDialog_Forward, 4);
        this.createParameterWidget(directionGroup, 16, DialogMessages.FindReplaceDialog_Backward, 8);
        Composite scopeGroup = this.createParameterGroup(composite, DialogMessages.FindReplaceDialog_ScopeGroup);
        this.createParameterWidget(scopeGroup, 16, DialogMessages.FindReplaceDialog_CurrentMap, 16);
        this.createParameterWidget(scopeGroup, 16, DialogMessages.FindReplaceDialog_Workbook, 32);
    }

    private Composite createParameterGroup(Composite composite, String text) {
        Group group = new Group(composite, 524288);
        group.setText(text);
        GridData groupLayoutData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)groupLayoutData);
        GridLayout groupLayout = new GridLayout();
        groupLayout.horizontalSpacing = 7;
        groupLayout.verticalSpacing = 7;
        group.setLayout((Layout)groupLayout);
        return group;
    }

    protected Button createParameterWidget(Composite parent, int style, String text, int paramId) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addParameterWidget(paramId, button);
        button.setData((Object)paramId);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button b = (Button)event.widget;
                if (FindReplaceDialog.this.operationProvider != null) {
                    FindReplaceDialog.this.operationProvider.setParameter((Integer)b.getData(), b.getSelection());
                }
                FindReplaceDialog.this.updateOperationButtons();
            }
        });
        return button;
    }

    private void addParameterWidget(final int paramId, final Button widget) {
        List<Button> widgets = this.paramWidgets.get(paramId);
        if (widgets == null) {
            widgets = new ArrayList<Button>();
            this.paramWidgets.put(paramId, widgets);
        }
        widgets.add(widget);
        this.paramWidgets.put(paramId, widgets);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.removeParameterWidget(paramId, widget);
            }
        });
    }

    private void removeParameterWidget(int paramId, Button widget) {
        List<Button> widgets = this.paramWidgets.get(paramId);
        if (widgets != null) {
            widgets.remove(widget);
            if (widgets.isEmpty()) {
                this.paramWidgets.remove(paramId);
            }
        }
    }

    private void updateParameterWidgets() {
        for (Integer paramId : this.paramWidgets.keySet()) {
            this.updateParameterWidget(paramId);
        }
    }

    private void updateParameterWidget(Integer paramId) {
        List<Button> widgets = this.paramWidgets.get(paramId);
        if (widgets != null) {
            for (Button widget : widgets) {
                widget.setSelection(this.hasParameter(paramId));
            }
        }
    }

    private boolean hasParameter(int paramId) {
        if (this.operationProvider == null) {
            return false;
        }
        int bit = this.operationProvider.getParameter() & paramId;
        return bit != 0;
    }

    protected void createOperationButtonGroup(Composite parent) {
        Composite buttons = new Composite(parent, 524288);
        buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout buttonsLayout = new GridLayout(2, true);
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonsLayout);
        this.createOperationButton(buttons, 1025, DialogMessages.FindReplaceDialog_Find_text, true);
        this.createOperationButton(buttons, 1026, DialogMessages.FindReplaceDialog_FindAll_text, false);
        this.createOperationButton(buttons, 1027, DialogMessages.FindReplaceDialog_Replace_text, false);
        this.createOperationButton(buttons, 1028, DialogMessages.FindReplaceDialog_ReplaceAll_text, false);
    }

    protected Button createOperationButton(Composite parent, int id, String text, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        button.setText(text);
        button.setData((Object)id);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindReplaceDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.registerOperationButton(id, button);
        return button;
    }

    protected void registerOperationButton(final int id, final Button widget) {
        this.opButtons.put(id, widget);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.unregisterOperationButton(id, widget);
            }
        });
    }

    private void unregisterOperationButton(int id, Button widget) {
        if (this.opButtons.get(id) == widget) {
            this.opButtons.remove(id);
        }
    }

    protected Button getButton(int id) {
        Button button = super.getButton(id);
        if (button == null) {
            button = this.opButtons.get(id);
        }
        return button;
    }

    protected Control createButtonBar(Composite parent) {
        Composite container = new Composite(parent, 524288);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.marginHeight = 7;
        containerLayout.marginWidth = 7;
        container.setLayout((Layout)containerLayout);
        this.infoLabel = new Label(container, 0);
        this.infoLabel.setBackground(container.getBackground());
        this.infoLabel.setFont(container.getFont());
        this.infoLabel.setForeground(container.getDisplay().getSystemColor(3));
        this.infoLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        Composite composite = (Composite)super.createButtonBar(container);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.closePressed();
        } else if (1025 == buttonId) {
            this.findPressed();
        } else if (1026 == buttonId) {
            this.findAllPressed();
        } else if (1027 == buttonId) {
            this.replacePressed();
        } else if (1028 == buttonId) {
            this.replaceAllPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void findPressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        if (this.operationProvider.find(this.getFindText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.findInput.setFocus();
    }

    protected void findAllPressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        boolean all = (this.operationProvider.getParameter() & 0x10000) != 0;
        this.operationProvider.setParameter(65536, true);
        if (this.operationProvider.find(this.getFindText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.operationProvider.setParameter(65536, all);
        this.findInput.setFocus();
    }

    protected void replacePressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        if (this.operationProvider.replace(this.getFindText(), this.getReplaceText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.findInput.setFocus();
    }

    protected void replaceAllPressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        boolean all = (this.operationProvider.getParameter() & 0x10000) != 0;
        this.operationProvider.setParameter(65536, true);
        if (this.operationProvider.replace(this.getFindText(), this.getReplaceText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.operationProvider.setParameter(65536, all);
        this.findInput.setFocus();
    }

    protected void closePressed() {
        this.close();
    }

    public boolean close() {
        this.saveHistories();
        return super.close();
    }

    public String getFindText() {
        return this.findInput == null || this.findInput.isDisposed() ? EMPTY : this.findInput.getText();
    }

    public String getReplaceText() {
        return this.replaceInput == null || this.replaceInput.isDisposed() ? EMPTY : this.replaceInput.getText();
    }

    protected void setInfoText(String text) {
        if (this.infoLabel != null && !this.infoLabel.isDisposed()) {
            this.infoLabel.setText(text);
            this.infoLabel.getParent().layout();
        }
    }

    protected void saveHistories() {
        this.saveHistory(FindHistory, this.findInput);
        this.saveHistory(ReplaceHistory, this.replaceInput);
    }

    protected void saveHistory(List<String> history, Combo input) {
        String text = input.getText();
        if (text == null || EMPTY.equals(text)) {
            return;
        }
        if (history.remove(text) && !input.isDisposed()) {
            input.remove(text);
        }
        history.add(0, text);
        if (!input.isDisposed()) {
            input.add(text, 0);
            input.setText(text);
        }
    }

    protected void updateOperationButtons() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.getButton(1025).setEnabled(this.canFind());
        this.getButton(1026).setEnabled(this.canFindAll());
        this.getButton(1027).setEnabled(this.canReplace());
        this.getButton(1028).setEnabled(this.canReplaceAll());
    }

    protected boolean canFind() {
        return this.getFindText() != null && !EMPTY.equals(this.getFindText()) && this.operationProvider != null && this.operationProvider.canFind(this.getFindText());
    }

    protected boolean canReplace() {
        return this.canFind() && this.getReplaceText() != null && this.operationProvider != null && this.operationProvider.canReplace(this.getFindText(), this.getReplaceText());
    }

    protected boolean canFindAll() {
        return this.getFindText() != null && !EMPTY.equals(this.getFindText()) && this.operationProvider != null && this.operationProvider.canFindAll(this.getFindText());
    }

    protected boolean canReplaceAll() {
        return this.canFindAll() && this.getReplaceText() != null && this.operationProvider != null && this.operationProvider.canReplaceAll(this.getFindText(), this.getReplaceText());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DialogMessages.FindReplaceDialog_windowTitle);
        this.startListeningToPartChanges();
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.stopListeningToPartChanges();
            }
        });
    }

    public void setOperationProvider(IFindReplaceOperationProvider operationProvider) {
        this.operationProvider = operationProvider;
    }

    public IFindReplaceOperationProvider getOperationProvider() {
        return this.operationProvider;
    }

    public void partActivated(IWorkbenchPart part) {
        this.currentPart = part;
        this.setOperationProvider(this.getOperationProvider(part));
        this.updateOperationButtons();
        this.updateParameterWidgets();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part != this.currentPart) {
            return;
        }
        this.setOperationProvider(null);
        this.updateOperationButtons();
        this.updateParameterWidgets();
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private IFindReplaceOperationProvider getOperationProvider(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        return (IFindReplaceOperationProvider)part.getAdapter(IFindReplaceOperationProvider.class);
    }

    public static FindReplaceDialog getInstance(IWorkbenchWindow window) {
        Shell shell = window.getShell();
        FindReplaceDialog instance = SINGLETONS.get(shell);
        if (instance != null) {
            return instance;
        }
        return new FindReplaceDialog(window);
    }
}

