/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.findreplace;

import org.xmind.ui.internal.findreplace.IFindReplaceOperationProvider;

public abstract class AbstractFindReplaceOperationProvider
implements IFindReplaceOperationProvider {
    public boolean find(String toFind) {
        return this.isAll() ? this.findAll(toFind) : this.findNext(toFind);
    }

    public boolean replace(String toFind, String toReplaceWith) {
        return this.isAll() ? this.replaceAll(toFind, toReplaceWith) : this.replaceNext(toFind, toReplaceWith);
    }

    protected abstract boolean findAll(String var1);

    protected abstract boolean findNext(String var1);

    protected abstract boolean replaceAll(String var1, String var2);

    protected abstract boolean replaceNext(String var1, String var2);

    protected int indexOf(String text, String toFind, int offset) {
        int index;
        if (!this.isCaseSensitive()) {
            text = text.toLowerCase();
            toFind = toFind.toLowerCase();
        }
        int n = index = this.isForward() ? text.indexOf(toFind, offset) : text.lastIndexOf(toFind, offset - toFind.length());
        if (index >= 0 && this.isWholeWord() && !this.isWholeWord(text, index, toFind.length())) {
            index = -1;
        }
        return index;
    }

    protected boolean equals(String toFind, String selectionText) {
        return this.isCaseSensitive() ? toFind.equals(selectionText) : toFind.equalsIgnoreCase(selectionText);
    }

    protected int getNewOffset(String text) {
        return this.isForward() ? 0 : text.length() + 1;
    }

    protected boolean isIndexPermitted(int newIndex, int startIndex) {
        return this.isForward() ? newIndex < startIndex : newIndex > startIndex;
    }

    protected boolean isWholeWord(String text, int start, int length) {
        int post;
        int pre = start == 0 ? 32 : (int)text.charAt(start - 1);
        int n = post = start == text.length() - length ? 32 : (int)text.charAt(start + length);
        return pre == 32 && post == 32;
    }

    protected boolean isAll() {
        return (this.getParameter() & 0x10000) != 0;
    }

    protected boolean isForward() {
        return (this.getParameter() & 4) != 0;
    }

    protected boolean isCaseSensitive() {
        return (this.getParameter() & 1) != 0;
    }

    protected boolean isWholeWord() {
        return (this.getParameter() & 2) != 0;
    }

    protected boolean isWorkbook() {
        return (this.getParameter() & 0x20) != 0;
    }

    public boolean canFindAll(String toFind) {
        return this.canFind(toFind) && !this.isWorkbook();
    }

    public boolean canReplaceAll(String toFind, String toReplaceWith) {
        return this.canReplace(toFind, toReplaceWith) && !this.isWorkbook();
    }
}

