/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.IBoundary;
import org.xmind.core.ITopic;
import org.xmind.gef.Request;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.INavigableBranchStructureExtension;
import org.xmind.ui.internal.editpolicies.MindMapNavigablePolicyBase;
import org.xmind.ui.internal.editpolicies.PositionSearcher;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicNavigablePolicy
extends MindMapNavigablePolicyBase {
    private boolean ignoreCache = true;
    private IBranchPart tempPart = null;
    private boolean isSummaryPart = false;
    private IBoundaryPart[] EMPTY = new IBoundaryPart[0];
    private Map<IBranchPart, List<IBoundaryPart>> map = null;

    public boolean understands(String requestType) {
        return super.understands(requestType) || "navigate child".equals(requestType) || "navigate sibling".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("navigate child".equals(reqType)) {
            this.navChild(request);
        } else if ("navigate sibling".equals(reqType)) {
            this.navSibling(request);
        } else {
            super.handle(request);
        }
    }

    private void navChild(Request request) {
        ITopicPart childTopicPart;
        IBranchPart child;
        ITopicPart topicPart;
        IBranchPart branch;
        IPart source = request.getPrimaryTarget();
        if (source instanceof ITopicPart && (branch = (topicPart = (ITopicPart)source).getOwnerBranch()) != null && (child = this.findFirstChild(branch)) != null && (childTopicPart = child.getTopicPart()) != null) {
            this.setNavigationResult(request, Arrays.asList(childTopicPart));
        }
    }

    private void navSibling(Request request) {
        ITopicPart topicPart;
        IBranchPart branch;
        IPart source = request.getPrimaryTarget();
        if (source instanceof ITopicPart && (branch = (topicPart = (ITopicPart)source).getOwnerBranch()) != null) {
            IBranchPart sibling;
            IBranchPart child;
            if (branch.isCentral() && (child = this.findFirstChild(branch)) != null) {
                this.setNavigationResult(request, Arrays.asList(child.getTopicPart()));
            }
            if ((sibling = this.findSucceedingSiblingOrAncestor(branch)) != branch) {
                this.setNavigationResult(request, Arrays.asList(sibling.getTopicPart()));
            }
        }
    }

    @Override
    protected IPart findNewNavParts(Request request, String navType, List<IPart> sources) {
        IPart navPart;
        IBranchPart branch;
        ITopicPart topicPart = MindMapUtils.findTopicPart(request.getPrimaryTarget());
        if (topicPart != null && (branch = topicPart.getOwnerBranch()) != null && (navPart = this.findNavPart(branch, navType)) != null && navPart.getStatus().isActive()) {
            return navPart;
        }
        return null;
    }

    private IPart findNavPart(IBranchPart branch, String navType) {
        IStructure structure = branch.getBranchPolicy().getStructure(branch);
        if (structure instanceof INavigableBranchStructureExtension) {
            IPart navPart = ((INavigableBranchStructureExtension)structure).calcNavigation(branch, navType);
            if (navPart == null) {
                IBranchPart parent = branch.getParentBranch();
                if (parent != null) {
                    IStructure parentStructure = parent.getBranchPolicy().getStructure(parent);
                    if (parentStructure instanceof INavigableBranchStructureExtension) {
                        navPart = ((INavigableBranchStructureExtension)parentStructure).calcChildNavigation(parent, branch, navType, false);
                    }
                } else {
                    navPart = this.calcNavThroughFloatingAndCentral(branch, navType);
                }
                if (navPart == null) {
                    this.ignoreCache = true;
                    navPart = this.calcNavByPosition(branch, navType);
                }
            }
            return navPart;
        }
        return null;
    }

    @Override
    protected void setNavCaches(List<IPart> sources, IPart target, String navType) {
        this.ignoreCache = false;
    }

    private IPart calcNavThroughFloatingAndCentral(IBranchPart branch, String navType) {
        return this.calcNavByPosition(branch, navType);
    }

    private IPart calcNavByPosition(IBranchPart branch, String navType) {
        return new PositionSearcher(branch, navType).search();
    }

    protected void findSequentialNavParts(Request request, String navType, IPart sequenceStart, List<IPart> sources, List<IPart> result) {
        ITopicPart endTopic = MindMapUtils.findTopicPart(sequenceStart);
        if (endTopic != null) {
            ITopicPart sourceTopic = MindMapUtils.findTopicPart(request.getPrimaryTarget());
            if (sourceTopic != null && this.isSibling(sourceTopic, endTopic)) {
                IBranchPart endBranch = endTopic.getOwnerBranch();
                IBranchPart sourceBranch = sourceTopic.getOwnerBranch();
                IBranchPart parentBranch = sourceBranch.getParentBranch();
                if (parentBranch != null) {
                    IStructure parentStructure = parentBranch.getBranchPolicy().getStructure(parentBranch);
                    if (parentStructure instanceof INavigableBranchStructureExtension) {
                        INavigableBranchStructureExtension ext = (INavigableBranchStructureExtension)parentStructure;
                        IPart startPart = ext.calcChildNavigation(parentBranch, sourceBranch, navType, true);
                        IBranchPart startBranch = MindMapUtils.findBranch(startPart);
                        if (startBranch == null) {
                            startBranch = sourceBranch;
                        }
                        ArrayList<IBranchPart> list = new ArrayList<IBranchPart>();
                        ext.calcSequentialNavigation(parentBranch, startBranch, endBranch, list);
                        for (IBranchPart branch : list) {
                            result.add((IPart)branch.getTopicPart());
                        }
                    }
                } else {
                    this.addSeqPartsFromFloatingAndCentral(navType, sourceBranch, endBranch, result);
                }
            }
            if (!result.contains(endTopic)) {
                result.add((IPart)endTopic);
            }
        } else {
            super.findSequentialNavParts(request, navType, sequenceStart, sources, result);
        }
    }

    private void addSeqPartsFromFloatingAndCentral(String navType, IBranchPart sourceBranch, IBranchPart startBranch, List<IPart> result) {
    }

    private boolean isSibling(ITopicPart t1, ITopicPart t2) {
        IBranchPart b1 = t1.getOwnerBranch();
        IBranchPart b2 = t2.getOwnerBranch();
        if (b1 != null && b2 != null) {
            return b1.getParentBranch() == b2.getParentBranch();
        }
        return false;
    }

    protected IPart findNextOrPrev(IPart source, boolean nextOrPrev) {
        if (source != null) {
            return this.findNextOrPrevTopic(source, nextOrPrev);
        }
        return super.findNextOrPrev(source, nextOrPrev);
    }

    private IPart findNextOrPrevTopic(IPart current, boolean nextOrPrev) {
        this.refreshMap(current);
        if (nextOrPrev) {
            IPart nextPart = this.findSuccedingPart(current);
            if (this.map != null) {
                this.map.clear();
            }
            return nextPart;
        }
        IPart prevPart = this.findPrecedingPart(current);
        if (this.map != null) {
            this.map.clear();
        }
        return prevPart;
    }

    private IPart findSuccedingPart(IPart current) {
        if (current instanceof ITopicPart) {
            ITopicPart topicPart = (ITopicPart)current;
            IBranchPart branch = topicPart.getOwnerBranch();
            ILabelPart labelPart = this.getLabelPart(branch);
            if (labelPart != null) {
                return labelPart;
            }
            return this.getNextPart(branch);
        }
        if (current instanceof ILabelPart) {
            IBranchPart branch = ((ILabelPart)current).getOwnedBranch();
            return this.getNextPart(branch);
        }
        if (current instanceof IRelationshipPart) {
            IRelationshipPart toFindPart = (IRelationshipPart)current;
            IRelationshipPart findPart = this.findPrevOrNextRelationPart(toFindPart, true);
            if (toFindPart == findPart) {
                return findPart.getOwnerSheet().getCentralBranch().getTopicPart();
            }
            return findPart;
        }
        if (current instanceof IBoundaryPart) {
            IBoundaryPart boundaryPart = (IBoundaryPart)current;
            return this.getSucceedingPart1(boundaryPart);
        }
        return current;
    }

    private IPart getNextPart(IBranchPart branch) {
        IPart child = this.getFirstChildPart(branch);
        if (child != null) {
            return child;
        }
        IBranchPart branchPart = this.findSucceedingSiblingOrAncestor(branch);
        return this.getSucceedingPart(branchPart, branch);
    }

    private IPart getSucceedingPart1(IBoundaryPart current) {
        this.refreshMap((IPart)current);
        IBoundary boundary = current.getBoundary();
        IBranchPart branch = current.getOwnedBranch();
        if (boundary.isMasterBoundary()) {
            return branch.getTopicPart();
        }
        int index = boundary.getStartIndex();
        IBoundaryPart retPart = null;
        List<IBoundaryPart> list = this.map.get(branch);
        if (list != null) {
            for (IBoundaryPart boundaryPart : list) {
                int endIndex;
                if (boundaryPart == current) {
                    if (retPart == null) continue;
                    retPart = null;
                    continue;
                }
                int startIndex = boundaryPart.getBoundary().getStartIndex();
                if (index != startIndex) continue;
                if (retPart == null) {
                    retPart = boundaryPart;
                }
                if ((endIndex = boundaryPart.getBoundary().getEndIndex()) < retPart.getBoundary().getEndIndex()) continue;
                retPart = boundaryPart;
            }
        }
        if (retPart == null) {
            List<IBranchPart> branches = current.getEnclosingBranches();
            return branches.get(0).getTopicPart();
        }
        return retPart;
    }

    private IPart getFirstChildPart(IBranchPart current) {
        List<IBranchPart> subBranches = current.getSubBranches();
        if (!subBranches.isEmpty()) {
            IBoundaryPart part;
            IBranchPart childBranch = subBranches.get(0);
            if (this.hasBoundaryPart(current) && (part = this.getBoundaryPart(current, childBranch)) != null) {
                return part;
            }
            return childBranch.getTopicPart();
        }
        return null;
    }

    private IPart getSucceedingPart(IBranchPart succeedPart, IBranchPart currentPart) {
        IBoundaryPart part;
        IRelationshipPart part2;
        this.refreshMap((IPart)succeedPart);
        if (succeedPart.isCentral() && (part2 = this.getRelationshipPart(succeedPart)) != null) {
            this.tempPart = currentPart;
            return part2;
        }
        IBranchPart parentBranch = succeedPart.getParentBranch();
        if (parentBranch == null) {
            parentBranch = succeedPart;
        }
        if (this.isSummaryPart) {
            parentBranch = succeedPart;
            this.isSummaryPart = false;
        }
        if ((part = this.getBoundaryPart(parentBranch, succeedPart)) != null) {
            return part;
        }
        return succeedPart.getTopicPart();
    }

    private ILabelPart getLabelPart(IBranchPart branch) {
        ILabelPart labelPart = branch.getLabel();
        if (labelPart != null) {
            return labelPart;
        }
        return null;
    }

    private IRelationshipPart getRelationshipPart(IBranchPart branch) {
        ISheetPart sheetPart = (ISheetPart)branch.getParent();
        List<IRelationshipPart> relations = sheetPart.getRelationships();
        if (relations.size() > 0) {
            return relations.get(0);
        }
        return null;
    }

    private IBoundaryPart getBoundaryPart(IBranchPart parent, IBranchPart current) {
        IBoundaryPart retPart = null;
        ITopic topic = current.getTopic();
        List children = parent.getTopic().getAllChildren();
        int index1 = children.indexOf(topic);
        if (this.map == null) {
            return retPart;
        }
        List<IBoundaryPart> list = this.map.get(parent);
        if (list != null) {
            for (IBoundaryPart boundaryPart : list) {
                int index2;
                int endIndex;
                IBoundary boundary = boundaryPart.getBoundary();
                int startIndex = boundary.getStartIndex();
                if (startIndex != index1) continue;
                if (retPart == null) {
                    retPart = boundaryPart;
                }
                if ((endIndex = boundary.getEndIndex()) < (index2 = retPart.getBoundary().getEndIndex())) continue;
                retPart = boundaryPart;
            }
        }
        return retPart;
    }

    private IBranchPart findFirstChild(IBranchPart current) {
        List<IBranchPart> subBranches = current.getSubBranches();
        if (!subBranches.isEmpty()) {
            return subBranches.get(0);
        }
        subBranches = current.getSummaryBranches();
        if (!subBranches.isEmpty()) {
            return subBranches.get(0);
        }
        return null;
    }

    private IBranchPart findSucceedingSiblingOrAncestor(IBranchPart current) {
        IBranchPart parent = current.getParentBranch();
        if (parent != null) {
            List<IBranchPart> branches = parent.getSubBranches();
            int index = branches.indexOf(current);
            if (index >= 0 && index < branches.size() - 1) {
                return branches.get(index + 1);
            }
            int lastBranchIndex = branches.size() - 1;
            branches = parent.getSummaryBranches();
            if (branches.size() > 0 && index == lastBranchIndex) {
                this.isSummaryPart = true;
                return branches.get(0);
            }
            index = branches.indexOf(current);
            if (index >= 0 && index < branches.size() - 1) {
                this.isSummaryPart = true;
                return branches.get(index + 1);
            }
            return this.findSucceedingSiblingOrAncestor(parent);
        }
        if (current.getParent() instanceof ISheetPart) {
            ISheetPart sheet = (ISheetPart)current.getParent();
            List<IBranchPart> floatingBranches = sheet.getFloatingBranches();
            if (current == sheet.getCentralBranch()) {
                if (!floatingBranches.isEmpty()) {
                    return floatingBranches.get(0);
                }
            } else {
                int index = floatingBranches.indexOf(current);
                if (index >= 0) {
                    if (index < floatingBranches.size() - 1) {
                        IBranchPart floatBranch = floatingBranches.get(index + 1);
                        return floatBranch;
                    }
                    return sheet.getCentralBranch();
                }
            }
        }
        return current;
    }

    private boolean hasBoundaryPart(IBranchPart current) {
        List<IBoundaryPart> boundaries = current.getBoundaries();
        return !boundaries.isEmpty();
    }

    private IPart findPrecedingPart(IPart current) {
        if (current instanceof ITopicPart) {
            ITopicPart topicPart = (ITopicPart)current;
            IBranchPart branch = topicPart.getOwnerBranch();
            if (branch != null) {
                if (branch.isCentral()) {
                    return null;
                }
                IBranchPart prevBranch = this.findPrecedingBranch(branch);
                return this.getPrecedingPart(prevBranch, branch);
            }
        } else {
            if (current instanceof ILabelPart) {
                IBranchPart branch = ((ILabelPart)current).getOwnedBranch();
                return branch.getTopicPart();
            }
            if (current instanceof IRelationshipPart) {
                IRelationshipPart toFindPart = (IRelationshipPart)current;
                IRelationshipPart findPart = this.findPrevOrNextRelationPart(toFindPart, false);
                if (toFindPart == findPart) {
                    return this.getPrecedingPart1(this.tempPart);
                }
                return findPart;
            }
            if (current instanceof IBoundaryPart) {
                IBoundaryPart boundaryPart = (IBoundaryPart)current;
                return this.getPrevPart(boundaryPart);
            }
        }
        return current;
    }

    private IPart getPrevPart(IBoundaryPart current) {
        List<IBoundaryPart> list;
        this.refreshMap((IPart)current);
        IBoundary boundary = current.getBoundary();
        IBranchPart branch = current.getOwnedBranch();
        if (boundary.isMasterBoundary()) {
            IBranchPart prevBranch = this.findPrecedingBranch(branch);
            return this.getPrecedingPart1(prevBranch);
        }
        int index1 = boundary.getStartIndex();
        IBoundaryPart retPart = null;
        if (this.map != null && (list = this.map.get(branch)) != null) {
            for (IBoundaryPart boundaryPart : list) {
                int index2;
                int endIndex;
                if (current == boundaryPart) break;
                int startIndex = boundaryPart.getBoundary().getStartIndex();
                if (startIndex != index1) continue;
                if (retPart == null) {
                    retPart = boundaryPart;
                }
                if ((endIndex = boundaryPart.getBoundary().getEndIndex()) > (index2 = retPart.getBoundary().getEndIndex())) continue;
                retPart = boundaryPart;
            }
        }
        if (retPart == null) {
            List<IBranchPart> branches = current.getEnclosingBranches();
            IBranchPart branchPart = branches.get(0);
            IBranchPart prevBranch = this.findPrecedingBranch(branchPart);
            return this.getPrecedingPart1(prevBranch);
        }
        return retPart;
    }

    private IPart getPrecedingPart(IBranchPart prevBranch, IBranchPart branch) {
        IBoundaryPart part;
        this.refreshMap((IPart)branch);
        if (prevBranch == branch && prevBranch.isCentral()) {
            return prevBranch.getTopicPart();
        }
        IBranchPart parent = branch.getParentBranch();
        if (parent == null) {
            parent = branch;
        }
        if (this.isSummaryPart) {
            parent = branch;
            this.isSummaryPart = false;
        }
        if ((part = this.getPreBoundaryPart(parent, branch)) != null) {
            return part;
        }
        return this.getPrecedingPart1(prevBranch);
    }

    private IBoundaryPart getPreBoundaryPart(IBranchPart parent, IBranchPart current) {
        IBoundaryPart retPart = null;
        ITopic topic = current.getTopic();
        List children = parent.getTopic().getAllChildren();
        int index1 = children.indexOf(topic);
        if (this.map == null) {
            return retPart;
        }
        List<IBoundaryPart> list = this.map.get(parent);
        if (list != null) {
            for (IBoundaryPart boundaryPart : list) {
                int index2;
                int endIndex;
                IBoundary boundary = boundaryPart.getBoundary();
                int startIndex = boundary.getStartIndex();
                if (index1 != startIndex) continue;
                if (retPart == null) {
                    retPart = boundaryPart;
                }
                if ((endIndex = boundary.getEndIndex()) > (index2 = retPart.getBoundary().getEndIndex())) continue;
                retPart = boundaryPart;
            }
        }
        return retPart;
    }

    private IPart getPrecedingPart1(IBranchPart branch) {
        ILabelPart labelPart = this.getLabelPart(branch);
        if (labelPart != null) {
            return labelPart;
        }
        return branch.getTopicPart();
    }

    private IBranchPart findPrecedingBranch(IBranchPart current) {
        IBranchPart parent = current.getParentBranch();
        if (parent != null) {
            List<IBranchPart> branches = parent.getSubBranches();
            int index = branches.indexOf(current);
            if (index > 0) {
                return this.findLastDescendant(branches.get(index - 1));
            }
            int lastBranchIndex = branches.size() - 1;
            branches = parent.getSummaryBranches();
            index = branches.indexOf(current);
            if (index == 0) {
                this.isSummaryPart = true;
                return parent.getSubBranches().get(lastBranchIndex);
            }
            if (index > 0) {
                this.isSummaryPart = true;
                return this.findLastDescendant(branches.get(index - 1));
            }
            return parent;
        }
        if (current.getParent() instanceof ISheetPart) {
            ISheetPart sheet = (ISheetPart)current.getParent();
            List<IBranchPart> floatingBranches = sheet.getFloatingBranches();
            if (current == sheet.getCentralBranch()) {
                if (!floatingBranches.isEmpty()) {
                    IBranchPart lastFloating = floatingBranches.get(floatingBranches.size() - 1);
                    return this.findLastDescendant(lastFloating);
                }
            } else if (floatingBranches.contains(current)) {
                int index = floatingBranches.indexOf(current);
                if (index == 0) {
                    return this.findLastDescendant(sheet.getCentralBranch());
                }
                return this.findLastDescendant(floatingBranches.get(index - 1));
            }
        }
        return current;
    }

    private IBranchPart findLastDescendant(IBranchPart branch) {
        List<IBranchPart> summaryBranches = branch.getSummaryBranches();
        if (!summaryBranches.isEmpty()) {
            return this.findLastDescendant(summaryBranches.get(summaryBranches.size() - 1));
        }
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (!subBranches.isEmpty()) {
            return this.findLastDescendant(subBranches.get(subBranches.size() - 1));
        }
        return branch;
    }

    private IRelationshipPart findPrevOrNextRelationPart(IRelationshipPart current, boolean nextOrPrev) {
        ISheetPart sheetPart = current.getOwnerSheet();
        if (sheetPart != null) {
            List<IRelationshipPart> relationships = sheetPart.getRelationships();
            int index = relationships.indexOf(current);
            if (nextOrPrev) {
                if (index >= 0 && index < relationships.size() - 1) {
                    return relationships.get(index + 1);
                }
            } else if (index > 0) {
                return relationships.get(index - 1);
            }
        }
        return current;
    }

    private void refreshMap(IPart source) {
        IBranchPart parent;
        IBranchPart current = null;
        if (source instanceof IBranchPart) {
            current = (IBranchPart)source;
        } else if (source instanceof ILabelPart) {
            current = ((ILabelPart)source).getOwnedBranch();
        } else if (source instanceof IBoundaryPart) {
            current = ((IBoundaryPart)source).getOwnedBranch();
        } else if (source instanceof ITopicPart) {
            current = ((ITopicPart)source).getOwnerBranch();
        }
        if (current == null) {
            return;
        }
        if (this.hasBoundaryPart(current)) {
            if (this.map == null) {
                this.map = new HashMap<IBranchPart, List<IBoundaryPart>>();
            }
            List<IBoundaryPart> boundaries = current.getBoundaries();
            List<IBoundaryPart> list = this.reSort(boundaries.toArray(this.EMPTY));
            this.map.put(current, list);
        }
        if ((parent = current.getParentBranch()) != null && this.hasBoundaryPart(parent)) {
            if (this.map == null) {
                this.map = new HashMap<IBranchPart, List<IBoundaryPart>>();
            }
            List<IBoundaryPart> list1 = parent.getBoundaries();
            List<IBoundaryPart> list2 = this.reSort(list1.toArray(this.EMPTY));
            this.map.put(parent, list2);
        }
    }

    private List<IBoundaryPart> reSort(IBoundaryPart[] boundaries) {
        ArrayList<IBoundaryPart> boundaryList = new ArrayList<IBoundaryPart>(boundaries.length);
        int i = 0;
        while (i < boundaries.length) {
            boundaryList.add(boundaries[i]);
            ++i;
        }
        Collections.sort(boundaryList, new Comparator<IBoundaryPart>(){

            @Override
            public int compare(IBoundaryPart o1, IBoundaryPart o2) {
                IBoundary b1 = o1.getBoundary();
                int startIndex1 = b1.getStartIndex();
                int endIndex1 = b1.getEndIndex();
                IBoundary b2 = o2.getBoundary();
                int startIndex2 = b2.getStartIndex();
                int endIndex2 = b2.getEndIndex();
                if (startIndex1 != startIndex2) {
                    return startIndex1 - startIndex2;
                }
                if (startIndex1 == startIndex2) {
                    return endIndex2 - endIndex1;
                }
                return 0;
            }
        });
        return boundaryList;
    }
}

