/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyRelationshipEndCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.util.MindMapUtils;

public class RelationshipMovablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "move control point".equals(requestType) || "retarget relationship".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("move control point".equals(type)) {
            this.performMoveControlPoint(request);
        } else if ("retarget relationship".equals(type)) {
            this.performRetargetRelationship(request);
        }
    }

    private void performRetargetRelationship(Request request) {
        boolean sourceOrTarget;
        Object param = request.getParameter("moveRel.pointId");
        if (param == null || !(param instanceof Integer)) {
            return;
        }
        int pointId = (Integer)param;
        if (pointId == 1) {
            sourceOrTarget = true;
        } else if (pointId == 2) {
            sourceOrTarget = false;
        } else {
            return;
        }
        IPart newNode = (IPart)request.getParameter("moveRel.newNode");
        if (newNode == null) {
            return;
        }
        Object newEnd = MindMapUtils.getRealModel(newNode);
        if (!(newEnd instanceof IRelationshipEnd)) {
            return;
        }
        String newEndId = ((IRelationshipEnd)newEnd).getId();
        List sources = request.getTargets();
        ArrayList<IRelationship> rels = new ArrayList<IRelationship>(sources.size());
        for (IPart p : sources) {
            Object o = MindMapUtils.getRealModel(p);
            if (!(o instanceof IRelationship)) continue;
            rels.add((IRelationship)o);
        }
        if (rels.isEmpty()) {
            return;
        }
        ModifyRelationshipEndCommand cmd = new ModifyRelationshipEndCommand(rels, newEndId, sourceOrTarget);
        cmd.setLabel(CommandMessages.Command_RetargetRelationship);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }

    private void performMoveControlPoint(Request request) {
        int index;
        if (!request.hasParameter("position")) {
            return;
        }
        Point position = (Point)request.getParameter("position");
        Object param = request.getParameter("moveRel.pointId");
        if (param == null || !(param instanceof Integer)) {
            return;
        }
        int pointId = (Integer)param;
        if (pointId == 3) {
            index = 0;
        } else if (pointId == 4) {
            index = 1;
        } else {
            return;
        }
        List sources = request.getTargets();
        ArrayList<IControlPoint> controlPoints = new ArrayList<IControlPoint>(sources.size());
        for (IPart p : sources) {
            Object o = MindMapUtils.getRealModel(p);
            if (!(o instanceof IRelationship)) continue;
            controlPoints.add(((IRelationship)o).getControlPoint(index));
        }
        if (controlPoints.isEmpty()) {
            return;
        }
        ModifyPositionCommand cmd = new ModifyPositionCommand(controlPoints, MindMapUtils.toModelPosition(position));
        cmd.setLabel(CommandMessages.Command_MoveRelationshipControlPoint);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }
}

