/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.ModifyThemeCommand;
import org.xmind.ui.internal.editpolicies.ModifyStyleCommandBuilder;
import org.xmind.ui.mindmap.MindMapUI;

public class ModifyThemeCommandBuilder
extends CommandBuilder {
    private IStyle sourceTheme;
    private Map<IWorkbook, IStyle> appliedThemes = null;

    public ModifyThemeCommandBuilder(IViewer viewer, ICommandStack commandStack, IStyle theme) {
        super(viewer, commandStack);
        this.sourceTheme = theme;
    }

    public ModifyThemeCommandBuilder(IViewer viewer, CommandBuilder delegate, IStyle theme) {
        super(viewer, delegate);
        this.sourceTheme = theme;
    }

    public IStyle getTheme() {
        return this.sourceTheme;
    }

    public void modify(ISheet sheet) {
        IStyle appliedTheme = this.getAppliedTheme(sheet);
        if (appliedTheme == null) {
            this.add((Command)new ModifyThemeCommand(sheet, null), true);
        } else {
            this.add((Command)new ModifyThemeCommand(sheet, appliedTheme.getId()), true);
        }
        ModifyStyleCommandBuilder modifyStyleBuilder = new ModifyStyleCommandBuilder(this.getViewer(), this, this.createSheetStyleRequest(appliedTheme));
        modifyStyleBuilder.modify((IStyled)sheet);
    }

    private Request createSheetStyleRequest(IStyle appliedTheme) {
        Request request = new Request("modify style");
        request.setParameter("styleProperty.multi-line-colors", (Object)this.getMapStyleValue(appliedTheme, "multi-line-colors"));
        request.setParameter("styleProperty.line-tapered", (Object)this.getMapStyleValue(appliedTheme, "line-tapered"));
        return request;
    }

    private String getMapStyleValue(IStyle theme, String key) {
        if (theme == null) {
            return null;
        }
        IStyle mapStyle = theme.getDefaultStyle("map");
        if (mapStyle == null) {
            return null;
        }
        return mapStyle.getProperty(key);
    }

    private IStyle getAppliedTheme(ISheet sheet) {
        if (this.sourceTheme == null || MindMapUI.getResourceManager().getDefaultTheme().equals(this.sourceTheme)) {
            return null;
        }
        IWorkbook workbook = sheet.getOwnedWorkbook();
        if (workbook == null) {
            return this.sourceTheme;
        }
        if (this.appliedThemes == null) {
            this.appliedThemes = new HashMap<IWorkbook, IStyle>();
        }
        if (!this.appliedThemes.containsKey(workbook)) {
            IStyle appliedTheme = this.createAppliedTheme(workbook);
            this.appliedThemes.put(workbook, appliedTheme);
        }
        return this.appliedThemes.get(workbook);
    }

    private IStyle createAppliedTheme(IWorkbook workbook) {
        IStyleSheet ss = workbook.getStyleSheet();
        return ss.importStyle(this.sourceTheme);
    }
}

