/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.ILabeled;
import org.xmind.core.IPositioned;
import org.xmind.core.IRange;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Point;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.commands.ModifyNumberPrependingCommand;
import org.xmind.ui.commands.ModifyNumberingFormatCommand;
import org.xmind.ui.commands.ModifyNumberingPrefixCommand;
import org.xmind.ui.commands.ModifyNumberingSuffixCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.commands.ModifyTopicRangeCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.ModifyStyleCommandBuilder;
import org.xmind.ui.internal.editpolicies.ModifyThemeCommandBuilder;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "modify".equals(requestType) || "modify hyperlink".equals(requestType) || "modify style".equals(requestType) || "modify label".equals(requestType) || "modify range".equals(requestType) || "modify numbering".equals(requestType) || "reset position".equals(requestType) || "modify theme".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("modify".equals(reqType)) {
            this.modifyText(request);
        } else if ("modify hyperlink".equals(reqType)) {
            this.modifyHyperlink(request);
        } else if ("modify style".equals(reqType)) {
            this.modifyStyle(request);
        } else if ("modify range".equals(reqType)) {
            this.modifyRange(request);
        } else if ("modify label".equals(reqType)) {
            this.modifyLabel(request);
        } else if ("modify numbering".equals(reqType)) {
            this.modifyNumbering(request);
        } else if ("reset position".equals(reqType)) {
            this.resetPosition(request);
        } else if ("modify theme".equals(reqType)) {
            this.modifyTheme(request);
        }
    }

    private void modifyTheme(Request request) {
        IPart target = request.getPrimaryTarget();
        if (!(target instanceof ISheetPart)) {
            return;
        }
        if (!request.hasParameter("resource")) {
            return;
        }
        ISheetPart sheetPart = (ISheetPart)target;
        ISheet sheet = sheetPart.getSheet();
        Object param = request.getParameter("resource");
        IStyle theme = (IStyle)param;
        ModifyThemeCommandBuilder builder = new ModifyThemeCommandBuilder(request.getTargetViewer(), request.getTargetCommandStack(), theme);
        builder.setLabel(CommandMessages.Command_ModifyTheme);
        if (!builder.canStart()) {
            return;
        }
        builder.start();
        builder.modify(sheet);
        builder.end();
    }

    private void resetPosition(Request request) {
        ArrayList<Object> positionOwners = new ArrayList<Object>();
        ArrayList<IRelationship> rels = new ArrayList<IRelationship>();
        IPart target = request.getPrimaryTarget();
        if (target == null || target instanceof ISheetPart) {
            IBranchPart iBranchPart;
            ISheetPart sheet = target == null ? ((IMindMapViewer)request.getTargetViewer()).getSheetPart() : (ISheetPart)target;
            if (sheet != null && (iBranchPart = sheet.getCentralBranch()) != null && MindMapUtils.isSubBranchesFreeable(iBranchPart)) {
                for (IBranchPart main : iBranchPart.getSubBranches()) {
                    if (!MindMapUtils.isBranchFreeable(main)) continue;
                    positionOwners.add(main.getTopic());
                }
            }
        } else {
            List targets = request.getTargets();
            for (IPart iPart : targets) {
                Object o = MindMapUtils.getRealModel(iPart);
                if (o instanceof IPositioned) {
                    IPositioned positionOwner = (IPositioned)o;
                    Point position = positionOwner.getPosition();
                    if (position == null) continue;
                    positionOwners.add(positionOwner);
                    continue;
                }
                if (!(o instanceof IRelationship)) continue;
                rels.add((IRelationship)o);
            }
        }
        if (positionOwners.isEmpty() && rels.isEmpty()) {
            return;
        }
        ArrayList<ModifyPositionCommand> commands = new ArrayList<ModifyPositionCommand>(positionOwners.size() + rels.size() * 2);
        for (IPositioned iPositioned : positionOwners) {
            if (iPositioned instanceof ITopic && !((ITopic)iPositioned).isAttached()) continue;
            commands.add(new ModifyPositionCommand(iPositioned, null));
        }
        for (IRelationship iRelationship : rels) {
            commands.add(new ModifyPositionCommand((IPositioned)iRelationship.getControlPoint(0), null));
            commands.add(new ModifyPositionCommand((IPositioned)iRelationship.getControlPoint(1), null));
        }
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand(commands);
        compoundCommand.setLabel(CommandMessages.Command_ResetPosition);
        this.saveAndRun((Command)compoundCommand, request.getTargetDomain());
    }

    private void modifyNumbering(Request request) {
        List targets = request.getTargets();
        ArrayList<ITopic> topics = new ArrayList<ITopic>(targets.size());
        for (IPart p : targets) {
            Object o = MindMapUtils.getRealModel(p);
            if (!(o instanceof ITopic)) continue;
            ITopic t = ((ITopic)o).getParent();
            if (t == null) {
                t = (ITopic)o;
            }
            if (topics.contains(t)) continue;
            topics.add(t);
        }
        if (topics.isEmpty()) {
            return;
        }
        ArrayList<ModifyCommand> commands = new ArrayList<ModifyCommand>(4);
        if (request.hasParameter("numbering.format")) {
            String newFormat = (String)request.getParameter("numbering.format");
            commands.add(new ModifyNumberingFormatCommand(topics, newFormat));
        }
        if (request.hasParameter("numbering.prefix")) {
            String newPrefix = (String)request.getParameter("numbering.prefix");
            commands.add(new ModifyNumberingPrefixCommand(topics, newPrefix));
        }
        if (request.hasParameter("numbering.suffix")) {
            String newSuffix = (String)request.getParameter("numbering.suffix");
            commands.add(new ModifyNumberingSuffixCommand(topics, newSuffix));
        }
        if (request.hasParameter("numbering.prepending")) {
            Boolean newPrepending = (Boolean)request.getParameter("numbering.prepending");
            commands.add(new ModifyNumberPrependingCommand(topics, newPrepending));
        }
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand(commands);
        cmd.setLabel(CommandMessages.Command_ModifyNumbering);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }

    private void modifyLabel(Request request) {
        if (!request.hasParameter("text")) {
            return;
        }
        String text = (String)request.getParameter("text");
        if (text == null) {
            text = "";
        }
        Collection<String> labels = MindMapUtils.getLabels(text);
        List sources = request.getTargets();
        ArrayList<ModifyLabelCommand> cmds = new ArrayList<ModifyLabelCommand>(sources.size());
        for (IPart p : sources) {
            Object o = MindMapUtils.getRealModel(p);
            if (!(o instanceof ILabeled)) continue;
            cmds.add(new ModifyLabelCommand((ILabeled)o, labels));
        }
        if (cmds.isEmpty()) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand(cmds);
        cmd.setLabel(CommandMessages.Command_ModifyLabels);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
        this.select(cmd.getSources(), request.getTargetViewer());
    }

    private void modifyRange(Request request) {
        IPart target = request.getPrimaryTarget();
        ITopicRange targetRange = (ITopicRange)target.getAdapter(ITopicRange.class);
        if (targetRange == null) {
            return;
        }
        Object param = request.getParameter("range");
        if (param == null || !(param instanceof Object[])) {
            return;
        }
        Object[] newRange = (Object[])param;
        if (newRange.length == 0) {
            return;
        }
        ArrayList<ITopic> topics = new ArrayList<ITopic>(newRange.length);
        ITopic parent = null;
        Object[] objectArray = newRange;
        int n = newRange.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic iTopic;
            Object o = objectArray[n2];
            ITopic t = this.findTopic(o);
            if (t != null && !topics.contains(t) && (iTopic = t.getParent()) != null) {
                if (parent == null) {
                    parent = iTopic;
                    topics.add(t);
                } else if (parent == iTopic) {
                    topics.add(t);
                }
            }
            ++n2;
        }
        if (topics.isEmpty()) {
            return;
        }
        Collections.sort(topics, Core.getTopicComparator());
        ITopic t1 = (ITopic)topics.get(0);
        ITopic t2 = (ITopic)topics.get(topics.size() - 1);
        int index1 = t1.getIndex();
        int index2 = t2.getIndex();
        Collection<? extends ITopicRange> existingRanges = this.getExistingRanges(parent, targetRange);
        if (existingRanges == null) {
            return;
        }
        for (ITopicRange iTopicRange : existingRanges) {
            int start = iTopicRange.getStartIndex();
            int end = iTopicRange.getEndIndex();
            if (start != index1 || end != index2) continue;
            return;
        }
        ModifyTopicRangeCommand modifyTopicRangeCommand = new ModifyTopicRangeCommand((IRange)targetRange, t1, t2);
        modifyTopicRangeCommand.setLabel(this.getModifyRangeLabel(targetRange, topics));
        this.saveAndRun((Command)modifyTopicRangeCommand, request.getTargetDomain());
        this.select(modifyTopicRangeCommand.getSources(), request.getTargetViewer());
    }

    private Collection<? extends ITopicRange> getExistingRanges(ITopic parent, ITopicRange source) {
        if (source instanceof IBoundary) {
            return parent.getBoundaries();
        }
        if (source instanceof ISummary) {
            return parent.getSummaries();
        }
        return null;
    }

    private String getModifyRangeLabel(ITopicRange rangeModel, List<ITopic> topics) {
        if (rangeModel instanceof IBoundary) {
            return CommandMessages.Command_ModifyBoundaryRange;
        }
        if (rangeModel instanceof ISummary) {
            return CommandMessages.Command_ModifySummaryRange;
        }
        return CommandMessages.Command_ModifyRange;
    }

    private ITopic findTopic(Object o) {
        Object model;
        if (o instanceof ITopic) {
            return (ITopic)o;
        }
        if (o instanceof IPart && (model = MindMapUtils.getRealModel((IPart)o)) instanceof ITopic) {
            return (ITopic)model;
        }
        if (o instanceof IAdaptable) {
            return (ITopic)((IAdaptable)o).getAdapter(ITopic.class);
        }
        return null;
    }

    private void modifyStyle(Request request) {
        ModifyStyleCommandBuilder builder = new ModifyStyleCommandBuilder(request);
        String commandLabel = (String)request.getParameter("commandLabel");
        if (commandLabel == null) {
            commandLabel = CommandMessages.Command_ModifyStyle;
        }
        builder.setLabel(commandLabel);
        if (!builder.canStart()) {
            return;
        }
        builder.start();
        List targets = request.getTargets();
        for (IPart target : targets) {
            IStyled source = this.getStyleSource(target);
            if (source == null) continue;
            builder.modify(source);
        }
        builder.end();
    }

    private IStyled getStyleSource(IPart part) {
        IStyled s = (IStyled)part.getAdapter(IStyled.class);
        if (s != null) {
            return s;
        }
        Object m = MindMapUtils.getRealModel(part);
        return m instanceof IStyled ? (IStyled)m : null;
    }

    private void modifyHyperlink(Request request) {
        String hyperlink = (String)request.getParameter("text");
        List<ITopic> topics = MindMapUtils.getTopics(request.getTargets());
        if (topics.isEmpty()) {
            return;
        }
        ModifyTopicHyperlinkCommand cmd = new ModifyTopicHyperlinkCommand(topics, hyperlink);
        cmd.setLabel(CommandMessages.Command_ModifyTopicHyperlink);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }

    private void modifyText(Request request) {
        List targets;
        if (!request.hasParameter("text")) {
            return;
        }
        String text = (String)request.getParameter("text");
        if (text == null) {
            text = "";
        }
        if ((targets = request.getTargets()).isEmpty()) {
            return;
        }
        ArrayList<ITitled> ts = new ArrayList<ITitled>(targets.size());
        for (IPart p : targets) {
            Object m = MindMapUtils.getRealModel(p);
            if (!(m instanceof ITitled) || ts.contains(m)) continue;
            ts.add((ITitled)m);
        }
        if (ts.isEmpty()) {
            return;
        }
        PropertyCommandBuilder builder = new PropertyCommandBuilder(request);
        builder.setLabel(this.getModifyTitleTextLabel(ts));
        builder.start();
        builder.add((Command)new ModifyTitleTextCommand(ts, text), true);
        builder.addSourcesFromRequest(false);
        builder.end();
    }

    private String getModifyTitleTextLabel(List<ITitled> ts) {
        ITitled t = ts.get(0);
        if (t instanceof ITopic) {
            return CommandMessages.Command_ModifyTopicTitle;
        }
        if (t instanceof ISheet) {
            return CommandMessages.Command_ModifySheetTitle;
        }
        if (t instanceof IRelationship) {
            return CommandMessages.Command_ModifyRelationshipTitle;
        }
        if (t instanceof IBoundary) {
            return CommandMessages.Command_ModifyBoundaryTitle;
        }
        return CommandMessages.Command_ModifyTitle;
    }
}

