/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.core.IImage;
import org.xmind.core.ITopic;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyImageAlignmentCommand;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMovablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "resize".equals(requestType) || "move to".equals(requestType) || "copy to".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("resize".equals(type)) {
            this.resizeImage(request);
        } else if ("move to".equals(type)) {
            this.moveImage(request);
        } else if ("copy to".equals(type)) {
            this.copyImage(request);
        }
    }

    private List<IImage> getImages(Request request) {
        List targets = request.getTargets();
        ArrayList<IImage> list = new ArrayList<IImage>(targets.size());
        for (IPart part : targets) {
            Object o = MindMapUtils.getRealModel(part);
            if (!(o instanceof IImage)) continue;
            list.add((IImage)o);
        }
        return list;
    }

    private void resizeImage(Request request) {
        List<IImage> images = this.getImages(request);
        if (images.isEmpty()) {
            return;
        }
        Dimension newSize = (Dimension)request.getParameter("size");
        int width = newSize == null ? -1 : newSize.width;
        int height = newSize == null ? -1 : newSize.height;
        ModifyImageSizeCommand command = new ModifyImageSizeCommand(images, width, height);
        command.setLabel(CommandMessages.Command_ResizeImage);
        this.saveAndRun((Command)command, request.getTargetDomain());
    }

    private void moveImage(Request request) {
        this.copyImage(request, true);
    }

    private void copyImage(Request request) {
        this.copyImage(request, false);
    }

    private void copyImage(Request request, boolean deleteSource) {
        List<IImage> images = this.getImages(request);
        if (images.isEmpty()) {
            return;
        }
        IImage sourceImage = images.get(0);
        Object param = request.getParameter("parent");
        if (param == null || !(param instanceof ITopicPart)) {
            return;
        }
        ITopicPart targetParent = (ITopicPart)param;
        String alignParamName = "property.imageAlignment";
        String alignment = (String)request.getParameter(alignParamName);
        ArrayList<ModifyCommand> cmds = new ArrayList<ModifyCommand>(images.size() * 2);
        ITopic targetTopic = targetParent.getTopic();
        if (sourceImage.getParent() == targetTopic) {
            if (request.hasParameter(alignParamName)) {
                cmds.add(new ModifyImageAlignmentCommand(sourceImage, alignment));
            }
        } else {
            IImage targetImage = targetTopic.getImage();
            cmds.add(new ModifyImageSourceCommand(targetImage, sourceImage.getSource()));
            cmds.add(new ModifyImageSizeCommand(targetImage, sourceImage.getWidth(), sourceImage.getHeight()));
            if (request.hasParameter(alignParamName)) {
                cmds.add(new ModifyImageAlignmentCommand(targetImage, alignment));
            } else {
                cmds.add(new ModifyImageAlignmentCommand(targetImage, sourceImage.getAlignment()));
            }
            if (deleteSource) {
                ModifyImageSourceCommand m1 = new ModifyImageSourceCommand(sourceImage, null);
                m1.setSourceCollectable(false);
                cmds.add(m1);
                ModifyImageSizeCommand m2 = new ModifyImageSizeCommand(sourceImage, -1, -1);
                m2.setSourceCollectable(false);
                cmds.add(m2);
                ModifyImageAlignmentCommand m3 = new ModifyImageAlignmentCommand(sourceImage, null);
                m3.setSourceCollectable(false);
                cmds.add(m3);
            }
        }
        if (cmds.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand(cmds);
        command.setLabel(deleteSource ? CommandMessages.Command_MoveImage : CommandMessages.Command_CopyImage);
        this.saveAndRun((Command)command, request.getTargetDomain());
        this.select(command.getSources(), request.getTargetViewer());
    }
}

