/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IBoundary;
import org.xmind.core.ICloneData;
import org.xmind.core.IImage;
import org.xmind.core.IPositioned;
import org.xmind.core.IRange;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddBoundaryCommand;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.commands.ModifyBoundaryMasterCommand;
import org.xmind.ui.commands.ModifyImageAlignmentCommand;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.commands.ModifyTopicRangeCommand;
import org.xmind.ui.internal.editpolicies.DeletablePolicy;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditablePolicy
extends DeletablePolicy {
    private static final String DEFAULT_DND_CLIENT_ID = "org.xmind.ui.dnd.mindMapElement";

    @Override
    public boolean understands(String requestType) {
        return super.understands(requestType) || "copy".equals(requestType) || "cut".equals(requestType) || "paste".equals(requestType) || "replace all".equals(requestType);
    }

    @Override
    public void handle(Request request) {
        String reqType = request.getType();
        if ("copy".equals(reqType)) {
            this.copy(request);
        } else if ("cut".equals(reqType)) {
            this.cut(request);
        } else if ("paste".equals(reqType)) {
            this.paste(request);
        } else if ("replace all".equals(reqType)) {
            this.replaceAll(request);
        } else if (!"delete".equals(reqType)) {
            super.handle(request);
        }
    }

    protected void copy(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        List sources = request.getTargets();
        List<Object> models = this.filter(MindMapUtils.getRealModels(sources), viewer);
        if (models.isEmpty()) {
            return;
        }
        this.performCopy(models.toArray(), request.getTargetViewer());
    }

    protected List<Object> filter(List<Object> elements, IViewer viewer) {
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        ITopic root = (ITopic)viewer.getAdapter(ITopic.class);
        ArrayList<Object> list = new ArrayList<Object>(elements.size());
        for (Object o : elements) {
            if (this.shouldRemove(o, elements, sheet, root, viewer)) continue;
            list.add(o);
        }
        return list;
    }

    private boolean shouldRemove(Object element, List<Object> elements, ISheet sheet, ITopic root, IViewer viewer) {
        block7: {
            block6: {
                if (!(element instanceof IRelationship)) break block6;
                IRelationship r = (IRelationship)element;
                for (Object o : elements) {
                    if (!(o instanceof ISheet) || !o.equals(r.getParent())) continue;
                    return true;
                }
                break block7;
            }
            if (!(element instanceof ITopicComponent)) break block7;
            ITopicComponent c = (ITopicComponent)element;
            ISheet s = null;
            ITopic p = null;
            for (Object o : elements) {
                if (o instanceof ISheet) {
                    if (s == null) {
                        s = c.getOwnedSheet();
                    }
                    if (o.equals(s)) {
                        return true;
                    }
                }
                if (p == null) {
                    p = c.getParent();
                }
                if (!(o instanceof ITopic) || p == null || !MindMapUtils.isDescendentOf(p, (ITopic)o)) continue;
                return true;
            }
        }
        return false;
    }

    protected void performCopy(Object[] elements, IViewer viewer) {
        String[] ids;
        IDndSupport dndSupport = viewer.getDndSupport();
        if (dndSupport != null && (ids = dndSupport.getDndClientIds()).length > 0) {
            ArrayList<Object> data = new ArrayList<Object>(ids.length);
            ArrayList<Transfer> transfers = new ArrayList<Transfer>(ids.length);
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                String id = stringArray[n2];
                IDndClient client = dndSupport.getDndClient(id);
                if (client != null && (object = client.toTransferData(elements, viewer)) != null) {
                    data.add(object);
                    transfers.add(client.getTransfer());
                }
                ++n2;
            }
            if (!data.isEmpty()) {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(data.toArray(), transfers.toArray(new Transfer[0]));
                clipboard.dispose();
            }
        }
    }

    protected void cut(Request request) {
        List sources = request.getTargets();
        List<Object> models = MindMapUtils.getRealModels(sources);
        if (models.isEmpty()) {
            return;
        }
        this.performCopy(models.toArray(), request.getTargetViewer());
        this.delete(request);
    }

    @Override
    protected String getDeleteLabel(String type) {
        if ("org.xmind.ui.topic".equals(type)) {
            return CommandMessages.Command_CutTopic;
        }
        if ("org.xmind.ui.relationship".equals(type)) {
            return CommandMessages.Command_CutRelationship;
        }
        if ("org.xmind.ui.marker".equals(type)) {
            return CommandMessages.Command_DeleteMarker;
        }
        if ("org.xmind.ui.sheet".equals(type)) {
            return CommandMessages.Command_CutSheet;
        }
        if ("org.xmind.ui.boundary".equals(type)) {
            return CommandMessages.Command_DeleteBoundary;
        }
        return CommandMessages.Command_Cut;
    }

    protected void paste(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        ISheet targetSheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (targetSheet == null) {
            return;
        }
        IWorkbook targetWorkbook = targetSheet.getParent();
        if (targetWorkbook == null) {
            return;
        }
        IPart target = request.getPrimaryTarget();
        Object targetModel = target == null ? viewer.getAdapter(ITopic.class) : MindMapUtils.getRealModel(target);
        Object[] elements = this.getElementsFromClipboard(viewer, targetModel);
        if (elements == null || elements.length == 0) {
            return;
        }
        this.paste(request, elements, viewer, target, MindMapUtils.getRealModels(request.getTargets()).toArray(), targetWorkbook);
    }

    protected void paste(Request request, Object[] elements, IViewer viewer, IPart targetPart, Object[] targets, IWorkbook targetWorkbook) {
        ICloneData result = targetWorkbook.clone((Collection)Arrays.asList(elements));
        if (!result.hasCloned()) {
            return;
        }
        Collection cloneds = result.getCloneds();
        ITopic targetTopic = targets.length > 0 && targets[0] instanceof ITopic ? (ITopic)targets[0] : (ITopic)viewer.getAdapter(ITopic.class);
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        ArrayList<Object> cmds = new ArrayList<Object>(cloneds.size());
        for (Object cloned : cloneds) {
            if (cloned instanceof ITopic) {
                if (targetTopic == null) continue;
                ITopic clonedTopic = (ITopic)cloned;
                AddTopicCommand addTopic = new AddTopicCommand(clonedTopic, targetTopic, -1, "attached");
                cmds.add((Object)addTopic);
                ModifyPositionCommand resetPosition = new ModifyPositionCommand((IPositioned)clonedTopic, null);
                cmds.add((Object)resetPosition);
                continue;
            }
            if (cloned instanceof IRelationship) {
                if (sheet == null) continue;
                IRelationship clonedRelationship = (IRelationship)cloned;
                AddRelationshipCommand addRel = new AddRelationshipCommand(clonedRelationship, sheet);
                cmds.add((Object)addRel);
                continue;
            }
            if (cloned instanceof IMarker || cloned instanceof IMarkerRef) {
                IMarker marker;
                if (targetTopic == null) continue;
                IMarker iMarker = marker = cloned instanceof IMarker ? (IMarker)cloned : ((IMarkerRef)cloned).getMarker();
                if (marker == null) continue;
                IMarkerGroup group = marker.getParent();
                if (group.isSingleton()) {
                    for (IMarker m : group.getMarkers()) {
                        if (!targetTopic.hasMarker(m.getId())) continue;
                        cmds.add((Object)new DeleteMarkerCommand(targetTopic, m.getId()));
                    }
                }
                String markerId = cloned instanceof IMarker ? ((IMarker)cloned).getId() : ((IMarkerRef)cloned).getMarkerId();
                AddMarkerCommand addMarker = new AddMarkerCommand(targetTopic, markerId);
                cmds.add((Object)addMarker);
                continue;
            }
            if (cloned instanceof IBoundary) {
                IBoundary b = (IBoundary)cloned;
                List<ITopic> topics = this.getSiblingTopics(targets);
                if (topics.isEmpty() || this.hasBoundary(topics)) continue;
                if (topics.get(0).isAttached()) {
                    cmds.add((Object)new ModifyTopicRangeCommand((IRange)b, topics.get(0), topics.get(topics.size() - 1)));
                    cmds.add((Object)new AddBoundaryCommand(b, topics.get(0).getParent()));
                    continue;
                }
                if (topics.size() != 1 || topics.get(0).isRoot()) continue;
                cmds.add((Object)new ModifyBoundaryMasterCommand(b, true));
                cmds.add((Object)new AddBoundaryCommand(b, topics.get(0)));
                continue;
            }
            if (!(cloned instanceof IImage)) continue;
            IImage image = (IImage)cloned;
            if (targetTopic == null) continue;
            cmds.add((Object)new ModifyImageSourceCommand(targetTopic, image.getSource()));
            cmds.add((Object)new ModifyImageSizeCommand(targetTopic, image.getWidth(), image.getHeight()));
            cmds.add((Object)new ModifyImageAlignmentCommand(targetTopic, image.getAlignment()));
        }
        if (cmds.isEmpty()) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand(cmds);
        cmd.setLabel(CommandMessages.Command_Paste);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
        this.select(cmd.getSources(), viewer);
    }

    private List<ITopic> getSiblingTopics(Object[] targets) {
        ITopic start = null;
        ITopic end = null;
        Object[] objectArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ITopic) {
                ITopic t = (ITopic)o;
                if (start != null && MindMapUtils.isDescendentOf(start, t)) {
                    start = null;
                }
                if (end != null && MindMapUtils.isDescendentOf(end, t)) {
                    end = null;
                }
                if (start == null) {
                    start = t;
                } else if (t.getParent().equals(start.getParent()) && t.getType().equals(start.getType()) && t.getIndex() < start.getIndex()) {
                    start = t;
                }
                if (end == null) {
                    end = t;
                } else if (t.getParent().equals(end.getParent()) && t.getType().equals(end.getType()) && t.getIndex() > end.getIndex()) {
                    end = t;
                }
            }
            ++n2;
        }
        if (start == null || end == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(start, end);
    }

    private boolean hasBoundary(List<ITopic> topics) {
        block3: {
            block2: {
                if (!topics.get(0).isAttached()) break block2;
                int startIndex = topics.get(0).getIndex();
                int endIndex = topics.get(topics.size() - 1).getIndex();
                for (IBoundary b : topics.get(0).getParent().getBoundaries()) {
                    if (b.getStartIndex() != startIndex && b.getEndIndex() != endIndex) continue;
                    return true;
                }
                break block3;
            }
            if (topics.size() != 1) break block3;
            for (IBoundary b : topics.get(0).getBoundaries()) {
                if (!b.isMasterBoundary()) continue;
                return true;
            }
        }
        return false;
    }

    protected Object[] getElementsFromClipboard(IViewer viewer, Object target) {
        String[] ids;
        IDndSupport dndSupport = viewer.getDndSupport();
        if (dndSupport != null && (ids = dndSupport.getDndClientIds()).length > 0) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                Object[] objectArray = this.getElementsFromClipboard(viewer, target, clipboard, dndSupport, ids);
                return objectArray;
            }
            finally {
                clipboard.dispose();
            }
        }
        return null;
    }

    protected Object[] getElementsFromClipboard(IViewer viewer, Object target, Clipboard clipboard, IDndSupport dndSupport, String[] ids) {
        Object[] elements;
        TransferData[] types = clipboard.getAvailableTypes();
        IDndClient elementClient = dndSupport.getDndClient(DEFAULT_DND_CLIENT_ID);
        if (elementClient != null && (elements = this.getElementsFromClipboard(viewer, target, elementClient, clipboard, types)) != null) {
            return elements;
        }
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            IDndClient client;
            Object[] elements2;
            String id = stringArray[n2];
            if (!DEFAULT_DND_CLIENT_ID.equals(id) && (elements2 = this.getElementsFromClipboard(viewer, target, client = dndSupport.getDndClient(id), clipboard, types)) != null) {
                return elements2;
            }
            ++n2;
        }
        return null;
    }

    protected Object[] getElementsFromClipboard(IViewer viewer, Object target, IDndClient client, Clipboard clipboard, TransferData[] types) {
        if (client == null) {
            return null;
        }
        Transfer transfer = client.getTransfer();
        if (transfer == null) {
            return null;
        }
        TransferData[] transferDataArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object contents;
            TransferData type = transferDataArray[n2];
            if (transfer.isSupportedType(type) && (contents = clipboard.getContents(transfer)) != null) {
                return client.toViewerElements(contents, viewer, target);
            }
            ++n2;
        }
        return null;
    }

    private void replaceAll(Request request) {
        PropertyCommandBuilder builder;
        String text = (String)request.getParameter("text");
        String replacement = (String)request.getParameter("replacement");
        if (text == null || replacement == null) {
            return;
        }
        boolean ignoreCase = Boolean.TRUE.equals(request.getParameter("ignoreCase"));
        List targets = request.getTargets();
        if (targets.isEmpty()) {
            return;
        }
        if (ignoreCase) {
            text = text.toLowerCase();
        }
        if ((builder = new PropertyCommandBuilder(request)).canStart()) {
            builder.start();
            for (IPart target : targets) {
                Object model = MindMapUtils.getRealModel(target);
                if (!(model instanceof ITitled)) continue;
                ITitled t = (ITitled)model;
                String oldText = t.getTitleText();
                if (oldText != null) {
                    String newText;
                    String searchText = ignoreCase ? oldText.toLowerCase() : oldText;
                    StringBuilder sb = new StringBuilder(oldText.length() + replacement.length());
                    int start = 0;
                    int index = searchText.indexOf(text);
                    while (index >= 0) {
                        sb.append(oldText.substring(start, index));
                        sb.append(replacement);
                        start = index + text.length();
                        index = searchText.indexOf(text, start);
                    }
                    if (start < oldText.length()) {
                        sb.append(oldText.substring(start));
                    }
                    if (!(newText = sb.toString()).equals(oldText)) {
                        builder.add((Command)new ModifyTitleTextCommand(t, newText), true);
                    }
                }
                builder.addSource(t, true);
            }
            builder.end();
        }
    }
}

