/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.Arrays;
import java.util.Collection;
import org.xmind.core.ICloneData;
import org.xmind.core.IPositioned;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.mindmap.IMindMapDndClient;
import org.xmind.ui.util.MindMapUtils;

public class DropTargetPolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "drop".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("drop".equals(type)) {
            this.drop(request);
        }
    }

    private void drop(Request request) {
        DndData dndData = (DndData)request.getParameter("dndData");
        if (dndData == null) {
            return;
        }
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        IDndSupport dndSupport = viewer.getDndSupport();
        if (dndSupport == null) {
            return;
        }
        ISheet targetSheet = (ISheet)viewer.getAdapter(ISheet.class);
        IWorkbook targetWorkbook = targetSheet == null ? null : targetSheet.getParent();
        IPart targetParent = (IPart)request.getParameter("parent");
        Object targetModel = targetParent == null ? viewer.getAdapter(ITopic.class) : MindMapUtils.getRealModel(targetParent);
        IDndClient client = dndSupport.getDndClient(dndData.clientId);
        if (client != null) {
            Object[] elements;
            if (client instanceof IMindMapDndClient && ((IMindMapDndClient)client).handleRequest(request, dndData)) {
                return;
            }
            if (targetWorkbook != null && (elements = client.toViewerElements(dndData.parsedData, viewer, targetModel)) != null && elements.length > 0) {
                this.copy(request, elements, viewer, targetModel, targetWorkbook);
                return;
            }
        }
    }

    protected void copy(Request request, Object[] elements, IViewer viewer, Object target, IWorkbook targetWorkbook) {
        ICloneData result = targetWorkbook.clone((Collection)Arrays.asList(elements));
        if (!result.hasCloned()) {
            return;
        }
        Collection cloneds = result.getCloneds();
        ITopic parentTopic = target instanceof ITopic ? (ITopic)target : (ITopic)viewer.getAdapter(ITopic.class);
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        int index = request.getIntParameter("index", -1);
        PropertyCommandBuilder builder = new PropertyCommandBuilder(request);
        if (!builder.canStart()) {
            return;
        }
        builder.start();
        builder.setLabel(CommandMessages.Command_AddResources);
        for (Object cloned : cloneds) {
            if (cloned instanceof ITopic) {
                if (parentTopic != null) {
                    ITopic clonedTopic = (ITopic)cloned;
                    builder.add((Command)new AddTopicCommand(clonedTopic, parentTopic, index, "attached"), true);
                    builder.add((Command)new ModifyPositionCommand((IPositioned)clonedTopic, null), true);
                    if (index >= 0) {
                        ++index;
                    }
                }
            } else if (cloned instanceof IRelationship) {
                if (sheet != null) {
                    IRelationship clonedRelationship = (IRelationship)cloned;
                    builder.add((Command)new AddRelationshipCommand(clonedRelationship, sheet), true);
                }
            } else if ((cloned instanceof IMarkerRef || cloned instanceof IMarker) && parentTopic != null) {
                IMarker marker;
                IMarker iMarker = marker = cloned instanceof IMarker ? (IMarker)cloned : ((IMarkerRef)cloned).getMarker();
                if (marker != null) {
                    IMarkerGroup group = marker.getParent();
                    if (group.isSingleton()) {
                        for (IMarker m : group.getMarkers()) {
                            if (!parentTopic.hasMarker(m.getId())) continue;
                            builder.add((Command)new DeleteMarkerCommand(parentTopic, m.getId()), false);
                        }
                    }
                    String markerId = cloned instanceof IMarker ? ((IMarker)cloned).getId() : ((IMarkerRef)cloned).getMarkerId();
                    AddMarkerCommand addMarker = new AddMarkerCommand(parentTopic, markerId);
                    builder.add((Command)addMarker, true);
                }
            }
            builder.addSource(cloned, true);
        }
        builder.end();
        this.select(builder.getCommand().getSources(), viewer);
    }
}

