/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.osgi.framework.Bundle;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.ISheet;
import org.xmind.core.ITitled;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ICommandStackAction;
import org.xmind.gef.ui.actions.RedoAction;
import org.xmind.gef.ui.actions.UndoAction;
import org.xmind.gef.ui.editor.GraphicalEditor;
import org.xmind.gef.ui.editor.GraphicalEditorPagePopupPreviewHelper;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IMiniBarContributor;
import org.xmind.gef.ui.editor.MultiGraphicalPageSelectionProvider;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.commands.MoveSheetCommand;
import org.xmind.ui.dialogs.SimpleInfoPopupDialog;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.CreateSheetAction;
import org.xmind.ui.internal.actions.DeleteSheetAction;
import org.xmind.ui.internal.actions.ShowPropertiesAction;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.editor.DialogPane;
import org.xmind.ui.internal.editor.DialogPaneContainer;
import org.xmind.ui.internal.editor.EditorInputMonitor;
import org.xmind.ui.internal.editor.ErrorDetailsDialog;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.editor.MindMapEditorConfigurerManager;
import org.xmind.ui.internal.editor.MindMapEditorPage;
import org.xmind.ui.internal.editor.MindMapFindReplaceOperationProvider;
import org.xmind.ui.internal.editor.MindMapMiniBarContributor;
import org.xmind.ui.internal.editor.WorkbookRef;
import org.xmind.ui.internal.editor.WorkbookRefManager;
import org.xmind.ui.internal.findreplace.IFindReplaceOperationProvider;
import org.xmind.ui.internal.layers.MindMapLayeredPane;
import org.xmind.ui.internal.mindmap.MindMapEditDomain;
import org.xmind.ui.internal.mindmap.MindMapRootPart;
import org.xmind.ui.internal.outline.MindMapOutlinePage;
import org.xmind.ui.internal.properties.MindMapPropertySheetPage;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapPreviewBuilder;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tabfolder.IPageMoveListener;
import org.xmind.ui.tabfolder.IPageTitleChangedListener;
import org.xmind.ui.tabfolder.PageMoveHelper;
import org.xmind.ui.tabfolder.PageTitleEditor;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;

public class MindMapEditor
extends GraphicalEditor
implements ISaveablePart2,
ICoreEventListener,
IPageMoveListener,
IPageTitleChangedListener {
    private static boolean PROMPT_COMPATIBILITY_WARNING = false;
    private WorkbookRef workbookRef = null;
    private ICoreEventRegister eventRegister = null;
    private PageTitleEditor pageTitleEditor = null;
    private PageMoveHelper pageMoveHelper = null;
    private IContentOutlinePage outlinePage = null;
    private IPropertySheetPage propertyPage = null;
    private MindMapFindReplaceOperationProvider findReplaceOperationProvider = null;
    private EditorInputMonitor inputMonitor = null;
    private Composite parent = null;
    private StackLayout paneSwitcher = null;
    private Composite pageContainer = null;
    private LoadWorkbookJob loadWorkbookJob = null;
    private MindMapEditorBackCover backCover = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        try {
            WorkbookRefManager manager = WorkbookRefManager.getInstance();
            this.workbookRef = manager.addReferrer(input, (IEditorPart)this);
        }
        catch (org.eclipse.core.runtime.CoreException e) {
            throw new PartInitException(NLS.bind((String)MindMapMessages.MindMapEditor_partInitException_message, (Object)input), (Throwable)e);
        }
        super.init();
        this.setMiniBarContributor((IMiniBarContributor)new MindMapMiniBarContributor());
    }

    protected void initEditorActions(IActionRegistry actionRegistry) {
        super.initEditorActions(actionRegistry);
        UndoAction undoAction = new UndoAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)undoAction);
        this.addCommandStackAction((ICommandStackAction)undoAction);
        RedoAction redoAction = new RedoAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)redoAction);
        this.addCommandStackAction((ICommandStackAction)redoAction);
        CreateSheetAction createSheetAction = new CreateSheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)createSheetAction);
        DeleteSheetAction deleteSheetAction = new DeleteSheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)deleteSheetAction);
        ShowPropertiesAction showPropertiesAction = new ShowPropertiesAction(this.getSite().getWorkbenchWindow());
        actionRegistry.addAction((IAction)showPropertiesAction);
    }

    protected ICommandStack createCommandStack() {
        return this.workbookRef.getCommandStack();
    }

    protected ISelectionProvider createSelectionProvider() {
        return new MindMapEditorSelectionProvider();
    }

    public void dispose() {
        WorkbookRefManager.getInstance().removeReferrer(this.getEditorInput(), (IEditorPart)this);
        if (this.inputMonitor != null) {
            this.inputMonitor.dispose();
            this.inputMonitor = null;
        }
        if (this.propertyPage != null) {
            this.propertyPage.dispose();
            this.propertyPage = null;
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        if (this.loadWorkbookJob != null) {
            this.loadWorkbookJob.notifyEditorClose();
            this.loadWorkbookJob = null;
        }
        if (this.backCover != null) {
            this.backCover.dispose();
            this.backCover = null;
        }
        super.dispose();
        this.eventRegister = null;
        this.pageTitleEditor = null;
        this.pageMoveHelper = null;
        this.findReplaceOperationProvider = null;
        this.workbookRef = null;
        this.parent = null;
        this.paneSwitcher = null;
        this.pageContainer = null;
    }

    protected void disposeCommandStack(ICommandStack commandStack) {
    }

    protected Composite createPageContainer(Composite parent) {
        this.parent = parent;
        this.paneSwitcher = new StackLayout();
        parent.setLayout((Layout)this.paneSwitcher);
        this.pageContainer = new Composite(parent, 0);
        this.paneSwitcher.topControl = this.pageContainer;
        return this.pageContainer;
    }

    protected void showPane(Control pane) {
        this.paneSwitcher.topControl = pane;
        this.parent.layout(true);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getContainer() instanceof CTabFolder) {
            final CTabFolder tabFolder = (CTabFolder)this.getContainer();
            this.pageMoveHelper = new PageMoveHelper(tabFolder);
            this.pageMoveHelper.addListener((IPageMoveListener)this);
            this.pageTitleEditor = new PageTitleEditor(tabFolder);
            this.pageTitleEditor.addPageTitleChangedListener((IPageTitleChangedListener)this);
            this.pageTitleEditor.setContextId((IServiceLocator)this.getSite(), "org.xmind.ui.context.mindmap.textEdit");
            new MindMapEditorPagePopupPreviewHelper((IGraphicalEditor)this, tabFolder);
            tabFolder.addListener(8, new Listener(){

                public void handleEvent(Event event) {
                    CTabItem item = tabFolder.getItem(new Point(event.x, event.y));
                    if (item == null) {
                        MindMapEditor.this.createSheet();
                    }
                }
            });
        }
        MindMapEditorConfigurerManager.getInstance().configureEditor(this);
        this.inputMonitor = new EditorInputMonitor(this);
        if (this.getWorkbook() == null && this.loadWorkbookJob == null) {
            this.loadWorkbookJob = new LoadWorkbookJob();
            this.loadWorkbookJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    MindMapEditor.this.loadWorkbookJob = null;
                }
            });
            this.loadWorkbookJob.schedule();
        }
        this.fireDirty();
    }

    private void showWorkbook() {
        this.installModelListener();
        this.parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (MindMapEditor.this.parent.isDisposed()) {
                    return;
                }
                MindMapEditor.this.showPane((Control)MindMapEditor.this.pageContainer);
                MindMapEditor.this.createInitialPages();
                MindMapEditor.this.firePropertyChange(258);
                MindMapEditor.this.fireDirty();
            }
        });
    }

    protected void createInitialPages() {
        this.updateNames();
        if (this.getWorkbook() == null) {
            return;
        }
        super.createInitialPages();
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            this.configurePage(page);
            ++n2;
        }
    }

    private void configurePage(IGraphicalEditorPage page) {
        MindMapEditorConfigurerManager.getInstance().configurePage(page);
    }

    protected void createPages() {
        for (ISheet sheet : this.getWorkbook().getSheets()) {
            this.createSheetPage(sheet, -1);
        }
        if (this.getPageCount() > 0) {
            this.setActivePage(0);
        }
        this.checkWorkbookVersion();
    }

    private void checkWorkbookVersion() {
        if (!PROMPT_COMPATIBILITY_WARNING) {
            return;
        }
        String version = this.getWorkbook().getVersion();
        if (Core.getCurrentVersion().equals(version)) {
            return;
        }
        final SimpleInfoPopupDialog popup = new SimpleInfoPopupDialog(this.getSite().getShell(), DialogMessages.CompatibilityWarning_title, DialogMessages.CompatibilityWarning_message, 2);
        popup.popUp((Control)this.getContainer());
        this.getContainer().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                popup.close();
            }
        });
    }

    protected IGraphicalEditorPage createSheetPage(ISheet sheet, int index) {
        MindMapEditorPage page = new MindMapEditorPage();
        page.init((IGraphicalEditor)this, sheet);
        this.addPage((IGraphicalEditorPage)page);
        page.updatePageTitle();
        if (index >= 0 && index < this.getPageCount()) {
            this.movePageTo(this.findPage((IGraphicalEditorPage)page), index);
        }
        if (this.getActivePage() != index) {
            this.setActivePage(index);
        }
        return page;
    }

    protected EditDomain createEditDomain(IGraphicalEditorPage page) {
        MindMapEditDomain domain = new MindMapEditDomain();
        domain.setCommandStack(this.getCommandStack());
        return domain;
    }

    protected void updateNames() {
        this.setPartName(this.getEditorInput().getName());
        this.setTitleToolTip(this.getEditorInput().getToolTipText());
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    private int promptWorkbookVersion(String fileName) {
        IWorkbook workbook = this.getWorkbook();
        if (Core.getCurrentVersion().equals(workbook.getVersion())) {
            return -1;
        }
        String messages = NLS.bind((String)DialogMessages.ConfirmWorkbookVersion_message, (Object)fileName);
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), DialogMessages.ConfirmWorkbookVersion_title, null, messages, 3, new String[]{DialogMessages.ConfirmWorkbookVersion_SaveAs, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open();
    }

    public void doSave(final IProgressMonitor monitor) {
        if (!this.getEditorInput().exists() || !this.workbookRef.isSaveable()) {
            this.doSaveAs(monitor);
        } else {
            int ret = this.promptWorkbookVersion(this.getPartName());
            if (ret == 1) {
                return;
            }
            if (ret == 0) {
                this.doSaveAs(monitor);
            } else {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        MindMapEditor.this.workbookRef.saveWorkbook(monitor);
                        MindMapEditor.super.doSave(monitor);
                    }
                });
            }
        }
    }

    public void doSaveAs(IProgressMonitor monitor, String filterExtension, String filterName) {
        if (this.getWorkbook() == null) {
            monitor.setCanceled(true);
            return;
        }
        Bundle ide = Platform.getBundle((String)"org.eclipse.ui.ide");
        if (ide != null) {
            this.saveAsResource(ide, monitor, filterExtension, filterName);
        } else {
            this.saveAsFile(monitor, filterExtension, filterName);
        }
    }

    private void saveAsFile(final IProgressMonitor monitor, String filterExtension, String filterName) {
        String result;
        String path;
        String proposalName;
        String extension = filterExtension;
        File oldFile = MME.getFile(this.getEditorInput());
        if (oldFile != null) {
            proposalName = FileUtils.getNoExtensionFileName((String)oldFile.getName());
            path = oldFile.getParent();
        } else {
            String name = this.getWorkbook().getPrimarySheet().getRootTopic().getTitleText();
            proposalName = MindMapUtils.trimFileName(name);
            path = null;
        }
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
        dialog.setFileName(proposalName);
        dialog.setFilterExtensions(new String[]{"*" + extension});
        dialog.setFilterNames(new String[]{filterName});
        if (path != null) {
            dialog.setFilterPath(path);
        }
        if ((result = this.openSaveDialog(dialog, extension)) == null) {
            monitor.setCanceled(true);
            return;
        }
        BusyIndicator.showWhile((Display)this.parent.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                String errorMessage = NLS.bind((String)DialogMessages.FailedToSaveWorkbook_message, (Object)result);
                SafeRunner.run((ISafeRunnable)new SafeRunnable(errorMessage){

                    public void run() throws Exception {
                        MindMapEditor.this.changeInput(MME.createFileEditorInput(result), monitor);
                    }
                });
            }
        });
    }

    private void savePreviewPicture() {
        IWorkbook workbook = this.getWorkbook();
        if (workbook == null) {
            return;
        }
        if (workbook.getPassword() != null) {
            URL url = BundleUtility.find((String)"org.xmind.ui", (String)"icons/misc/encrypted_thumbnail.jpg");
            if (url != null) {
                try {
                    new MindMapPreviewBuilder(workbook).saveFrom(url.openStream());
                }
                catch (IOException e) {
                    Logger.log(e, "Failed to save preview image from encrypted_thumbnail.jpg.");
                }
            }
        } else {
            Composite previewCanvas = new Composite(this.parent, 0);
            try {
                try {
                    this.parent.layout(true);
                    new MindMapPreviewBuilder(workbook).save(previewCanvas);
                }
                catch (Throwable e) {
                    Logger.log(e, "Failed to save preview image.");
                    previewCanvas.dispose();
                    this.parent.layout(true);
                }
            }
            finally {
                previewCanvas.dispose();
                this.parent.layout(true);
            }
        }
    }

    private void saveAsResource(Bundle ide, IProgressMonitor monitor, String filterExtension, String filterName) {
    }

    protected void doSaveAs(IProgressMonitor monitor) {
        this.doSaveAs(monitor, ".xmind", DialogMessages.WorkbookFilterName);
    }

    protected String openSaveDialog(FileDialog dialog, String extension) {
        String fileName = dialog.open();
        if (fileName != null) {
            File f;
            if (!fileName.endsWith(extension)) {
                fileName = String.valueOf(fileName) + extension;
            }
            if ((f = new File(fileName)).exists()) {
                boolean overwrite = DialogUtils.confirmOverwrite(this.getSite().getShell(), fileName);
                if (!overwrite) {
                    return this.openSaveDialog(dialog, extension);
                }
                f.delete();
            }
        }
        return fileName;
    }

    public void doSaveAs() {
        this.doSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveAsAllowed() {
        return this.getWorkbook() != null;
    }

    private void changeInput(IEditorInput newInput, IProgressMonitor monitor) throws org.eclipse.core.runtime.CoreException, IOException, CoreException {
        boolean wasSingleRef;
        Assert.isNotNull((Object)newInput);
        IEditorInput oldInput = this.getEditorInput();
        WorkbookRef oldRef = this.workbookRef;
        boolean oldSaveable = oldRef.isSaveable();
        final IWorkbook oldWorkbook = oldRef.getWorkbook();
        boolean bl = wasSingleRef = oldRef.getNumReferrers() == 1;
        if (wasSingleRef && oldSaveable) {
            WorkbookRefManager.getInstance().changeKey(oldInput, newInput, (Object)this);
            oldRef.saveWorkbook(monitor);
        } else {
            WorkbookRef newRef = WorkbookRefManager.getInstance().addReferrer(newInput, (IEditorPart)this);
            newRef.setWorkbook(oldWorkbook);
            Assert.isTrue((boolean)newRef.isSaveable());
            newRef.saveWorkbook(monitor);
            this.uninstallModelListener();
            if (!wasSingleRef) {
                newRef.setWorkbook(null);
                newRef.loadWorkbook(new IEncryptionHandler(){

                    public String retrievePassword() throws CoreException {
                        return oldWorkbook.getPassword();
                    }
                }, monitor);
                IWorkbook newWorkbook = newRef.getWorkbook();
                Assert.isNotNull((Object)newWorkbook);
                int activePage = this.getActivePage();
                int oldPageCount = this.getPageCount();
                for (ISheet sheet : newWorkbook.getSheets()) {
                    MindMapLayeredPane layeredPane;
                    IRootPart rootPart;
                    IGraphicalEditorPage page = this.createSheetPage(sheet, -1);
                    if (MindMapUI.isAnimationEnabled() && (rootPart = page.getViewer().getRootPart()) instanceof MindMapRootPart && (layeredPane = ((MindMapRootPart)rootPart).getLayeredPane()) != null) {
                        layeredPane.setAlpha(255);
                    }
                    this.configurePage(page);
                }
                this.setActivePage(oldPageCount + activePage);
                int i = 0;
                while (i < oldPageCount) {
                    this.removePage(0);
                    ++i;
                }
            }
            this.setCommandStack(newRef.getCommandStack());
            this.workbookRef = newRef;
            WorkbookRefManager.getInstance().removeReferrer(oldInput, (IEditorPart)this);
            this.installModelListener();
        }
        this.setInput(newInput);
        this.firePropertyChange(258);
        super.doSave(monitor);
        this.updateNames();
    }

    public IWorkbookRef getWorkbookRef() {
        return this.workbookRef;
    }

    public IWorkbook getWorkbook() {
        if (this.workbookRef == null) {
            return null;
        }
        return this.workbookRef.getWorkbook();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new MindMapOutlinePage((IGraphicalEditor)this, 770);
            }
            return this.outlinePage;
        }
        if (adapter == IPropertySheetPage.class) {
            if (this.propertyPage == null) {
                this.propertyPage = new MindMapPropertySheetPage((IGraphicalEditor)this);
            }
            return this.propertyPage;
        }
        if (adapter == IWorkbookRef.class) {
            return this.getWorkbookRef();
        }
        if (adapter == IWorkbook.class) {
            return this.getWorkbook();
        }
        if (adapter == PageTitleEditor.class) {
            return this.pageTitleEditor;
        }
        if (adapter == PageMoveHelper.class) {
            return this.pageMoveHelper;
        }
        if (adapter == IFindReplaceOperationProvider.class) {
            if (this.findReplaceOperationProvider == null) {
                this.findReplaceOperationProvider = new MindMapFindReplaceOperationProvider((IGraphicalEditor)this);
            }
            return this.findReplaceOperationProvider;
        }
        return super.getAdapter(adapter);
    }

    protected void installModelListener() {
        super.installModelListener();
        IWorkbook workbook = this.getWorkbook();
        if (workbook instanceof ICoreEventSource) {
            this.eventRegister = new CoreEventRegister((ICoreEventSource)workbook, (ICoreEventListener)this);
            this.eventRegister.register("sheetAdd");
            this.eventRegister.register("sheetRemove");
            this.eventRegister.register("sheetMove");
            this.eventRegister.register("passwordChange");
            this.eventRegister.register("workbookPreSave");
            this.eventRegister.register("workbookPreSaveOnce");
        }
    }

    protected void uninstallModelListener() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.uninstallModelListener();
    }

    public void handleCoreEvent(CoreEvent event) {
        IWorkbook workbook;
        String type = event.getType();
        if ("workbookPreSave".equals(type)) {
            this.savePreviewPicture();
        } else if ("workbookPreSaveOnce".equals(type)) {
            this.fireDirty();
        } else if ("sheetAdd".equals(type)) {
            ISheet sheet = (ISheet)event.getTarget();
            int index = event.getIndex();
            IGraphicalEditorPage page = this.createSheetPage(sheet, index);
            this.configurePage(page);
        } else if ("sheetRemove".equals(type)) {
            ISheet sheet = (ISheet)event.getTarget();
            IGraphicalEditorPage page = this.findPage(sheet);
            if (page != null) {
                this.removePage(page);
            }
        } else if ("sheetMove".equals(type)) {
            int oldIndex = event.getIndex();
            int newIndex = ((ISheet)event.getTarget()).getIndex();
            this.movePageTo(oldIndex, newIndex);
        } else if ("passwordChange".equals(type) && (workbook = this.getWorkbook()) instanceof ICoreEventSource2) {
            ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
        }
    }

    public boolean isDirty() {
        if (this.workbookRef == null) {
            return false;
        }
        IWorkbook workbook = this.getWorkbook();
        if (workbook instanceof ICoreEventSource2 && ((ICoreEventSource2)workbook).hasOnceListeners("workbookPreSaveOnce")) {
            return true;
        }
        return super.isDirty();
    }

    protected void saveAndRun(Command command) {
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            cs.execute(command);
        }
    }

    public void pageMoved(int fromIndex, int toIndex) {
        IWorkbook workbook = this.getWorkbook();
        MoveSheetCommand command = new MoveSheetCommand(workbook, fromIndex, toIndex);
        command.setLabel(CommandMessages.Command_MoveSheet);
        this.saveAndRun((Command)command);
    }

    public void pageTitleChanged(int pageIndex, String newValue) {
        Object pageInput;
        IGraphicalEditorPage page = this.getPage(pageIndex);
        if (page != null && (pageInput = page.getInput()) instanceof ISheet) {
            ModifyTitleTextCommand command = new ModifyTitleTextCommand((ITitled)((ISheet)pageInput), newValue);
            command.setLabel(CommandMessages.Command_ModifySheetTitle);
            this.saveAndRun((Command)command);
        }
    }

    protected void createSheet() {
        IAction action = this.getActionRegistry().getAction(MindMapActionFactory.NEW_SHEET.getId());
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public void setFocus() {
        if (this.isShowingBackCover()) {
            this.backCover.setFocus();
        } else {
            super.setFocus();
        }
    }

    public boolean isShowingBackCover() {
        return this.backCover != null && this.backCover.getControl() != null && !this.backCover.getControl().isDisposed();
    }

    private void ensureBackCover() {
        if (this.backCover == null) {
            this.backCover = new MindMapEditorBackCover();
        }
        if (this.backCover.getControl() == null || this.backCover.getControl().isDisposed()) {
            this.backCover.createControl(this.parent);
        }
        this.showPane(this.backCover.getControl());
        this.setFocus();
    }

    private void hideBackCover() {
        if (this.backCover != null) {
            if (this.backCover.getControl() != null) {
                this.backCover.getControl().dispose();
            }
            this.backCover = null;
        }
        this.showPane((Control)this.pageContainer);
        this.setFocus();
    }

    public void openEncryptionDialog() {
        this.ensureBackCover();
        if (!this.isShowingBackCover()) {
            return;
        }
        this.backCover.showEncryptionDialog();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.getSite().getSelectionProvider();
    }

    public void reveal() {
        this.getSite().getPage().activate((IWorkbenchPart)this);
        this.setFocus();
    }

    private class DecryptionDialogPane
    extends DialogPane {
        private Text messageBoard;
        private Text passwordInputBox;
        private Label iconLabel;

        private DecryptionDialogPane() {
        }

        protected Control createDialogContents(Composite parent) {
            Composite composite = (Composite)super.createDialogContents(parent);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            this.createMessageArea(composite);
            this.createPasswordInputBox(composite);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite buttonBar) {
            this.createOkButton(buttonBar);
            this.createCloseButton(buttonBar);
        }

        private void createOkButton(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        private void createCloseButton(Composite parent) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        private void createPasswordInputBox(Composite parent) {
            this.passwordInputBox = new Text(parent, 0x400804);
            this.applyFont((Control)this.passwordInputBox);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            this.passwordInputBox.setLayoutData((Object)gridData);
            this.hookText(this.passwordInputBox);
            this.addRefreshDefaultButtonListener((Control)this.passwordInputBox);
            this.addTriggerDefaultButtonListener((Control)this.passwordInputBox, 14);
        }

        private void createMessageArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setBackground(parent.getBackground());
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            area.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 10;
            area.setLayout((Layout)gridLayout);
            this.createIcon(area);
            this.createMessageBoard(area);
        }

        private void createIcon(Composite parent) {
            this.iconLabel = new Label(parent, 0);
            this.iconLabel.setBackground(parent.getBackground());
            this.iconLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Image image = this.getImage((Control)this.iconLabel, false);
            this.iconLabel.setImage(image);
        }

        private Image getImage(Control control, boolean errorOrWarning) {
            if (errorOrWarning) {
                return control.getDisplay().getSystemImage(1);
            }
            ImageDescriptor image = MindMapUI.getImages().get("unlock.gif", true);
            if (image != null) {
                return image.createImage((Device)control.getDisplay());
            }
            return null;
        }

        private void createMessageBoard(Composite parent) {
            this.messageBoard = new Text(parent, 74);
            this.messageBoard.setBackground(parent.getBackground());
            this.applyFont((Control)this.messageBoard);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            this.messageBoard.setLayoutData((Object)gridData);
        }

        protected boolean cancelPressed() {
            IWorkbenchPage page = MindMapEditor.this.getSite().getPage();
            page.closeEditor((IEditorPart)MindMapEditor.this, false);
            return true;
        }

        protected boolean okPressed() {
            if (MindMapEditor.this.loadWorkbookJob != null) {
                MindMapEditor.this.loadWorkbookJob.notifyPassword(this.passwordInputBox.getText());
            }
            return true;
        }

        public void dispose() {
            super.dispose();
            this.passwordInputBox = null;
            this.messageBoard = null;
        }

        public void setFocus() {
            if (this.passwordInputBox != null && !this.passwordInputBox.isDisposed()) {
                this.passwordInputBox.setFocus();
            }
        }

        public void setContent(String message, boolean errorOrWarning) {
            if (this.messageBoard != null && !this.messageBoard.isDisposed()) {
                this.messageBoard.setText(message);
            }
            if (this.iconLabel != null) {
                this.iconLabel.setImage(this.getImage((Control)this.iconLabel, errorOrWarning));
            }
            this.relayout();
        }

        protected void escapeKeyPressed() {
            this.triggerButton(12);
        }
    }

    private class EncryptionDailogPane
    extends DialogPane {
        private Text oldPasswordInputBox;
        private Text newPasswordInputBox;
        private Text verifyNewPasswordInputBox;
        private Label oldPasswordVerificationLabel;
        private Label newPasswordVerificationLabel;
        private Image doneIcon;
        private Image undoneIcon;
        private Image blankIcon;

        private EncryptionDailogPane() {
        }

        private Image getDoneIcon() {
            ImageDescriptor img;
            if (this.getContainer() == null || this.getContainer().isDisposed()) {
                return null;
            }
            if ((this.doneIcon == null || this.doneIcon.isDisposed()) && (img = MindMapUI.getImages().get("step_done.gif", true)) != null) {
                this.doneIcon = img.createImage((Device)this.getContainer().getDisplay());
            }
            return this.doneIcon;
        }

        private Image getUndoneIcon() {
            ImageDescriptor img;
            if (this.getContainer() == null || this.getContainer().isDisposed()) {
                return null;
            }
            if ((this.undoneIcon == null || this.undoneIcon.isDisposed()) && (img = MindMapUI.getImages().get("step_done.gif", false)) != null) {
                this.undoneIcon = img.createImage((Device)this.getContainer().getDisplay());
            }
            return this.undoneIcon;
        }

        private Image getBlankIcon() {
            ImageDescriptor img;
            if (this.getContainer() == null || this.getContainer().isDisposed()) {
                return null;
            }
            if ((this.blankIcon == null || this.blankIcon.isDisposed()) && (img = MindMapUI.getImages().get("icons/misc/blank.gif")) != null) {
                this.blankIcon = img.createImage((Device)this.getContainer().getDisplay());
            }
            return this.blankIcon;
        }

        public void dispose() {
            if (this.doneIcon != null) {
                this.doneIcon.dispose();
                this.doneIcon = null;
            }
            if (this.blankIcon != null) {
                this.blankIcon.dispose();
                this.blankIcon = null;
            }
            super.dispose();
        }

        protected Control createDialogContents(Composite parent) {
            Composite composite = (Composite)super.createDialogContents(parent);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            this.createMessageArea(composite);
            this.createPasswordArea(composite);
            this.verify();
            return composite;
        }

        private void createMessageArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setBackground(parent.getBackground());
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            area.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 10;
            area.setLayout((Layout)gridLayout);
            this.createMessageIcon(area);
            this.createMessageBoard(area);
        }

        private void createMessageIcon(Composite parent) {
            Label iconLabel = new Label(parent, 0);
            iconLabel.setBackground(parent.getBackground());
            iconLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Image image = this.getMessageIcon((Control)iconLabel);
            iconLabel.setImage(image);
        }

        private Image getMessageIcon(Control control) {
            if (control == null) {
                return null;
            }
            ImageDescriptor image = MindMapUI.getImages().get("lock.gif", true);
            if (image != null) {
                return image.createImage((Device)control.getDisplay());
            }
            return null;
        }

        private void createMessageBoard(Composite parent) {
            Text messageBoard = new Text(parent, 74);
            messageBoard.setBackground(parent.getBackground());
            this.applyFont((Control)messageBoard);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            messageBoard.setLayoutData((Object)gridData);
            messageBoard.setText(MindMapMessages.EncryptDialogPane_board_message);
        }

        private void createPasswordArea(Composite parent) {
            String oldPassword;
            Composite area = new Composite(parent, 0);
            area.setBackground(parent.getBackground());
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            area.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 3;
            area.setLayout((Layout)gridLayout);
            IWorkbook workbook = MindMapEditor.this.getWorkbook();
            if (workbook != null && (oldPassword = workbook.getPassword()) != null && !"".equals(oldPassword)) {
                this.createOldPasswordInputBox(area);
            }
            this.createNewPasswordInputBox(area);
            this.createVerifyPasswordInputBox(area);
            Listener verifyListener = new Listener(){

                public void handleEvent(Event event) {
                    EncryptionDailogPane.this.verify();
                }
            };
            if (this.oldPasswordInputBox != null) {
                this.oldPasswordInputBox.addListener(24, verifyListener);
            }
            this.newPasswordInputBox.addListener(24, verifyListener);
            this.verifyNewPasswordInputBox.addListener(24, verifyListener);
        }

        private void createOldPasswordInputBox(Composite parent) {
            Label assistMessageBox = new Label(parent, 64);
            assistMessageBox.setBackground(parent.getBackground());
            assistMessageBox.setLayoutData((Object)new GridData(4, 1, true, false));
            ((GridData)assistMessageBox.getLayoutData()).horizontalSpan = 3;
            assistMessageBox.setText(MindMapMessages.EncryptDialogPane_assist_message);
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(MindMapMessages.EncryptDialogPane_oldpassword_text);
            label.setBackground(parent.getBackground());
            this.applyFont((Control)label);
            this.oldPasswordInputBox = new Text(parent, 0x400804);
            this.applyFont((Control)this.oldPasswordInputBox);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            this.oldPasswordInputBox.setLayoutData((Object)gridData);
            this.hookText(this.oldPasswordInputBox);
            this.addRefreshDefaultButtonListener((Control)this.oldPasswordInputBox);
            this.addTriggerDefaultButtonListener((Control)this.oldPasswordInputBox, 14);
            this.oldPasswordVerificationLabel = new Label(parent, 0);
            this.oldPasswordVerificationLabel.setBackground(parent.getBackground());
            this.oldPasswordVerificationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            this.oldPasswordVerificationLabel.setImage(this.getDoneIcon());
            Label sep = new Label(parent, 0);
            sep.setBackground(parent.getBackground());
            sep.setLayoutData((Object)new GridData(4, 4, true, false));
            ((GridData)sep.getLayoutData()).horizontalSpan = 3;
        }

        private void createNewPasswordInputBox(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            String text = this.oldPasswordInputBox == null ? MindMapMessages.EncryptDialogPane_password_text : MindMapMessages.EncryptDialogPane_newpassword_text;
            label.setText(text);
            label.setBackground(parent.getBackground());
            this.applyFont((Control)label);
            this.newPasswordInputBox = new Text(parent, 0x400804);
            this.applyFont((Control)this.newPasswordInputBox);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            this.newPasswordInputBox.setLayoutData((Object)gridData);
            this.hookText(this.newPasswordInputBox);
            this.addRefreshDefaultButtonListener((Control)this.newPasswordInputBox);
            this.addTriggerDefaultButtonListener((Control)this.newPasswordInputBox, 14);
            Label blankIcon = new Label(parent, 0);
            blankIcon.setBackground(parent.getBackground());
            blankIcon.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            blankIcon.setImage(this.getBlankIcon());
        }

        private void createVerifyPasswordInputBox(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(MindMapMessages.EncryptDialogPane_confirm_text);
            label.setBackground(parent.getBackground());
            this.applyFont((Control)label);
            this.verifyNewPasswordInputBox = new Text(parent, 0x400804);
            this.applyFont((Control)this.verifyNewPasswordInputBox);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            this.verifyNewPasswordInputBox.setLayoutData((Object)gridData);
            this.hookText(this.verifyNewPasswordInputBox);
            this.addRefreshDefaultButtonListener((Control)this.verifyNewPasswordInputBox);
            this.addTriggerDefaultButtonListener((Control)this.verifyNewPasswordInputBox, 14);
            this.newPasswordVerificationLabel = new Label(parent, 0);
            this.newPasswordVerificationLabel.setBackground(parent.getBackground());
            this.newPasswordVerificationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            this.newPasswordVerificationLabel.setImage(this.getDoneIcon());
        }

        protected void createButtonsForButtonBar(Composite buttonBar) {
            this.createButton(buttonBar, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(buttonBar, 1, IDialogConstants.CANCEL_LABEL, false);
            this.setOKButtonEnabled(false);
        }

        private void setOKButtonEnabled(boolean enabled) {
            Button button = this.getButton(0);
            if (button != null && !button.isDisposed()) {
                button.setEnabled(enabled);
            }
        }

        private void verify() {
            boolean oldPasswordVerified = false;
            IWorkbook workbook = MindMapEditor.this.getWorkbook();
            if (workbook != null) {
                String oldPassword = workbook.getPassword();
                if (oldPassword == null || "".equals(oldPassword)) {
                    oldPasswordVerified = !"".equals(this.newPasswordInputBox.getText());
                } else if (this.oldPasswordInputBox != null) {
                    oldPasswordVerified = oldPassword != null && oldPassword.equals(this.oldPasswordInputBox.getText());
                    this.oldPasswordVerificationLabel.setImage(oldPasswordVerified ? this.getDoneIcon() : this.getUndoneIcon());
                }
            }
            boolean newPasswordVerified = (this.oldPasswordInputBox != null || !"".equals(this.newPasswordInputBox.getText())) && this.newPasswordInputBox.getText().equals(this.verifyNewPasswordInputBox.getText());
            this.newPasswordVerificationLabel.setImage(newPasswordVerified ? this.getDoneIcon() : this.getUndoneIcon());
            this.setOKButtonEnabled(oldPasswordVerified && newPasswordVerified);
        }

        protected boolean okPressed() {
            this.setPassword(this.newPasswordInputBox.getText());
            this.close();
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (MindMapEditor.this.parent == null || MindMapEditor.this.parent.isDisposed()) {
                        return;
                    }
                    MindMapEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            });
            return true;
        }

        private void setPassword(String password) {
            IWorkbook workbook;
            if ("".equals(password)) {
                password = null;
            }
            if ((workbook = MindMapEditor.this.getWorkbook()) != null) {
                workbook.setPassword(password);
            }
        }

        protected boolean cancelPressed() {
            this.close();
            return true;
        }

        private void close() {
            MindMapEditor.this.backCover.hideEncryptionDialog();
            MindMapEditor.this.hideBackCover();
        }

        public void setFocus() {
            if (this.oldPasswordInputBox != null && !this.oldPasswordInputBox.isDisposed()) {
                this.oldPasswordInputBox.setFocus();
            } else if (this.newPasswordInputBox != null && !this.newPasswordInputBox.isDisposed()) {
                this.newPasswordInputBox.setFocus();
            }
        }
    }

    private class ErrorDialogPane
    extends DialogPane {
        private Text summaryBoard;
        private Throwable error;
        private long time;
        private String title;

        private ErrorDialogPane() {
        }

        protected Control createDialogContents(Composite parent) {
            Composite composite = (Composite)super.createDialogContents(parent);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            this.createSummaryBoard(composite);
            return composite;
        }

        protected int getPreferredWidth() {
            return 500;
        }

        private void createSummaryBoard(Composite parent) {
            Composite box = new Composite(parent, 0);
            box.setBackground(parent.getBackground());
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            box.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 10;
            box.setLayout((Layout)gridLayout);
            this.createIcon(box);
            this.createSummaryBox(box);
        }

        private void createIcon(Composite parent) {
            Label iconLabel = new Label(parent, 0);
            iconLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
            iconLabel.setBackground(parent.getBackground());
            iconLabel.setImage(parent.getDisplay().getSystemImage(1));
        }

        private void createSummaryBox(Composite parent) {
            this.summaryBoard = new Text(parent, 74);
            this.summaryBoard.setBackground(parent.getBackground());
            this.applyFont((Control)this.summaryBoard);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            this.summaryBoard.setLayoutData((Object)gridData);
        }

        public void dispose() {
            super.dispose();
            this.summaryBoard = null;
        }

        public void setFocus() {
            if (this.summaryBoard != null && !this.summaryBoard.isDisposed()) {
                this.summaryBoard.setFocus();
            }
        }

        protected void createButtonsForButtonBar(Composite buttonBar) {
            this.createButton(buttonBar, 0, MindMapMessages.EncryptDialogPane_detailsButton_label, false);
            this.createButton(buttonBar, 12, IDialogConstants.CLOSE_LABEL, false);
            this.getButton(0).setEnabled(false);
        }

        protected boolean closePressed() {
            MindMapEditor.this.getSite().getPage().closeEditor((IEditorPart)MindMapEditor.this, false);
            return true;
        }

        protected boolean okPressed() {
            this.showDetails();
            return true;
        }

        private void showDetails() {
            if (this.error == null) {
                return;
            }
            new ErrorDetailsDialog(this.error, this.title, this.time).open();
        }

        public void setContent(Throwable error, String title, String message, long time) {
            this.error = error;
            this.time = time;
            this.title = title;
            Button detailsButton = this.getButton(0);
            if (detailsButton != null) {
                detailsButton.setEnabled(error != null);
            }
            if (this.summaryBoard != null) {
                this.summaryBoard.setText(NLS.bind((String)MindMapMessages.ErrorDialogPane_summaryBoard_text, (Object[])new Object[]{message, error.getClass().getName(), error.getLocalizedMessage()}));
            }
            this.relayout();
        }

        protected void escapeKeyPressed() {
            this.triggerButton(12);
        }
    }

    private class LoadWorkbookJob
    extends Job
    implements IEncryptionHandler {
        private String password;
        private Object passwordLock;
        private boolean firstTry;
        private boolean closed;
        private IProgressMonitor progress;

        public LoadWorkbookJob() {
            super(NLS.bind((String)MindMapMessages.LoadWorkbookJob_text, (Object)MindMapEditor.this.getEditorInput().getName()));
            this.password = null;
            this.passwordLock = null;
            this.firstTry = true;
            this.closed = false;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean wrongPassword;
            this.progress = monitor;
            monitor.beginTask(null, 100);
            if (MindMapEditor.this.workbookRef == null) {
                return Status.CANCEL_STATUS;
            }
            IStorage storage = MindMapEditor.this.workbookRef.createStorage();
            Throwable error = null;
            long errorTime = -1L;
            do {
                block10: {
                    wrongPassword = false;
                    this.password = null;
                    storage.clear();
                    if (MindMapEditor.this.workbookRef == null) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        MindMapEditor.this.workbookRef.loadWorkbook(storage, this, monitor);
                    }
                    catch (Throwable e) {
                        errorTime = System.currentTimeMillis();
                        if (e instanceof CoreException) {
                            CoreException coreEx = (CoreException)e;
                            int errType = coreEx.getType();
                            if (errType == 100) {
                                return Status.CANCEL_STATUS;
                            }
                            if (errType == 17) {
                                wrongPassword = true;
                            }
                        }
                        if (wrongPassword) break block10;
                        error = e;
                        Logger.log(e);
                    }
                }
                this.firstTry = false;
            } while (wrongPassword);
            if (MindMapEditor.this.getWorkbook() == null) {
                if (error != null) {
                    this.showErrorMessage(error, errorTime);
                }
                return Status.CANCEL_STATUS;
            }
            this.hideBackCover();
            MindMapEditor.this.showWorkbook();
            return Status.OK_STATUS;
        }

        private void showErrorMessage(final Throwable error, final long time) {
            MindMapEditor.this.parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MindMapEditor.this.parent == null || MindMapEditor.this.parent.isDisposed()) {
                        return;
                    }
                    MindMapEditor.this.ensureBackCover();
                    if (MindMapEditor.this.backCover == null || MindMapEditor.this.backCover.getControl() == null || MindMapEditor.this.backCover.getControl().isDisposed()) {
                        return;
                    }
                    MindMapEditor.this.backCover.showErrorDialog(error, MindMapMessages.LoadWorkbookJob_errorDialog_title, MindMapMessages.LoadWorkbookJob_errorDialog_message, time);
                }
            });
        }

        private void hideBackCover() {
            if (MindMapEditor.this.backCover != null) {
                MindMapEditor.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MindMapEditor.this.hideBackCover();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String retrievePassword() throws CoreException {
            if (this.password == null) {
                try {
                    this.showPasswordPage();
                }
                catch (Throwable e) {
                    throw new CoreException(100, e);
                }
                Object object = this.passwordLock = new Object();
                synchronized (object) {
                    while (this.password == null) {
                        try {
                            this.passwordLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        if (this.progress == null || !this.progress.isCanceled()) continue;
                        throw new CoreException(100);
                    }
                }
                this.passwordLock = null;
                this.hidePasswordPage();
            }
            return this.password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            if (this.passwordLock != null) {
                Object object = this.passwordLock;
                synchronized (object) {
                    this.passwordLock.notifyAll();
                }
            }
            if (!this.closed && !MindMapEditor.this.parent.isDisposed()) {
                MindMapEditor.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (MindMapEditor.this.parent == null || MindMapEditor.this.parent.isDisposed()) {
                            return;
                        }
                        MindMapEditor.this.getSite().getPage().closeEditor((IEditorPart)MindMapEditor.this, false);
                    }
                });
            }
        }

        private void showPasswordPage() {
            MindMapEditor.this.parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MindMapEditor.this.parent == null || MindMapEditor.this.parent.isDisposed()) {
                        return;
                    }
                    MindMapEditor.this.ensureBackCover();
                    if (MindMapEditor.this.backCover == null || MindMapEditor.this.backCover.getControl() == null || MindMapEditor.this.backCover.getControl().isDisposed()) {
                        return;
                    }
                    if (LoadWorkbookJob.this.progress != null) {
                        LoadWorkbookJob.this.progress.worked(10);
                        LoadWorkbookJob.this.progress.subTask(MindMapMessages.LoadWorkbookJob_retrive_password_message);
                    }
                    String message = LoadWorkbookJob.this.firstTry ? MindMapMessages.LoadWorkbookJob_firstTry_message : MindMapMessages.LoadWorkbookJob_moreTry_message;
                    MindMapEditor.this.backCover.showPasswordDialog(message, !LoadWorkbookJob.this.firstTry);
                }
            });
        }

        private void hidePasswordPage() {
            if (MindMapEditor.this.backCover != null) {
                MindMapEditor.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (MindMapEditor.this.backCover == null) {
                            return;
                        }
                        MindMapEditor.this.backCover.hidePasswordDialog();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPassword(String password) {
            this.password = password;
            if (this.passwordLock != null) {
                Object object = this.passwordLock;
                synchronized (object) {
                    this.passwordLock.notifyAll();
                }
            }
        }

        public void notifyEditorClose() {
            this.closed = true;
            this.cancel();
        }
    }

    private class MindMapEditorBackCover
    extends DialogPaneContainer {
        private Font bigFont;

        private MindMapEditorBackCover() {
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.createBigFont(parent.getDisplay());
        }

        private void createBigFont(Display display) {
            Font base = display.getSystemFont();
            FontData[] fontData = base.getFontData();
            int increment = "carbon".equals(SWT.getPlatform()) && System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null ? 3 : 1;
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() + increment);
                ++n2;
            }
            this.bigFont = new Font((Device)display, fontData);
        }

        protected void handleDispose() {
            if (this.bigFont != null) {
                this.bigFont.dispose();
                this.bigFont = null;
            }
            super.handleDispose();
        }

        protected void showDialog(DialogPane dialog) {
            if (dialog != null) {
                dialog.setDefaultFont(this.bigFont);
            }
            super.showDialog(dialog);
        }

        public void showPasswordDialog(String message, boolean errorOrWarning) {
            DecryptionDialogPane dialog = new DecryptionDialogPane();
            this.showDialog(dialog);
            dialog.setContent(message, errorOrWarning);
        }

        public void hidePasswordDialog() {
            if (this.getCurrentDialog() instanceof DecryptionDialogPane) {
                this.hideCurrentDialog();
            }
        }

        public void showErrorDialog(Throwable e, String title, String message, long time) {
            ErrorDialogPane dialog = new ErrorDialogPane();
            this.showDialog(dialog);
            dialog.setContent(e, title, message, time);
        }

        public void hideErrorDialog() {
            if (this.getCurrentDialog() instanceof ErrorDialogPane) {
                this.hideCurrentDialog();
            }
        }

        public void showEncryptionDialog() {
            EncryptionDailogPane dialog = new EncryptionDailogPane();
            this.showDialog(dialog);
        }

        public void hideEncryptionDialog() {
            if (this.getCurrentDialog() instanceof EncryptionDailogPane) {
                this.hideCurrentDialog();
            }
        }
    }

    private static class MindMapEditorPagePopupPreviewHelper
    extends GraphicalEditorPagePopupPreviewHelper {
        private static final int MIN_PREVIEW_WIDTH = 600;
        private static final int MIN_PREVIEW_HEIGHT = 600;

        public MindMapEditorPagePopupPreviewHelper(IGraphicalEditor editor, CTabFolder tabFolder) {
            super(editor, tabFolder);
        }

        protected Rectangle calcContentsBounds(IFigure contents, IGraphicalViewer viewer) {
            int newHeight;
            Rectangle bounds = super.calcContentsBounds(contents, viewer);
            int max = Math.max(bounds.width, bounds.height) + 50;
            int newWidth = bounds.width;
            if (newWidth < 600) {
                newWidth = 600;
            }
            if (newWidth < max) {
                newWidth = max;
            }
            if (newWidth != bounds.width) {
                int ex = (newWidth - bounds.width) / 2;
                Rectangle b = contents.getBounds();
                int right = bounds.x + bounds.width;
                bounds.x = Math.max(b.x, bounds.x - ex);
                bounds.width = Math.min(b.x + b.width, right + ex) - bounds.x;
            }
            if ((newHeight = bounds.height) < 600) {
                newHeight = 600;
            }
            if (newHeight < max) {
                newHeight = max;
            }
            if (newHeight != bounds.height) {
                int ex = (newHeight - bounds.height) / 2;
                Rectangle b = contents.getBounds();
                int bottom = bounds.y + bounds.height;
                bounds.y = Math.max(b.y, bounds.y - ex);
                bounds.height = Math.min(b.y + b.height, bottom + ex) - bounds.y;
            }
            return bounds;
        }
    }

    private class MindMapEditorSelectionProvider
    extends MultiGraphicalPageSelectionProvider {
        private MindMapEditorSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
            ISheet sheet;
            if (selection instanceof IStructuredSelection && (sheet = this.findSheet(((IStructuredSelection)selection).toArray())) != null) {
                MindMapEditor.this.ensurePageVisible(sheet);
            }
            super.setSelection(selection);
        }

        private ISheet findSheet(Object[] array) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ISheet sheet = MindMapUtils.findSheet(o);
                if (sheet != null) {
                    return sheet;
                }
                ++n2;
            }
            return null;
        }

        public void fireSelectionChanged() {
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }
}

