/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.xmind.core.INamed;
import org.xmind.core.ITitled;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.ui.editor.GraphicalEditorActionBarContributor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.DelegatingAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.IActionBuilder;
import org.xmind.ui.internal.ImageActionExtensionManager;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.actions.AddMarkerHandler;
import org.xmind.ui.internal.actions.AlignmentAction;
import org.xmind.ui.internal.actions.AllMarkersMenu;
import org.xmind.ui.internal.actions.AllowOverlapsAction;
import org.xmind.ui.internal.actions.DropDownInsertImageAction;
import org.xmind.ui.internal.actions.FindReplaceAction;
import org.xmind.ui.internal.actions.GroupMarkers;
import org.xmind.ui.internal.actions.MindMapViewsMenu;
import org.xmind.ui.internal.actions.RenameSheetAction;
import org.xmind.ui.internal.actions.SaveSheetAsAction;
import org.xmind.ui.internal.actions.StructureMenu;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class MindMapContributor
extends GraphicalEditorActionBarContributor
implements ISelectionListener {
    private ISelectionService selectionService;
    private ActionFactory.IWorkbenchAction selectBrothersAction;
    private ActionFactory.IWorkbenchAction selectChildrenAction;
    private ActionFactory.IWorkbenchAction goHomeAction;
    private ActionFactory.IWorkbenchAction zoomInAction;
    private ActionFactory.IWorkbenchAction zoomOutAction;
    private ActionFactory.IWorkbenchAction actualSizeAction;
    private ActionFactory.IWorkbenchAction drillDownAction;
    private ActionFactory.IWorkbenchAction drillUpAction;
    private ActionFactory.IWorkbenchAction insertTopicAction;
    private ActionFactory.IWorkbenchAction insertSubtopicAction;
    private ActionFactory.IWorkbenchAction insertTopicBeforeAction;
    private ActionFactory.IWorkbenchAction insertParentTopicAction;
    private ActionFactory.IWorkbenchAction insertFloatingTopicAction;
    private ActionFactory.IWorkbenchAction insertFloatingCentralTopicAction;
    private ActionFactory.IWorkbenchAction insertSheetAction;
    private ActionFactory.IWorkbenchAction extendAction;
    private ActionFactory.IWorkbenchAction collapseAction;
    private ActionFactory.IWorkbenchAction extendAllAction;
    private ActionFactory.IWorkbenchAction collapseAllAction;
    private ActionFactory.IWorkbenchAction modifyHyperlinkAction;
    private ActionFactory.IWorkbenchAction openHyperlinkAction;
    private ActionFactory.IWorkbenchAction cancelHyperlinkAction;
    private ActionFactory.IWorkbenchAction saveAttachmentAsAction;
    private ActionFactory.IWorkbenchAction insertAttachmentAction;
    private ActionFactory.IWorkbenchAction insertImageAction;
    private MenuManager alignmentGroup;
    private Contributor popupAlignGroup;
    private Map<Integer, AlignmentAction> alignmentActions;
    private ActionFactory.IWorkbenchAction newSheetAction;
    private ActionFactory.IWorkbenchAction deleteSheetAction;
    private ActionFactory.IWorkbenchAction allowOverlapsAction;
    private ActionFactory.IWorkbenchAction tileAction;
    private ActionFactory.IWorkbenchAction resetPositionAction;
    private ActionFactory.IWorkbenchAction createSummaryAction;
    private ActionFactory.IWorkbenchAction createRelationshipAction;
    private ActionFactory.IWorkbenchAction createBoundaryAction;
    private ActionFactory.IWorkbenchAction editTitleAction;
    private ActionFactory.IWorkbenchAction popupEditAction;
    private ActionFactory.IWorkbenchAction editLabelAction;
    private ActionFactory.IWorkbenchAction editNotesAction;
    private ActionFactory.IWorkbenchAction traverseAction;
    private ActionFactory.IWorkbenchAction finishAction;
    private ActionFactory.IWorkbenchAction findReplaceAction;
    private AllMarkersMenu allMarkersMenu;
    private AllMarkersMenu popupAllMarkersMenu;
    private StructureMenu structureMenu;
    private GroupMarkers groupMarkers;
    private SaveSheetAsAction saveSheetAsAction;
    private RenameSheetAction renameSheetAction;
    private ActionFactory.IWorkbenchAction saveAsTemplateAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private List<ActionFactory.IWorkbenchAction> imageActionExtensions;
    private DropDownInsertImageAction dropDownInsertImageAction;
    private IHandlerService handlerService;
    private Map<IAction, IHandlerActivation> actionHandlerActivations;
    private AddMarkerHandler addMarkerHandler;
    private ContentPopupContributor contentPopupContributor;

    public void init(IActionBars bars, IWorkbenchPage page) {
        this.handlerService = (IHandlerService)page.getWorkbenchWindow().getService(IHandlerService.class);
        this.actionHandlerActivations = this.handlerService != null ? new HashMap<IAction, IHandlerActivation>(33) : null;
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener((ISelectionListener)this);
        }
        this.selectionService = page.getWorkbenchWindow().getSelectionService();
        this.selectionService.addSelectionListener((ISelectionListener)this);
        super.init(bars, page);
    }

    protected void declareGlobalActionIds() {
        this.addGlobalActionId(ActionFactory.UNDO.getId());
        this.addGlobalActionId(ActionFactory.REDO.getId());
        this.addGlobalActionId(ActionFactory.SELECT_ALL.getId());
        this.addGlobalActionId(ActionFactory.PRINT.getId());
    }

    protected void makeActions() {
        IWorkbenchWindow window = this.getPage().getWorkbenchWindow();
        this.selectBrothersAction = MindMapActionFactory.SELECT_BROTHERS.create(window);
        this.addRetargetAction((RetargetAction)this.selectBrothersAction);
        this.selectChildrenAction = MindMapActionFactory.SELECT_CHILDREN.create(window);
        this.addRetargetAction((RetargetAction)this.selectChildrenAction);
        this.goHomeAction = MindMapActionFactory.GO_HOME.create(window);
        this.addRetargetAction((RetargetAction)this.goHomeAction);
        this.zoomInAction = MindMapActionFactory.ZOOM_IN.create(window);
        this.addRetargetAction((RetargetAction)this.zoomInAction);
        this.zoomOutAction = MindMapActionFactory.ZOOM_OUT.create(window);
        this.addRetargetAction((RetargetAction)this.zoomOutAction);
        this.actualSizeAction = MindMapActionFactory.ACTUAL_SIZE.create(window);
        this.addRetargetAction((RetargetAction)this.actualSizeAction);
        this.drillDownAction = MindMapActionFactory.DRILL_DOWN.create(window);
        this.addRetargetAction((RetargetAction)this.drillDownAction);
        this.drillUpAction = MindMapActionFactory.DRILL_UP.create(window);
        this.addRetargetAction((RetargetAction)this.drillUpAction);
        this.insertSheetAction = MindMapActionFactory.INSERT_SHEET_FROM.create(window);
        this.addRetargetAction((RetargetAction)this.insertSheetAction);
        this.insertTopicAction = MindMapActionFactory.INSERT_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertTopicAction);
        this.insertSubtopicAction = MindMapActionFactory.INSERT_SUBTOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertSubtopicAction);
        this.insertTopicBeforeAction = MindMapActionFactory.INSERT_TOPIC_BEFORE.create(window);
        this.addRetargetAction((RetargetAction)this.insertTopicBeforeAction);
        this.insertParentTopicAction = MindMapActionFactory.INSERT_PARENT_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertParentTopicAction);
        this.insertFloatingTopicAction = MindMapActionFactory.INSERT_FLOATING_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertFloatingTopicAction);
        this.insertFloatingCentralTopicAction = MindMapActionFactory.INSERT_FLOATING_CENTRAL_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertFloatingCentralTopicAction);
        this.extendAction = MindMapActionFactory.EXTEND.create(window);
        this.addRetargetAction((RetargetAction)this.extendAction);
        this.collapseAction = MindMapActionFactory.COLLAPSE.create(window);
        this.addRetargetAction((RetargetAction)this.collapseAction);
        this.extendAllAction = MindMapActionFactory.EXTEND_ALL.create(window);
        this.addRetargetAction((RetargetAction)this.extendAllAction);
        this.collapseAllAction = MindMapActionFactory.COLLAPSE_ALL.create(window);
        this.addRetargetAction((RetargetAction)this.collapseAllAction);
        this.modifyHyperlinkAction = MindMapActionFactory.MODIFY_HYPERLINK.create(window);
        this.addRetargetAction((RetargetAction)this.modifyHyperlinkAction);
        this.openHyperlinkAction = MindMapActionFactory.OPEN_HYPERLINK.create(window);
        this.addRetargetAction((RetargetAction)this.openHyperlinkAction);
        this.cancelHyperlinkAction = MindMapActionFactory.CANCEL_HYPERLINK.create(window);
        this.addRetargetAction((RetargetAction)this.cancelHyperlinkAction);
        this.saveAttachmentAsAction = MindMapActionFactory.SAVE_ATTACHMENT_AS.create(window);
        this.addRetargetAction((RetargetAction)this.saveAttachmentAsAction);
        this.insertAttachmentAction = MindMapActionFactory.INSERT_ATTACHMENT.create(window);
        this.addRetargetAction((RetargetAction)this.insertAttachmentAction);
        this.insertImageAction = MindMapActionFactory.INSERT_IMAGE.create(window);
        this.addRetargetAction((RetargetAction)this.insertImageAction);
        this.newSheetAction = MindMapActionFactory.NEW_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.newSheetAction);
        this.deleteSheetAction = MindMapActionFactory.DELETE_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.deleteSheetAction);
        this.createRelationshipAction = MindMapActionFactory.CREATE_RELATIONSHIP.create(window);
        this.addRetargetAction((RetargetAction)this.createRelationshipAction);
        this.createBoundaryAction = MindMapActionFactory.CREATE_BOUNDARY.create(window);
        this.addRetargetAction((RetargetAction)this.createBoundaryAction);
        this.createSummaryAction = MindMapActionFactory.CREATE_SUMMARY.create(window);
        this.addRetargetAction((RetargetAction)this.createSummaryAction);
        this.editTitleAction = MindMapActionFactory.EDIT_TITLE.create(window);
        this.addRetargetAction((RetargetAction)this.editTitleAction);
        this.popupEditAction = new DelegatingAction((IAction)this.editTitleAction, "enabled", "checked", "image");
        this.popupEditAction.setId("org.xmind.ui.edit.popup");
        this.popupEditAction.setText(MindMapMessages.Edit_text);
        this.popupEditAction.setToolTipText(MindMapMessages.Edit_toolTip);
        this.editLabelAction = MindMapActionFactory.EDIT_LABEL.create(window);
        this.addRetargetAction((RetargetAction)this.editLabelAction);
        this.editNotesAction = MindMapActionFactory.EDIT_NOTES.create(window);
        this.addRetargetAction((RetargetAction)this.editNotesAction);
        this.traverseAction = MindMapActionFactory.TRAVERSE.create(window);
        this.addRetargetAction((RetargetAction)this.traverseAction);
        this.finishAction = MindMapActionFactory.FINISH.create(window);
        this.addRetargetAction((RetargetAction)this.finishAction);
        IPreferenceStore prefStore = MindMapUIPlugin.getDefault().getPreferenceStore();
        this.allowOverlapsAction = new AllowOverlapsAction(prefStore);
        this.addAction((IAction)this.allowOverlapsAction);
        this.tileAction = MindMapActionFactory.TILE.create(window);
        this.addRetargetAction((RetargetAction)this.tileAction);
        this.resetPositionAction = MindMapActionFactory.RESET_POSITION.create(window);
        this.addRetargetAction((RetargetAction)this.resetPositionAction);
        if (this.handlerService != null) {
            this.addMarkerHandler = new AddMarkerHandler();
            this.addMarkerHandler.activate(this.handlerService);
        }
        this.findReplaceAction = new FindReplaceAction(window);
        this.addAction((IAction)this.findReplaceAction);
        this.structureMenu = new StructureMenu();
        this.saveSheetAsAction = new SaveSheetAsAction();
        this.renameSheetAction = new RenameSheetAction();
        this.groupMarkers = new GroupMarkers();
        this.saveAsTemplateAction = MindMapActionFactory.SAVE_TEMPLATE.create(window);
        this.addAction((IAction)this.saveAsTemplateAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.addRetargetAction((RetargetAction)this.deleteAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.addRetargetAction((RetargetAction)this.copyAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.addRetargetAction((RetargetAction)this.cutAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.addRetargetAction((RetargetAction)this.pasteAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.addRetargetAction((RetargetAction)this.propertiesAction);
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_UP.create(window));
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_DOWN.create(window));
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_LEFT.create(window));
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_RIGHT.create(window));
        this.contentPopupContributor = new ContentPopupContributor();
        List<IActionBuilder> imageChooserActionBuilders = ImageActionExtensionManager.getInstance().getActionBuilders();
        this.imageActionExtensions = new ArrayList<ActionFactory.IWorkbenchAction>(imageChooserActionBuilders.size());
        for (IActionBuilder builder : imageChooserActionBuilders) {
            ActionFactory.IWorkbenchAction imageChooserAction = builder.createAction(this.getPage());
            this.imageActionExtensions.add(imageChooserAction);
            this.addAction((IAction)imageChooserAction);
        }
        if (this.imageActionExtensions.size() > 0) {
            this.imageActionExtensions.add(0, this.insertImageAction);
            this.dropDownInsertImageAction = new DropDownInsertImageAction((IAction)this.imageActionExtensions.get(0), this.imageActionExtensions);
        }
    }

    public void init(IActionBars bars) {
        super.init(bars);
        bars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findReplaceAction);
    }

    protected void addAction(IAction action) {
        super.addAction(action);
        this.activateHandler(action);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        boolean useMindMapOrView;
        IContributionItem selectAllItem;
        super.contributeToMenu(menuManager);
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null && (selectAllItem = editMenu.find(ActionFactory.SELECT_ALL.getId())) != null) {
            editMenu.insertBefore(selectAllItem.getId(), (IAction)this.goHomeAction);
            editMenu.insertAfter(selectAllItem.getId(), (IAction)this.selectChildrenAction);
            editMenu.insertAfter(selectAllItem.getId(), (IAction)this.selectBrothersAction);
        }
        IMenuManager viewMenu = this.createMenu("org.xmind.ui.view", (useMindMapOrView = this.hasExistingShowViewMenu(menuManager)) ? MindMapMessages.MindMapMenu : MindMapMessages.ViewMenu);
        this.addViewActions(viewMenu, useMindMapOrView);
        IMenuManager insertMenu = this.createMenu("org.xmind.ui.insert", MindMapMessages.InsertMenu);
        this.addInsertActions(insertMenu);
        IMenuManager modifyMenu = this.createMenu("org.xmind.ui.modify", MindMapMessages.ModifyMenu);
        this.addModifyActions(modifyMenu);
        IMenuManager toolsMenu = this.createMenu("org.xmind.ui.tools", MindMapMessages.ToolsMenu);
        this.addToolsActions(toolsMenu);
        IMenuManager fileMenu = menuManager.findMenuUsingPath("file");
        if (fileMenu != null) {
            this.insertSaveContributions(fileMenu);
        }
        if (menuManager.find("additions") != null) {
            menuManager.prependToGroup("additions", (IContributionItem)toolsMenu);
            menuManager.prependToGroup("additions", (IContributionItem)modifyMenu);
            menuManager.prependToGroup("additions", (IContributionItem)insertMenu);
            menuManager.prependToGroup("additions", (IContributionItem)viewMenu);
        } else {
            menuManager.add((IContributionItem)viewMenu);
            menuManager.add((IContributionItem)insertMenu);
            menuManager.add((IContributionItem)modifyMenu);
            menuManager.add((IContributionItem)toolsMenu);
        }
    }

    private void insertSaveContributions(IMenuManager menu) {
        IContributionItem saveItem = menu.find(ActionFactory.SAVE.getId());
        if (saveItem != null) {
            IContributionItem lastItem = null;
            IContributionItem[] iContributionItemArray = menu.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (lastItem != null) {
                    if (item.isSeparator() || item.getId() == null) {
                        String id = lastItem.getId();
                        menu.insertAfter(id, (IAction)this.saveAsTemplateAction);
                        menu.insertAfter(id, (IAction)this.saveSheetAsAction);
                        return;
                    }
                    lastItem = item;
                } else if (item == saveItem) {
                    lastItem = item;
                }
                ++n2;
            }
            if (lastItem != null) {
                String id = lastItem.getId();
                menu.insertAfter(id, (IAction)this.saveAsTemplateAction);
                menu.insertAfter(id, (IAction)this.saveSheetAsAction);
            }
        }
        if (menu.find("save.ext") != null) {
            menu.prependToGroup("save.ext", (IAction)this.saveAsTemplateAction);
            menu.prependToGroup("save.ext", (IAction)this.saveSheetAsAction);
        } else {
            menu.prependToGroup("additions", (IAction)this.saveAsTemplateAction);
            menu.prependToGroup("additions", (IAction)this.saveSheetAsAction);
        }
    }

    private boolean hasExistingShowViewMenu(IMenuManager menuManager) {
        return menuManager.findUsingPath("window/showView") != null;
    }

    private IMenuManager createMenu(String menuId, String menuName) {
        return new MenuManager(menuName, menuId);
    }

    private void addViewActions(IMenuManager menu, boolean useMindMapOrView) {
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.viewStart"));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.presentation"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.actualSizeAction);
        menu.add((IAction)this.zoomOutAction);
        menu.add((IAction)this.zoomInAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.drillUpAction);
        menu.add((IAction)this.drillDownAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.filter"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.createViewList(useMindMapOrView));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.viewEnd"));
    }

    private IContributionItem createViewList(boolean mindMapOrSystem) {
        if (mindMapOrSystem) {
            return new MindMapViewsMenu(this.getPage().getWorkbenchWindow());
        }
        return ContributionItemFactory.VIEWS_SHORTLIST.create(this.getPage().getWorkbenchWindow());
    }

    private void addInsertActions(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insertStart"));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.insertTopic"));
        menu.add((IAction)this.insertTopicAction);
        menu.add((IAction)this.insertSubtopicAction);
        menu.add((IAction)this.insertTopicBeforeAction);
        menu.add((IAction)this.insertParentTopicAction);
        menu.add((IAction)this.insertFloatingTopicAction);
        menu.add((IAction)this.insertFloatingCentralTopicAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insertTopic.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.insert"));
        menu.add((IContributionItem)this.getAllMarkersMenu());
        if (this.dropDownInsertImageAction != null) {
            menu.add((IAction)this.dropDownInsertImageAction);
        } else {
            menu.add((IAction)this.insertImageAction);
        }
        menu.add((IAction)this.createRelationshipAction);
        menu.add((IAction)this.createBoundaryAction);
        menu.add((IAction)this.createSummaryAction);
        menu.add((IAction)this.insertAttachmentAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insert.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.sheet"));
        menu.add((IAction)this.newSheetAction);
        menu.add((IAction)this.insertSheetAction);
        menu.add((IAction)this.deleteSheetAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.sheet.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insertEnd"));
    }

    private void addModifyActions(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.modifyStart"));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.topic.edit"));
        menu.add((IAction)this.editTitleAction);
        menu.add((IAction)this.editLabelAction);
        menu.add((IAction)this.editNotesAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.topic.edit.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.hyperlink"));
        menu.add((IAction)this.modifyHyperlinkAction);
        menu.add((IAction)this.cancelHyperlinkAction);
        menu.add((IAction)this.openHyperlinkAction);
        menu.add((IAction)this.saveAttachmentAsAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.hyperlink.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.extend"));
        menu.add((IAction)this.extendAction);
        menu.add((IAction)this.collapseAction);
        menu.add((IAction)this.extendAllAction);
        menu.add((IAction)this.collapseAllAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.extend.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.position"));
        menu.add((IAction)this.allowOverlapsAction);
        menu.add((IAction)this.tileAction);
        menu.add((IAction)this.resetPositionAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)this.getAlignmentGroup());
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.position.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.modifyEnd"));
    }

    private void addToolsActions(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.toolsStart"));
        menu.add((IContributionItem)new GroupMarker("additions1"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions2"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions3"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions4"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions5"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions6"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions7"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions8"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions9"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions10"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.toolsEnd"));
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.group.presentation"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.group.sheet"));
        toolBarManager.add((IAction)this.newSheetAction);
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.sheet.ext"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.group.insertTopic"));
        toolBarManager.add((IAction)this.insertTopicAction);
        toolBarManager.add((IAction)this.insertSubtopicAction);
        toolBarManager.add((IAction)this.insertTopicBeforeAction);
        toolBarManager.add((IAction)this.insertParentTopicAction);
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.insertTopic.ext"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.group.insert"));
        toolBarManager.add((IAction)this.insertAttachmentAction);
        if (this.dropDownInsertImageAction != null) {
            toolBarManager.add((IAction)this.dropDownInsertImageAction);
        } else {
            toolBarManager.add((IAction)this.insertImageAction);
        }
        toolBarManager.add((IAction)this.editLabelAction);
        toolBarManager.add((IAction)this.editNotesAction);
        toolBarManager.add((IAction)this.modifyHyperlinkAction);
        toolBarManager.add((IAction)this.createBoundaryAction);
        toolBarManager.add((IAction)this.createSummaryAction);
        toolBarManager.add((IAction)this.createRelationshipAction);
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.insert.ext"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.group.drillDown"));
        toolBarManager.add((IAction)this.drillDownAction);
        toolBarManager.add((IAction)this.drillUpAction);
        toolBarManager.add((IContributionItem)new GroupMarker("org.xmind.ui.drillDown.ext"));
    }

    private MenuManager getAllMarkersMenu() {
        if (this.allMarkersMenu == null) {
            this.allMarkersMenu = new AllMarkersMenu();
        }
        return this.allMarkersMenu;
    }

    private MenuManager getPopupAllMarkersMenu() {
        if (this.popupAllMarkersMenu == null) {
            this.popupAllMarkersMenu = new AllMarkersMenu();
        }
        return this.popupAllMarkersMenu;
    }

    private MenuManager getAlignmentGroup() {
        if (this.alignmentGroup == null) {
            this.alignmentGroup = this.makeAlignmentGroup();
        }
        return this.alignmentGroup;
    }

    private Contributor getPopupAlignmentGroup() {
        if (this.popupAlignGroup == null) {
            this.popupAlignGroup = this.makeAlignmentGroup2();
        }
        return this.popupAlignGroup;
    }

    private MenuManager makeAlignmentGroup() {
        MenuManager menu = new MenuManager(MindMapMessages.AlignmentMenu, "org.xmind.ui.alignment");
        this.buildAlignmentGroup(menu);
        return menu;
    }

    private Contributor makeAlignmentGroup2() {
        Contributor group = new Contributor("org.xmind.ui.alignment", MindMapMessages.AlignmentMenu);
        this.buildAlignmentGroup(group);
        return group;
    }

    private void buildAlignmentGroup(Object manager) {
        this.addContribution(manager, new GroupMarker("org.xmind.ui.alignment.start"));
        this.addAlignmentAction(manager, 1);
        this.addAlignmentAction(manager, 2);
        this.addAlignmentAction(manager, 4);
        this.addContribution(manager, new Separator());
        this.addAlignmentAction(manager, 8);
        this.addAlignmentAction(manager, 16);
        this.addAlignmentAction(manager, 32);
        this.addContribution(manager, new Separator("additions"));
        this.addContribution(manager, new GroupMarker("org.xmind.ui.alignment.end"));
    }

    private Contributor createPopupInsertMenu() {
        Contributor popupInsertMenu = new Contributor("org.xmind.ui.insert", MindMapMessages.InsertMenu);
        this.fillPopupInsertMenu(popupInsertMenu);
        return popupInsertMenu;
    }

    private void fillPopupInsertMenu(Contributor menu) {
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insertStart"));
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.insertTopic"));
        menu.add((IAction)this.insertTopicAction);
        menu.add((IAction)this.insertSubtopicAction);
        menu.add((IAction)this.insertTopicBeforeAction);
        menu.add((IAction)this.insertParentTopicAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insertTopic.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.group.insert"));
        menu.add((IAction)this.insertImageAction);
        menu.add((IAction)this.createRelationshipAction);
        menu.add((IAction)this.createBoundaryAction);
        menu.add((IAction)this.createSummaryAction);
        menu.add((IAction)this.insertAttachmentAction);
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insert.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("org.xmind.ui.insertEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.insertSheetAction);
    }

    private void addContribution(Object manager, Object item) {
        if (manager instanceof IContributionManager) {
            if (item instanceof IAction) {
                ((IContributionManager)manager).add((IAction)item);
            } else if (item instanceof IContributionItem) {
                ((IContributionManager)manager).add((IContributionItem)item);
            }
        } else if (manager instanceof Contributor) {
            ((Contributor)manager).addItem(item);
        }
    }

    private void addAlignmentAction(Object menu, int alignment) {
        AlignmentAction action = this.createAlignmentAction(alignment);
        if (menu instanceof IMenuManager) {
            ((IMenuManager)menu).add((IAction)action);
        } else if (menu instanceof Contributor) {
            ((Contributor)menu).add((IAction)action);
        }
        this.addRetargetAction(action);
    }

    private AlignmentAction createAlignmentAction(int alignment) {
        AlignmentAction action;
        if (this.alignmentActions != null && (action = this.alignmentActions.get(alignment)) != null) {
            return action;
        }
        action = new AlignmentAction(alignment);
        if (this.alignmentActions == null) {
            this.alignmentActions = new HashMap<Integer, AlignmentAction>();
        }
        this.alignmentActions.put(alignment, action);
        return action;
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (this.groupMarkers != null) {
            if (targetEditor == null) {
                this.groupMarkers.setSelectionProvider(null);
            } else {
                this.groupMarkers.setSelectionProvider(targetEditor.getSite().getSelectionProvider());
            }
        }
        super.setActiveEditor(targetEditor);
    }

    protected void activePageChanged(IGraphicalEditorPage page) {
        if (this.addMarkerHandler != null) {
            this.addMarkerHandler.setActivatePage(page);
        }
        if (this.getAllMarkersMenu() != null) {
            this.allMarkersMenu.setActivePage(page);
        }
        if (this.getPopupAllMarkersMenu() != null) {
            this.popupAllMarkersMenu.setActivePage(page);
        }
        if (this.structureMenu != null) {
            this.structureMenu.setActivePage(page);
        }
        if (this.saveSheetAsAction != null) {
            this.saveSheetAsAction.setActivePage(page);
        }
        if (this.renameSheetAction != null) {
            this.renameSheetAction.setActivePage(page);
        }
    }

    protected void activateHandler(IAction action) {
        String commandId;
        if (this.handlerService != null && this.actionHandlerActivations != null && (commandId = action.getActionDefinitionId()) != null) {
            IHandlerActivation handlerActivation = this.handlerService.activateHandler(commandId, (IHandler)new ActionHandler(action));
            this.actionHandlerActivations.put(action, handlerActivation);
        }
    }

    protected void deactivateHandler(IAction action) {
        IHandlerActivation activation;
        if (this.handlerService != null && this.actionHandlerActivations != null && (activation = this.actionHandlerActivations.remove(action)) != null) {
            this.handlerService.deactivateHandler(activation);
        }
    }

    public void contributeToContentPopupMenu(IMenuManager menu) {
        if (this.contentPopupContributor != null) {
            this.contentPopupContributor.applyTo(menu);
        }
    }

    public void contributeToPagePopupMenu(IMenuManager menu) {
        menu.add((IAction)this.renameSheetAction);
        menu.add((IAction)this.saveSheetAsAction);
        menu.add((IAction)this.deleteSheetAction);
        super.contributeToPagePopupMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.propertiesAction);
    }

    public void dispose() {
        if (this.popupEditAction != null) {
            this.popupEditAction.dispose();
            this.popupEditAction = null;
        }
        if (this.alignmentGroup != null) {
            this.alignmentGroup.dispose();
            this.alignmentGroup = null;
        }
        this.popupAlignGroup = null;
        this.alignmentActions = null;
        if (this.allMarkersMenu != null) {
            this.allMarkersMenu.dispose();
            this.allMarkersMenu = null;
        }
        if (this.popupAllMarkersMenu != null) {
            this.popupAllMarkersMenu.dispose();
            this.popupAllMarkersMenu = null;
        }
        if (this.structureMenu != null) {
            this.structureMenu.dispose();
            this.structureMenu = null;
        }
        if (this.groupMarkers != null) {
            this.groupMarkers.dispose();
            this.groupMarkers = null;
        }
        if (this.handlerService != null) {
            if (this.addMarkerHandler != null) {
                this.addMarkerHandler.deactivate(this.handlerService);
                this.addMarkerHandler.dispose();
                this.addMarkerHandler = null;
            }
            if (this.getActionRegistry() != null) {
                for (IAction action : this.getActionRegistry().getActions()) {
                    this.deactivateHandler(action);
                }
            }
            this.handlerService = null;
            this.actionHandlerActivations = null;
        }
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener((ISelectionListener)this);
            this.selectionService = null;
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ICategoryManager manager = MindMapUI.getCategoryManager();
        Object[] elements = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
        ICategoryAnalyzation categories = elements == null ? null : manager.analyze(elements);
        this.updateStatusLine(manager, categories);
        this.updateContentPopupItems(manager, categories);
    }

    private void updateStatusLine(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
        IStatusLineManager sl = this.getActionBars().getStatusLineManager();
        if (sl != null) {
            sl.setMessage(MindMapContributor.getStatusMessage(categoryManager, categories));
        }
    }

    private static String getStatusMessage(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
        String m;
        if (categories == null) {
            return null;
        }
        if (categories.isEmpty()) {
            return null;
        }
        int size = categories.getElements().length;
        if (categories.isMultiple()) {
            m = MindMapMessages.StatusLine_MultipleItems;
        } else {
            String type = categories.getMainCategory();
            if ("unknown category".equals(type)) {
                m = "";
            } else {
                Object ele;
                String title;
                String name = categoryManager.getCategoryName(type);
                m = size == 1 ? ((title = MindMapUtils.trimSingleLine(MindMapContributor.getTitle(ele = categories.getElements()[0]))) != null ? NLS.bind((String)MindMapMessages.StatusLine_OneItemPattern, (Object)name, (Object)title) : NLS.bind((String)MindMapMessages.StatusLine_OneItemNoTitlePattern, (Object)name)) : NLS.bind((String)MindMapMessages.StatusLine_MultipleItemPattern, (Object)size, (Object)name);
            }
        }
        return m;
    }

    private static String getTitle(Object ele) {
        if (ele instanceof ITitled) {
            return ((ITitled)ele).getTitleText();
        }
        if (ele instanceof INamed) {
            return ((INamed)ele).getName();
        }
        if (ele instanceof IMarkerRef) {
            return ((IMarkerRef)ele).getDescription();
        }
        return null;
    }

    private void updateContentPopupItems(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
        if (this.contentPopupContributor != null) {
            this.contentPopupContributor.build(categoryManager, categories);
        }
    }

    private class ContentPopupContributor
    extends Contributor {
        public ContentPopupContributor() {
            super(null);
        }

        void build(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
            this.clear();
            if (categories == null) {
                return;
            }
            String category = categories.getMainCategory();
            if ("org.xmind.ui.topic".equals(category)) {
                if (categories.size() > 1) {
                    this.buildMultipleTopicsPopupActions();
                } else {
                    this.buildSingleTopicPopupActions();
                }
            } else if ("org.xmind.ui.sheet".equals(category)) {
                this.buildSheetPopupActions();
            } else if ("org.xmind.ui.boundary".equals(category)) {
                this.buildBoundaryPopupActions();
            } else if ("org.xmind.ui.relationship".equals(category)) {
                this.buildRelationshipPopupActions();
            } else if ("org.xmind.ui.marker".equals(category)) {
                this.buildMarkerPopupActions(categories);
            } else if ("org.xmind.ui.image".equals(category)) {
                this.buildImagePopupActions();
            }
        }

        private void buildSingleTopicPopupActions() {
            this.add(MindMapContributor.this.createPopupInsertMenu());
            this.add((IContributionItem)MindMapContributor.this.structureMenu);
            this.add((IContributionItem)MindMapContributor.this.getPopupAllMarkersMenu());
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.cutAction);
            this.add((IAction)MindMapContributor.this.copyAction);
            this.add((IAction)MindMapContributor.this.pasteAction);
            this.add((IAction)MindMapContributor.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.popupEditAction);
            this.add((IAction)MindMapContributor.this.editLabelAction);
            this.add((IAction)MindMapContributor.this.editNotesAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.modifyHyperlinkAction);
            this.add((IAction)MindMapContributor.this.cancelHyperlinkAction);
            this.add((IAction)MindMapContributor.this.openHyperlinkAction);
            this.add((IAction)MindMapContributor.this.saveAttachmentAsAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.extendAllAction);
            this.add((IAction)MindMapContributor.this.collapseAllAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.drillDownAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.resetPositionAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }

        private void buildMultipleTopicsPopupActions() {
            this.add((IAction)MindMapContributor.this.createBoundaryAction);
            this.add((IAction)MindMapContributor.this.createSummaryAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)MindMapContributor.this.structureMenu);
            this.add((IContributionItem)MindMapContributor.this.getPopupAllMarkersMenu());
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.cutAction);
            this.add((IAction)MindMapContributor.this.copyAction);
            this.add((IAction)MindMapContributor.this.pasteAction);
            this.add((IAction)MindMapContributor.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.extendAllAction);
            this.add((IAction)MindMapContributor.this.collapseAllAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.resetPositionAction);
            this.add((IContributionItem)new Separator());
            this.add(MindMapContributor.this.getPopupAlignmentGroup());
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }

        private void buildSheetPopupActions() {
            this.add((IAction)MindMapContributor.this.insertFloatingTopicAction);
            this.add((IAction)MindMapContributor.this.insertFloatingCentralTopicAction);
            this.add((IAction)MindMapContributor.this.createRelationshipAction);
            this.add((IAction)MindMapContributor.this.createBoundaryAction);
            this.add((IAction)MindMapContributor.this.createSummaryAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.pasteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.extendAllAction);
            this.add((IAction)MindMapContributor.this.collapseAllAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.drillUpAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.allowOverlapsAction);
            this.add((IAction)MindMapContributor.this.tileAction);
            this.add((IAction)MindMapContributor.this.resetPositionAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }

        private void buildBoundaryPopupActions() {
            this.add((IAction)MindMapContributor.this.popupEditAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.cutAction);
            this.add((IAction)MindMapContributor.this.copyAction);
            this.add((IAction)MindMapContributor.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.createRelationshipAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }

        private void buildRelationshipPopupActions() {
            this.add((IAction)MindMapContributor.this.popupEditAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.insertTopicAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.resetPositionAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }

        private void buildMarkerPopupActions(ICategoryAnalyzation categories) {
            this.add((IAction)MindMapContributor.this.cutAction);
            this.add((IAction)MindMapContributor.this.copyAction);
            this.add((IAction)MindMapContributor.this.deleteAction);
            this.add((IContributionItem)new Separator());
            MindMapContributor.this.groupMarkers.setSourceMarkerRef((IMarkerRef)categories.getElements()[0]);
            this.add((IContributionItem)MindMapContributor.this.groupMarkers);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }

        private void buildImagePopupActions() {
            this.add((IAction)MindMapContributor.this.cutAction);
            this.add((IAction)MindMapContributor.this.copyAction);
            this.add((IAction)MindMapContributor.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new Separator("org.xmind.ui.additions"));
            this.add((IContributionItem)new Separator());
            this.add((IAction)MindMapContributor.this.propertiesAction);
        }
    }

    private static class Contributor {
        private String id;
        private String name;
        private ImageDescriptor icon;
        private List<Object> items;

        public Contributor(String id) {
            this(id, null, null);
        }

        public Contributor(String id, String name) {
            this(id, name, null);
        }

        public Contributor(String id, String name, ImageDescriptor icon) {
            this.id = id;
            this.name = name;
            this.icon = icon;
        }

        public ImageDescriptor getIcon() {
            return this.icon;
        }

        public void setIcon(ImageDescriptor icon) {
            this.icon = icon;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void add(IAction action) {
            this.addItem(action);
        }

        public void add(IContributionItem item) {
            this.addItem(item);
        }

        public void add(Contributor subContributor) {
            this.addItem(subContributor);
        }

        public void clear() {
            this.items = null;
        }

        protected void addItem(Object item) {
            if (this.items == null) {
                this.items = new ArrayList<Object>();
            }
            this.items.add(item);
        }

        public void applyTo(IMenuManager manager) {
            if (this.items == null) {
                return;
            }
            for (Object item : this.items) {
                if (item instanceof IAction) {
                    manager.add((IAction)item);
                    continue;
                }
                if (item instanceof IContributionItem) {
                    manager.add((IContributionItem)item);
                    continue;
                }
                if (!(item instanceof Contributor)) continue;
                Contributor subContributor = (Contributor)item;
                MenuManager subManager = new MenuManager(subContributor.getName(), subContributor.getIcon(), subContributor.getId());
                subContributor.applyTo((IMenuManager)subManager);
                manager.add((IContributionItem)subManager);
            }
        }
    }
}

