/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.osgi.framework.Bundle;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.editor.FileEditorInput;
import org.xmind.ui.internal.editor.WorkbookEditorInput;

public class MME {
    private static Bundle ideBundle = null;
    private static boolean noIDE = false;

    public static IEditorInput createNonExistingEditorInput() {
        return new WorkbookEditorInput();
    }

    public static IEditorInput createNamedEditorInput(String name) {
        return new WorkbookEditorInput(name);
    }

    public static IEditorInput createTemplatedEditorInput(InputStream templateStream) {
        return new WorkbookEditorInput(null, templateStream);
    }

    public static IEditorInput createTemplatedEditorInput(String name, InputStream templateStream) {
        return new WorkbookEditorInput(name, templateStream);
    }

    public static IEditorInput createLoadedEditorInput(IWorkbook workbook) {
        return new WorkbookEditorInput(workbook);
    }

    public static IEditorInput createLoadedEditorInput(String name, IWorkbook workbook) {
        return new WorkbookEditorInput(name, workbook);
    }

    public static IEditorInput createFileEditorInput(String path) throws CoreException {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return MME.createFileEditorInput(new File(path));
    }

    public static IEditorInput createFileEditorInput(File file) throws CoreException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        Bundle ide = MME.getIDE();
        if (ide != null) {
            IFileStore fileStore = EFS.getStore((URI)file.toURI());
            return MME.createFileEditorInput(ide, fileStore);
        }
        return new FileEditorInput(file);
    }

    public static IEditorInput createFileEditorInput(IFileStore fileStore) throws CoreException {
        if (fileStore == null) {
            throw new IllegalArgumentException("File store is null");
        }
        Bundle ide = MME.getIDE();
        if (ide != null) {
            return MME.createFileEditorInput(ide, fileStore);
        }
        throw new IllegalStateException("Can't create editor input using IFileStore when no Eclipse IDE plugin is resolved.");
    }

    private static IEditorInput createFileEditorInput(Bundle ide, IFileStore fileStore) throws CoreException {
        if (fileStore == null) {
            throw new IllegalArgumentException("File store is null");
        }
        try {
            Class clazz = ide.loadClass("org.eclipse.ui.ide.FileStoreEditorInput");
            Constructor c = clazz.getConstructor(IFileStore.class);
            return (IEditorInput)c.newInstance(fileStore);
        }
        catch (Throwable throwable) {
            Status status = new Status(4, "org.xmind.ui.mindmap", "Unable to create FileStoreEditorInput.");
            throw new CoreException((IStatus)status);
        }
    }

    public static IEditorInput createFileEditorInput(IFile file) throws CoreException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        Bundle ide = MME.getIDE();
        if (ide != null) {
            return MME.createFileEditorInput(ide, file);
        }
        throw new IllegalStateException("Can't create editor input using IFile when no Eclipse IDE plugin is resolved.");
    }

    private static IEditorInput createFileEditorInput(Bundle ide, IFile file) throws CoreException {
        try {
            Class clazz = ide.loadClass("org.eclipse.ui.part.FileEditorInput");
            Constructor c = clazz.getConstructor(IFile.class);
            Object input = c.newInstance(file);
            return (IEditorInput)input;
        }
        catch (Throwable throwable) {
            Status status = new Status(4, "org.xmind.ui.mindmap", NLS.bind((String)"Failed to create IDE's FileEditorInput: {0}", (Object)file.getFullPath()));
            throw new CoreException((IStatus)status);
        }
    }

    public static File getFile(Object input) {
        IFileStore fileStore = MME.getFileStore(input);
        if (fileStore != null) {
            try {
                return fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static IFileStore getFileStore(Object input) {
        File file;
        IFileStore fileStore = (IFileStore)MME.getAdapter(input, IFileStore.class);
        if (fileStore == null && (file = (File)MME.getAdapter(input, File.class)) != null) {
            try {
                fileStore = EFS.getStore((URI)file.toURI());
            }
            catch (CoreException coreException) {}
        }
        if (fileStore == null) {
            fileStore = MME.forceFileStore(input);
        }
        return fileStore;
    }

    static Object getAdapter(Object adaptable, Class adapterType) {
        if (adaptable instanceof IAdaptable) {
            return ((IAdaptable)adaptable).getAdapter(adapterType);
        }
        return Platform.getAdapterManager().getAdapter(adaptable, adapterType);
    }

    private static IFileStore forceFileStore(Object adaptable) {
        if (!MME.isInplementation(adaptable, "org.eclipse.ui.IURIEditorInput")) {
            return null;
        }
        Class<?> clazz = adaptable.getClass();
        try {
            Method method = clazz.getMethod("getURI", new Class[0]);
            Object result = method.invoke(adaptable, new Object[0]);
            if (result instanceof URI) {
                return EFS.getStore((URI)((URI)result));
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static boolean isInplementation(Object obj, String interfaceName) {
        Class[] interfaces = obj.getClass().getInterfaces();
        return MME.hasInterface(interfaces, interfaceName);
    }

    private static boolean hasInterface(Class[] interfaces, String interfaceName) {
        if (interfaces.length == 0) {
            return false;
        }
        Class[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (MME.isClass(c, interfaceName)) {
                return true;
            }
            if (MME.hasInterface(c.getInterfaces(), interfaceName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isClass(Class c, String className) {
        return className.equals(c.getName());
    }

    private static Bundle getIDE() {
        if (ideBundle == null && !noIDE) {
            ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
            noIDE = ideBundle == null;
        }
        return ideBundle;
    }
}

