/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.ui.internal.editor.MindMapEditor;

public class EditorInputMonitor
implements ShellListener,
IPropertyListener {
    private Shell shell;
    private MindMapEditor editor;
    private Boolean lastExisting = null;

    public EditorInputMonitor(MindMapEditor editor) {
        this.editor = editor;
        this.shell = editor.getSite().getShell();
        if (this.shell != null) {
            this.shell.addShellListener((ShellListener)this);
        }
    }

    public void dispose() {
        if (this.shell != null) {
            this.shell.removeShellListener((ShellListener)this);
            this.shell = null;
        }
    }

    private void checkFiles() {
        if (this.lastExisting == null) {
            this.recordLastExisting();
        } else {
            IEditorInput input = this.editor.getEditorInput();
            if (input != null && input.exists() != this.lastExisting.booleanValue()) {
                this.addDirtyMarker();
            }
        }
    }

    private void addDirtyMarker() {
        IWorkbook workbook = (IWorkbook)this.editor.getAdapter(IWorkbook.class);
        if (workbook instanceof ICoreEventSource2) {
            ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
        }
    }

    private void recordLastExisting() {
        IEditorInput input = this.editor.getEditorInput();
        this.lastExisting = input == null ? false : input.exists();
    }

    public void shellActivated(ShellEvent e) {
        this.checkFiles();
    }

    public void shellClosed(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
        this.recordLastExisting();
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.recordLastExisting();
        }
    }
}

