/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.xmind.core.Core;
import org.xmind.core.ICloneData;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;

public class MindMapElementTransfer
extends ByteArrayTransfer {
    private static final MindMapElementTransfer instance = new MindMapElementTransfer();
    private static final String TYPE_NAME = "mindmap-element-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPE_ID = MindMapElementTransfer.registerType((String)TYPE_NAME);
    private Object[] elements = null;
    private IWorkbook tempWorkbook = null;

    private MindMapElementTransfer() {
    }

    public static MindMapElementTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof Object[])) {
            this.setElements(null);
            return;
        }
        this.setElements((Object[])object);
        if (this.getElements() == null) {
            return;
        }
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object object = super.nativeToJava(transferData);
        return object == null ? null : this.elements;
    }

    boolean checkType(Object object) {
        if (!(object instanceof Object[])) {
            return false;
        }
        Object[] eles = (Object[])object;
        return eles.length > 0;
    }

    protected boolean validate(Object object) {
        return this.checkType(object);
    }

    public void setElements(Object[] elements) {
        this.elements = this.recreateElements(elements);
    }

    public Object[] getElements() {
        return this.elements;
    }

    private Object[] recreateElements(Object[] elements) {
        this.tempWorkbook = this.recreateTempWorkbook();
        if (elements == null || elements.length == 0) {
            return null;
        }
        ICloneData result = this.tempWorkbook.clone((Collection)Arrays.asList(elements));
        Collection cloneds = result.getCloneds();
        if (!cloneds.isEmpty()) {
            return cloneds.toArray();
        }
        return null;
    }

    private IWorkbook recreateTempWorkbook() {
        String tempDir = Core.getWorkspace().getAbsolutePath("temp");
        File file = new File(tempDir, "transfer.xmind.temp");
        FileUtils.delete((File)file);
        IWorkbook wb = Core.getWorkbookBuilder().createWorkbook();
        wb.setTempLocation(file.getAbsolutePath());
        try {
            wb.saveTemp();
        }
        catch (Exception exception) {}
        return wb;
    }
}

