/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.PageBook;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.dialogs.HyperlinkPage;
import org.xmind.ui.dialogs.IHyperlinkPage;
import org.xmind.ui.dialogs.IHyperlinkPageContainer;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GalleryPartFactory;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.ShadowedLayer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.HyperlinkPageDescriptor;
import org.xmind.ui.internal.dialogs.HyperlinkPageRegistry;
import org.xmind.ui.mindmap.IProtocolDescriptor;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkDialog2
extends TitleAreaDialog
implements IHyperlinkPageContainer {
    public static final int REMOVE = 3;
    private static final int REMOVE_ID = 1025;
    private static final String KEY_SASH_WEIGHTS = "sashFormWeights";
    private String value;
    private IStructuredSelection selection;
    private Map<String, IHyperlinkPage> pages = new HashMap<String, IHyperlinkPage>();
    private IHyperlinkPage currentPage;
    private String pageMessage;
    private int pageMessageType = 0;
    private String pageDescription;
    private PageBook pageBook;
    private GalleryViewer typeViewer;
    private SashForm form;

    public HyperlinkDialog2(Shell s) {
        super(s);
    }

    public HyperlinkDialog2(Shell parentShell, IStructuredSelection selection) {
        super(parentShell);
        this.selection = selection;
        this.setShellStyle(67696);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.HyperlinkDialog");
    }

    public void create() {
        super.create();
        this.setTitle(DialogMessages.HyperlinkDialog_title);
        this.pageDescription = DialogMessages.HyperlinkDialog_description;
        this.setMessage(this.pageDescription);
        this.showInitContents();
        this.updateButtons();
        this.updateMessage();
    }

    private void showInitContents() {
        List<HyperlinkPageDescriptor> descriptors = HyperlinkPageRegistry.getInstance().getHyperlinkPageDescriptors();
        if (!descriptors.isEmpty()) {
            this.value = this.getHyperlinkValue(this.selection);
            HyperlinkPageDescriptor initDescriptor = null;
            if (this.value != null && !"".equals(this.value)) {
                initDescriptor = this.findInitDescriptor(descriptors, this.value);
            }
            if (initDescriptor == null) {
                initDescriptor = descriptors.get(0);
            }
            this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)initDescriptor), false);
            if (this.currentPage != null) {
                this.currentPage.setValue(this.value);
                this.currentPage.setFocus();
            }
        }
    }

    private String getHyperlinkValue(IStructuredSelection selection) {
        ITopicPart last = null;
        String lastHyperlink = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object topic = objectArray[n2];
            if (topic instanceof ITopicPart) {
                String h = ((ITopicPart)topic).getTopic().getHyperlink();
                if (last != null) {
                    if (!(h == lastHyperlink || h != null && h.equals(lastHyperlink))) {
                        return null;
                    }
                } else {
                    last = (ITopicPart)topic;
                    lastHyperlink = h;
                }
            }
            ++n2;
        }
        return lastHyperlink;
    }

    private HyperlinkPageDescriptor findInitDescriptor(List<HyperlinkPageDescriptor> descriptors, String value) {
        IProtocolDescriptor protocolDescriptor = MindMapUI.getProtocolManager().findProtocolDescriptor(value);
        if (protocolDescriptor != null) {
            String id = protocolDescriptor.getId();
            for (HyperlinkPageDescriptor pageDescriptor : descriptors) {
                if (!id.equals(pageDescriptor.getProtocolId())) continue;
                return pageDescriptor;
            }
        }
        return null;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DialogMessages.HyperlinkDialog_windowTitle);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                HyperlinkDialog2.this.handleDispose(e);
            }
        });
    }

    private void handleDispose(DisposeEvent e) {
        this.disposePages();
    }

    private void disposePages() {
        if (!this.pages.isEmpty()) {
            for (IHyperlinkPage page : this.pages.values()) {
                page.dispose();
            }
            this.pages.clear();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.form = new SashForm(composite, 65792);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.form.getLayoutData()).widthHint = 400;
        ((GridData)this.form.getLayoutData()).heightHint = 300;
        this.form.setBackground(parent.getDisplay().getSystemColor(25));
        this.form.setSashWidth(4);
        this.createTypeViewer((Composite)this.form);
        this.createPageBook((Composite)this.form);
        int[] weights = this.loadSashFormWeights();
        if (weights != null) {
            this.form.setWeights(weights);
        } else {
            this.form.setWeights(new int[]{25, 75});
        }
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    private void createPageBook(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 514);
        label.setLayoutData((Object)new GridData(1, 4, false, true));
        this.pageBook = new PageBook(composite, 0);
        this.pageBook.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createTypeViewer(Composite parent) {
        this.typeViewer = new GalleryViewer();
        Properties properties = this.typeViewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)4);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 0, 1, new Insets(1)));
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("selection constraint", (Object)2);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        editDomain.setViewer((IViewer)this.typeViewer);
        this.typeViewer.setPartFactory((IPartFactory)new TypePartFactory());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new TypeViewerLableProvider());
        this.typeViewer.createControl(parent);
        this.typeViewer.setInput(HyperlinkPageRegistry.getInstance().getHyperlinkPageDescriptors());
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                HyperlinkPageDescriptor desc = (HyperlinkPageDescriptor)selection.getFirstElement();
                HyperlinkDialog2.this.showPage(desc);
            }
        });
    }

    public IHyperlinkPage getCurrentPage() {
        return this.currentPage;
    }

    protected void showPage(HyperlinkPageDescriptor desc) {
        String id = desc.getId();
        IHyperlinkPage page = this.pages.get(id);
        if (page == null) {
            page = this.createPage(desc);
            page.init(this.selection);
            page.setContainer(this);
            this.pages.put(id, page);
        }
        this.showPage(page, desc);
    }

    private IHyperlinkPage createPage(HyperlinkPageDescriptor desc) {
        try {
            return desc.createPage();
        }
        catch (CoreException e) {
            Logger.log(e);
            return new NullHyperlinkPage();
        }
    }

    private void showPage(IHyperlinkPage page, HyperlinkPageDescriptor descriptor) {
        Control control = this.getPageControl(page, descriptor);
        this.pageBook.showPage(control);
        this.currentPage = page;
        this.updateButtons();
        this.updateMessage();
    }

    private Control getPageControl(IHyperlinkPage page, HyperlinkPageDescriptor descriptor) {
        Control control = page.getControl();
        if (control == null) {
            page.createControl((Composite)this.pageBook);
            control = page.getControl();
            Assert.isNotNull((Object)control);
        }
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, DialogMessages.HyperlinkDialog_Remove, false);
        super.createButtonsForButtonBar(parent);
    }

    public boolean close() {
        if (this.form != null && !this.form.isDisposed()) {
            this.saveSashFormWeights(this.form);
        }
        return super.close();
    }

    private void saveSashFormWeights(SashForm form) {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings == null) {
            return;
        }
        int[] weights = form.getWeights();
        if (weights == null || weights.length != 2) {
            return;
        }
        settings.put(KEY_SASH_WEIGHTS, String.format("%d,%d", weights[0], weights[1]));
    }

    private int[] loadSashFormWeights() {
        int w2;
        int w1;
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings == null) {
            return null;
        }
        String value = settings.get(KEY_SASH_WEIGHTS);
        if (value == null) {
            return null;
        }
        int index = value.indexOf(44);
        if (index < 0) {
            return null;
        }
        try {
            w1 = Integer.parseInt(value.substring(0, index));
            w2 = Integer.parseInt(value.substring(index + 1));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new int[]{w1, w2};
    }

    @Override
    public void updateButtons() {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(this.isOkButtonEnabled());
        }
    }

    private boolean isOkButtonEnabled() {
        if (this.currentPage == null) {
            return false;
        }
        return this.currentPage.canFinish();
    }

    @Override
    public void updateMessage() {
        if (this.currentPage == null) {
            return;
        }
        this.pageMessage = this.currentPage.getMessage();
        this.pageMessageType = this.pageMessage != null ? this.currentPage.getMessageType() : 0;
        if (this.pageMessage == null) {
            this.setMessage(this.pageDescription);
        } else {
            this.setMessage(this.pageMessage, this.pageMessageType);
        }
        this.setErrorMessage(this.currentPage.getErrorMessage());
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.removePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void removePressed() {
        this.setReturnCode(3);
        this.close();
    }

    protected void okPressed() {
        if (this.currentPage != null) {
            this.value = this.currentPage.getValue();
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public String getValue() {
        return this.value;
    }

    private static class NullHyperlinkPage
    extends HyperlinkPage {
        private Label label;

        private NullHyperlinkPage() {
        }

        public void init(IStructuredSelection selection) {
        }

        public void createControl(Composite parent) {
            this.label = new Label(parent, 0);
            this.label.setText(DialogMessages.HyperlinkDialog2_FailCreatePage_message);
        }

        public void dispose() {
        }

        public Control getControl() {
            return this.label;
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setFocus();
            }
        }
    }

    private static class TypeItemPart
    extends FramePart {
        public TypeItemPart(Object model) {
            super(model);
        }

        protected IFigure createFigure() {
            IFigure fig = super.createFigure();
            FrameFigure ff = (FrameFigure)fig;
            ShadowedLayer content = ff.getContentPane();
            content.setBackgroundColor(null);
            content.setForegroundColor(null);
            content.setShadowVisible(false);
            content.setShadowAlpha(0);
            content.setBorderWidth(0);
            content.setOpaque(false);
            return fig;
        }
    }

    private static class TypePartFactory
    extends GalleryPartFactory {
        private TypePartFactory() {
        }

        public IPart createPart(IPart context, Object model) {
            return super.createPart(context, model);
        }

        protected IPart createFramePart(IPart parent, Object model) {
            return new TypeItemPart(model);
        }
    }

    private class TypeViewerLableProvider
    extends ImageCachedLabelProvider
    implements IFontProvider {
        private TypeViewerLableProvider() {
        }

        public String getText(Object element) {
            if (element instanceof HyperlinkPageDescriptor) {
                return ((HyperlinkPageDescriptor)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            ImageDescriptor icon;
            if (element instanceof HyperlinkPageDescriptor && (icon = ((HyperlinkPageDescriptor)element).getIcon()) != null) {
                return icon.createImage(false);
            }
            return null;
        }

        public Font getFont(Object element) {
            return FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2);
        }
    }
}

