/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.io.File;
import java.net.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.dialogs.HyperlinkPage;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.protocols.FileProtocol;

public class FileHyperlinkPage
extends HyperlinkPage
implements Listener {
    private Composite composite;
    private Text pathInput;
    private Button fileChooser;
    private Button folderChooser;
    private boolean isModifyingValue = false;

    public void init(IStructuredSelection selection) {
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(this.composite);
        this.createPathInput(this.composite);
        this.createPathChoosers(this.composite);
    }

    private void createLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)label.getLayoutData()).widthHint = 380;
        label.setText(DialogMessages.FileHyperlinkPage_label);
    }

    private void createPathInput(Composite parent) {
        this.pathInput = new Text(this.composite, 2052);
        this.pathInput.setLayoutData((Object)new GridData(4, 4, true, false));
        this.pathInput.addListener(24, (Listener)this);
    }

    private void createPathChoosers(Composite parent) {
        Control c;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createFileChooser(composite);
        this.createFolderChooser(composite);
        int maxWidth = 98;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            if (c instanceof Button) {
                maxWidth = Math.max(maxWidth, c.computeSize((int)-1, (int)-1).x);
            }
            ++n2;
        }
        controlArray = composite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            if (c instanceof Button && c.getLayoutData() instanceof GridData) {
                ((GridData)c.getLayoutData()).widthHint = maxWidth;
            }
            ++n2;
        }
    }

    private void createFileChooser(Composite parent) {
        this.fileChooser = new Button(parent, 8);
        this.fileChooser.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fileChooser.setText(DialogMessages.FileHyperlinkPage_ChooseFile_text);
        this.fileChooser.addListener(13, (Listener)this);
    }

    private void createFolderChooser(Composite parent) {
        this.folderChooser = new Button(parent, 8);
        this.folderChooser.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.folderChooser.setText(DialogMessages.FileHyperlinkPage_ChooseFolder_text);
        this.folderChooser.addListener(13, (Listener)this);
    }

    private String toFileURL() {
        File file = new File(this.pathInput.getText());
        URI uri = file.toURI();
        return uri.toString();
    }

    public void setValue(String value) {
        super.setValue(value);
        if (!this.isModifyingValue && this.pathInput != null && !this.pathInput.isDisposed()) {
            if (value == null) {
                this.pathInput.setText("");
            } else {
                this.pathInput.setText(this.toFilePath(value));
            }
        }
    }

    private String toFilePath(String url) {
        return FileProtocol.toFilePath(url);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        if (this.pathInput != null && !this.pathInput.isDisposed()) {
            this.pathInput.setFocus();
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.pathInput) {
            this.isModifyingValue = true;
            this.setValue(this.toFileURL());
            this.isModifyingValue = false;
            boolean exists = new File(this.pathInput.getText()).exists();
            this.setCanFinish(exists);
            this.setErrorMessage(exists ? null : DialogMessages.FileHyperlinkPage_FileNotExists_message);
        } else if (event.widget == this.fileChooser) {
            FileDialog fd = new FileDialog(this.composite.getShell(), 4100);
            fd.setText(DialogMessages.FileHyperlinkPage_OpenFileDialog_windowTitle);
            String path = fd.open();
            if (path != null) {
                this.pathInput.setText(path);
                this.pathInput.setFocus();
            }
        } else if (event.widget == this.folderChooser) {
            DirectoryDialog dd = new DirectoryDialog(this.composite.getShell(), 4100);
            dd.setText(DialogMessages.FileHyperlinkPage_OpenDirectoryDialog_windowTitle);
            String path = dd.open();
            if (path != null) {
                this.pathInput.setText(path);
                this.pathInput.setFocus();
            }
        }
    }
}

