/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.core.ISummary;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.mindmap.IAnimatablePart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class BranchDecorator
extends Decorator {
    private static final BranchDecorator instanceo = new BranchDecorator();

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        if (part instanceof IBranchPart && figure instanceof BranchFigure) {
            IBranchPart branch = (IBranchPart)part;
            BranchFigure branchFigure = (BranchFigure)figure;
            branchFigure.setConnections((IDecoration)branch.getConnections());
        }
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        if (figure instanceof BranchFigure) {
            BranchFigure branchFigure = (BranchFigure)figure;
            boolean animating = false;
            if (part instanceof IAnimatablePart) {
                animating = ((IAnimatablePart)part).isFigureAnimating();
            }
            if (part instanceof IBranchPart) {
                IFigure parentFigure;
                IBranchPart branch = (IBranchPart)part;
                branchFigure.setFolded(this.isBranchFolded(branch));
                IBranchPart parent = branch.getParentBranch();
                if (parent != null && (parentFigure = parent.getFigure()) instanceof BranchFigure) {
                    BranchFigure parentBranchFigure = (BranchFigure)parentFigure;
                    branchFigure.setMinimized(parentBranchFigure.isFolded() || parentBranchFigure.isMinimized() || this.isUnusedSummaryBranch(branch));
                    if (!animating) {
                        branchFigure.setVisible(!parentBranchFigure.isFolded() && parentBranchFigure.isVisible());
                    }
                }
            }
            this.decorateBranchDecoration(part, StyleUtils.getStyleSelector(part), branchFigure, animating);
        }
    }

    private boolean isUnusedSummaryBranch(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && parent.getSummaryBranches().contains(branch)) {
            String topicId = branch.getTopic().getId();
            for (ISummary s : parent.getTopic().getSummaries()) {
                if (!topicId.equals(s.getTopicId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void decorateBranchDecoration(IGraphicalPart part, IStyleSelector ss, BranchFigure branchFigure, boolean animating) {
        String newDescId;
        IDecoration decoration = branchFigure.getDecoration();
        if (!StyleUtils.isSameDecoration(decoration, newDescId = StyleUtils.getString(part, ss, "branch-decoration-class", "org.xmind.branchDecoration.default"))) {
            decoration = StyleUtils.createBranchDecoration(part, newDescId);
            branchFigure.setDecoration(decoration);
        }
        if (decoration != null) {
            decoration.setAlpha((IFigure)branchFigure, 255);
            if (!animating) {
                decoration.setVisible((IFigure)branchFigure, branchFigure.isVisible());
            }
        }
    }

    private boolean isBranchFolded(IBranchPart branch) {
        if (!branch.isPropertyModifiable("topicFolded")) {
            return false;
        }
        Object cache = MindMapUtils.getCache((IPart)branch, "org.xmind.ui.cache.folded");
        if (cache != null) {
            return Boolean.TRUE.equals(cache);
        }
        return branch.getTopic().isFolded();
    }

    public void decorateChildren(IGraphicalPart part, IFigure figure) {
        super.decorateChildren(part, figure);
        if (figure instanceof BranchFigure) {
            BranchFigure branchFigure = (BranchFigure)figure;
            if (part instanceof IBranchPart) {
                IBranchPart branch = (IBranchPart)part;
                boolean animating = branch instanceof IAnimatablePart && ((IAnimatablePart)((Object)branch)).isFigureAnimating();
                IStyleSelector ss = StyleUtils.getStyleSelector(part);
                this.decorateConnections(branch, ss, branchFigure, branch.getConnections(), animating);
            }
        }
    }

    private void decorateConnections(IBranchPart branch, IStyleSelector ss, BranchFigure figure, IBranchConnections connections, boolean ignoreVisibility) {
        String newConnectionId = StyleUtils.getString(branch, ss, "line-class", "org.xmind.branchConnection.straight");
        connections.setId(newConnectionId);
        IAnchor sourceAnchor = null;
        ITopicPart topic = branch.getTopicPart();
        if (topic instanceof INodePart) {
            sourceAnchor = ((INodePart)((Object)topic)).getSourceAnchor(branch);
        }
        connections.setSourceAnchor((IFigure)figure, sourceAnchor);
        connections.setAlpha((IFigure)figure, 255);
        connections.setLineColor((IFigure)figure, StyleUtils.getColor(branch, ss, "line-color", newConnectionId, "#808080"));
        connections.setLineStyle((IFigure)figure, StyleUtils.getLineStyle(branch, ss, newConnectionId, 1));
        connections.setLineWidth((IFigure)figure, StyleUtils.getInteger(branch, ss, "line-width", newConnectionId, 1));
        int sourceOrientation = 0;
        IStructure structure = branch.getBranchPolicy().getStructure(branch);
        if (structure instanceof IBranchStructureExtension) {
            sourceOrientation = ((IBranchStructureExtension)structure).getSourceOrientation(branch);
        }
        connections.setSourceOrientation((IFigure)figure, sourceOrientation);
        connections.setSourceExpansion((IFigure)figure, this.getSourceExpansion(branch, ss, sourceOrientation, connections.getLineWidth(), connections.getId()));
        connections.setTapered((IFigure)figure, StyleUtils.isBranchLineTapered(branch, ss));
        connections.setCornerSize((IFigure)figure, StyleUtils.getInteger(branch, ss, "line-corner", newConnectionId, 5));
        List<IBranchPart> subBranches = branch.getSubBranches();
        int i = 0;
        while (i < subBranches.size()) {
            IBranchPart subBranch = subBranches.get(i);
            Object connection = connections.getDecoration(i);
            if (!StyleUtils.isSameDecoration(connection, newConnectionId)) {
                connection = StyleUtils.createBranchConnection(branch, newConnectionId);
                connections.setDecoration((IFigure)figure, i, (IDecoration)connection);
            }
            if (connection != null && connection instanceof IBranchConnectionDecoration) {
                this.decorateConnection(branch, ss, figure, subBranch, (IBranchConnectionDecoration)connection, i, connections, ignoreVisibility);
            }
            ++i;
        }
    }

    private int getSourceExpansion(IBranchPart branch, IStyleSelector ss, int sourceOrientation, int lineWidth, String decorationId) {
        if (sourceOrientation == 0) {
            return 0;
        }
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null && plusMinus.getFigure().isVisible()) {
            Dimension size = plusMinus.getFigure().getPreferredSize();
            return Math.max(size.width, size.height) + lineWidth + 1;
        }
        int spacing = StyleUtils.getInteger(branch, ss, "spacing-major", decorationId, -1);
        if (spacing >= 0) {
            return spacing / 2;
        }
        return 7 + lineWidth;
    }

    private void decorateConnection(IBranchPart branch, IStyleSelector ss, BranchFigure figure, IBranchPart subBranch, IBranchConnectionDecoration connection, int subBranchIndex, IBranchConnections connections, boolean ignoreVisibility) {
        IAnchor targetAnchor = null;
        ITopicPart subTopic = subBranch.getTopicPart();
        if (subTopic instanceof INodePart) {
            targetAnchor = ((INodePart)((Object)subTopic)).getTargetAnchor(branch);
        }
        connection.setTargetAnchor((IFigure)figure, targetAnchor);
        int targetOrientation = 0;
        IStructure structure = branch.getBranchPolicy().getStructure(branch);
        if (structure instanceof IBranchStructureExtension) {
            targetOrientation = ((IBranchStructureExtension)structure).getChildTargetOrientation(branch, subBranch);
        }
        connection.setTargetOrientation((IFigure)figure, targetOrientation);
        connection.setTargetExpansion((IFigure)figure, 0);
        connection.setLineColor((IFigure)figure, StyleUtils.getBranchConnectionColor(branch, ss, subBranch, subBranchIndex, connections.getLineColor()));
        if (!ignoreVisibility) {
            connection.setVisible((IFigure)figure, connection.getSourceAnchor() != null && connection.getTargetAnchor() != null && figure.isVisible() && !figure.isFolded());
        }
    }

    public static BranchDecorator getInstanceo() {
        return instanceo;
    }
}

