/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.swt.graphics.Color;
import org.xmind.core.ITitled;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.decorators.TitleTextDecorator;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.style.StyleUtils;

public class BoundaryTitleTextDecorator
extends TitleTextDecorator {
    private static final BoundaryTitleTextDecorator instance = new BoundaryTitleTextDecorator();

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setBorder((Border)new LineBorder());
        figure.setOpaque(true);
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
    }

    protected String getUntitledText(IGraphicalPart part, ITitled titled) {
        return MindMapMessages.TitleText_Boundary;
    }

    protected void decorateTextFigure(IGraphicalPart ownerPart, IStyleSelector ss, ITextFigure figure) {
        super.decorateTextFigure(ownerPart, ss, figure);
        String decorationId = StyleUtils.getString(ownerPart, ss, "shape-class", "org.xmind.boundaryShape.rect");
        figure.setBackgroundColor(this.getFillColor(ownerPart, ss, decorationId));
        LineBorder border = (LineBorder)figure.getBorder();
        Color oldLineColor = border.getColor();
        Color newLineColor = this.getLineColor(ownerPart, ss, decorationId);
        if (!newLineColor.equals((Object)oldLineColor)) {
            border.setColor(newLineColor);
            figure.repaint();
        }
        int oldLineWidth = border.getWidth();
        int newLineWidth = this.getLineWidth(ownerPart, ss, decorationId);
        if (newLineWidth != oldLineWidth) {
            border.setWidth(newLineWidth);
            figure.revalidate();
            figure.repaint();
        }
    }

    private int getLineWidth(IGraphicalPart part, IStyleSelector ss, String decorationId) {
        return StyleUtils.getInteger(part, ss, "line-width", decorationId, 3);
    }

    protected Color getLineColor(IGraphicalPart part, IStyleSelector ss, String decorationId) {
        return StyleUtils.getColor(part, ss, "line-color", decorationId, "#afafaf");
    }

    protected Color getFillColor(IGraphicalPart part, IStyleSelector ss, String decorationId) {
        return StyleUtils.getColor(part, ss, "svg:fill", decorationId, "#ffffff");
    }

    protected IGraphicalPart getOwnerPart(IGraphicalPart part) {
        if (part.getParent() instanceof IBoundaryPart) {
            return (IBoundaryPart)part.getParent();
        }
        return super.getOwnerPart(part);
    }

    public static BoundaryTitleTextDecorator getInstance() {
        return instance;
    }
}

