/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBranchConnection;

public class ElbowBranchConnection
extends AbstractBranchConnection {
    protected PrecisionPoint elbow = null;
    protected PrecisionPoint s1 = new PrecisionPoint();
    protected PrecisionPoint s2 = new PrecisionPoint();
    protected PrecisionPoint t1 = new PrecisionPoint();
    protected PrecisionPoint t2 = new PrecisionPoint();
    protected PrecisionPoint e1 = new PrecisionPoint();
    protected PrecisionPoint e2 = new PrecisionPoint();
    protected boolean horizontal = false;
    protected boolean vertical = false;

    public ElbowBranchConnection() {
    }

    public ElbowBranchConnection(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        if (this.isTapered()) {
            if (this.horizontal || this.vertical) {
                if (this.horizontal && this.vertical) {
                    shape.moveTo(sp);
                    shape.lineTo((float)sp.x, (float)tp.y);
                    shape.lineTo(tp);
                    shape.lineTo((float)tp.x, (float)sp.y);
                    shape.close();
                } else {
                    shape.moveTo(this.s1);
                    shape.lineTo(this.t1);
                    shape.lineTo(this.t2);
                    shape.lineTo(this.s2);
                    shape.close();
                }
            } else {
                shape.moveTo(this.s1);
                shape.lineTo(this.e1);
                shape.lineTo(this.t1);
                shape.lineTo(this.t2);
                shape.lineTo(this.e2);
                shape.lineTo(this.s2);
                shape.close();
            }
        } else {
            shape.moveTo(sp);
            shape.lineTo(this.elbow);
            shape.lineTo(tp);
        }
    }

    protected void calculateControlPoints(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos) {
        this.elbow = new PrecisionPoint();
        boolean targetHorizontal = this.isTargetHorizontal();
        this.calcElbow(sourcePos, targetPos, targetHorizontal, this.elbow);
        if (this.isTapered()) {
            double lineWidth = this.getLineWidth();
            this.horizontal = Math.abs(sourcePos.y - targetPos.y) < lineWidth;
            boolean bl = this.vertical = Math.abs(sourcePos.x - targetPos.x) < lineWidth;
            if (this.horizontal || this.vertical) {
                if (!this.horizontal || !this.vertical) {
                    if (this.horizontal) {
                        this.e1.setLocation(sourcePos.x, (sourcePos.y + targetPos.y) / 2.0);
                        this.e2.setLocation(targetPos.x, this.e1.y);
                    } else if (this.vertical) {
                        this.e1.setLocation((sourcePos.x + targetPos.x) / 2.0, sourcePos.x);
                        this.e2.setLocation(this.e1.x, targetPos.y);
                    }
                    this.calcTaperedPositions(this.e1, this.e2, 0.0, 1.0, this.s1, this.s2);
                    this.calcTaperedPositions(this.e1, this.e2, 1.0, 1.0, this.t1, this.t2);
                }
            } else {
                this.calcTaperedPositions(sourcePos, this.elbow, 0.0, this.s1, this.s2);
                this.calcTaperedPositions(this.elbow, targetPos, 1.0, 1.0, this.t1, this.t2);
                this.calcElbow(this.s1, this.t1, targetHorizontal, this.e1);
                this.calcElbow(this.s2, this.t2, targetHorizontal, this.e2);
            }
        }
    }

    protected boolean isPositionValid() {
        return super.isPositionValid() && this.elbow != null;
    }

    public void invalidate() {
        super.invalidate();
        this.elbow = null;
    }

    protected boolean isTargetHorizontal() {
        return (this.getTargetOrientation() & 0x18) != 0;
    }

    protected PrecisionPoint calcElbow(PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean targetHorizontal, PrecisionPoint result) {
        return result.setLocation(targetHorizontal ? sourcePos.x : targetPos.x, targetHorizontal ? targetPos.y : sourcePos.y);
    }
}

