/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.decorations.IDecorationFactory;
import org.xmind.ui.decorations.IDecorationManager;
import org.xmind.ui.internal.decorations.DecorationCategory;
import org.xmind.ui.internal.decorations.DecorationDescriptor;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationManager
extends RegistryReader
implements IDecorationManager,
IDecorationFactory {
    private static final List<IDecorationDescriptor> NO_DESCRIPTORS = Collections.emptyList();
    private Map<String, DecorationDescriptor> decorationDescriptors = null;
    private List<DecorationCategory> categories = null;
    private Map<String, List<IDecorationDescriptor>> categoriedDescriptors = null;

    @Override
    public IDecoration createDecoration(String decorationId, IGraphicalPart part) {
        if (part == null || decorationId == null) {
            return null;
        }
        this.ensureLoaded();
        DecorationDescriptor factory = this.decorationDescriptors.get(decorationId);
        return factory == null ? null : factory.createDecoration(decorationId, part);
    }

    @Override
    public IDecorationDescriptor getDecorationDescriptor(String decorationId) {
        this.ensureLoaded();
        return this.decorationDescriptors.get(decorationId);
    }

    @Override
    public List<IDecorationDescriptor> getDescriptors(String categoryId) {
        this.ensureLoaded();
        List<IDecorationDescriptor> list = this.categoriedDescriptors.get(categoryId);
        return list == null ? NO_DESCRIPTORS : list;
    }

    public Collection<DecorationCategory> getCategories() {
        this.ensureLoaded();
        return this.categories;
    }

    private void ensureLoaded() {
        if (this.categories != null && this.categoriedDescriptors != null && this.decorationDescriptors != null) {
            return;
        }
        this.lazyLoad();
        if (this.categoriedDescriptors == null) {
            this.categoriedDescriptors = Collections.emptyMap();
        }
        if (this.decorationDescriptors == null) {
            this.decorationDescriptors = Collections.emptyMap();
        }
        if (this.categories == null) {
            this.categories = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        if (Platform.isRunning()) {
            this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "decorations");
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("decoration".equals(name)) {
            this.readDecoration(element);
            this.readElementChildren(element);
            return true;
        }
        if ("category".equals(name)) {
            this.readCategory(element);
            this.readElementChildren(element);
            return true;
        }
        if ("class".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("factory".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("defaultValue".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        return false;
    }

    private void readCategory(IConfigurationElement element) {
        DecorationCategory category = new DecorationCategory(element);
        this.registerCategory(category);
    }

    private void readDecoration(IConfigurationElement element) {
        try {
            DecorationDescriptor desc = new DecorationDescriptor(element);
            this.registerDecoration(desc);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load decoration: " + element);
        }
    }

    private void registerDecoration(DecorationDescriptor desc) {
        String id = desc.getId();
        if (this.decorationDescriptors == null) {
            this.decorationDescriptors = new HashMap<String, DecorationDescriptor>();
        }
        this.decorationDescriptors.put(id, desc);
        String categoryId = desc.getCategoryId();
        if (categoryId != null && !"".equals(categoryId)) {
            List<IDecorationDescriptor> list;
            if (this.categoriedDescriptors == null) {
                this.categoriedDescriptors = new HashMap<String, List<IDecorationDescriptor>>();
            }
            if ((list = this.categoriedDescriptors.get(categoryId)) == null) {
                list = new ArrayList<IDecorationDescriptor>();
                this.categoriedDescriptors.put(categoryId, list);
            }
            list.add(desc);
        }
    }

    private void registerCategory(DecorationCategory category) {
        if (this.categories == null) {
            this.categories = new ArrayList<DecorationCategory>();
        }
        this.categories.add(category);
    }
}

