/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleValueProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.decorations.IDecorationFactory;
import org.xmind.ui.util.Logger;

public class DecorationDescriptor
implements IDecorationDescriptor,
IDecorationFactory,
IStyleValueProvider {
    private IConfigurationElement element;
    private IConfigurationElement classElement;
    private IConfigurationElement factoryElement;
    private IDecorationFactory contributedFactory;
    private boolean triedLoadingContributedFacotry;
    private boolean failedCreatingDecoration;
    private String id;
    private String name;
    private String categoryId;
    private ImageDescriptor icon;
    private Map<String, String> defaultValues;

    DecorationDescriptor(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        this.categoryId = element.getAttribute("categoryId");
        this.name = element.getAttribute("name");
        this.loadClassElement();
        this.loadFactoryElement();
        if (this.classElement == null && this.factoryElement == null || !this.hasClassAttribute()) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
        this.loadDefaultValues();
    }

    private boolean hasClassAttribute() {
        if (this.classElement != null && this.classElement.getAttribute("class") != null) {
            return true;
        }
        return this.factoryElement != null && this.factoryElement.getAttribute("class") != null;
    }

    private void loadClassElement() {
        IConfigurationElement[] children = this.element.getChildren("class");
        if (children.length == 0) {
            return;
        }
        this.classElement = children[0];
    }

    private void loadFactoryElement() {
        IConfigurationElement[] children = this.element.getChildren("factory");
        if (children.length == 0) {
            return;
        }
        this.factoryElement = children[0];
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    private ImageDescriptor createIcon() {
        String iconName = this.element.getAttribute("icon");
        if (iconName != null) {
            String plugId = this.element.getNamespaceIdentifier();
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)plugId, (String)iconName);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    private IDecorationFactory getContributedFactory() {
        if (this.factoryElement == null) {
            return null;
        }
        if (this.contributedFactory == null && !this.triedLoadingContributedFacotry) {
            try {
                this.contributedFactory = (IDecorationFactory)this.factoryElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create decoration factory: " + this.id);
            }
            this.triedLoadingContributedFacotry = true;
        }
        return this.contributedFactory;
    }

    public IDecoration createDecoration(String id, IGraphicalPart part) {
        IDecoration decoration = null;
        IDecorationFactory factory = this.getContributedFactory();
        if (factory != null) {
            decoration = factory.createDecoration(id, part);
        }
        if (decoration == null) {
            decoration = this.createDecoration();
        }
        if (decoration != null) {
            decoration.setId(id);
        }
        return decoration;
    }

    private IDecoration createDecoration() {
        if (this.failedCreatingDecoration || this.classElement == null) {
            return null;
        }
        try {
            return (IDecoration)this.classElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            this.failedCreatingDecoration = true;
            Logger.log(e, "Failed to create decoration: " + this.id);
            return null;
        }
    }

    private void loadDefaultValues() {
        IConfigurationElement[] children = this.element.getChildren("defaultValue");
        if (children.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String key = child.getAttribute("key");
            if (key != null) {
                String value = child.getAttribute("value");
                if (this.defaultValues == null) {
                    this.defaultValues = new HashMap<String, String>();
                }
                this.defaultValues.put(key, value);
            }
            ++n2;
        }
    }

    public IStyleValueProvider getDefaultValueProvider(String key) {
        if (this.defaultValues != null && this.defaultValues.containsKey(key)) {
            return this;
        }
        return null;
    }

    public String getValue(IGraphicalPart part, String key) {
        if (this.defaultValues != null) {
            return this.defaultValues.get(key);
        }
        return null;
    }

    public boolean isKeyInteresting(IGraphicalPart part, String key) {
        if (this.defaultValues != null) {
            return this.defaultValues.containsKey(key);
        }
        return false;
    }
}

