/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.internal.branch.BaseRadialStructure;
import org.xmind.ui.internal.branch.RadialData;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISummaryPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadialStructure
extends BaseRadialStructure {
    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        BaseRadialStructure.RadiationInsertion insertion = this.getCurrentInsertion(branch);
        int insHeight = insertion == null ? 0 : insertion.getSize().height;
        int y = -cache.getRightSumSpacing() / 2;
        if (insertion != null && insertion.right) {
            y -= insHeight / 2;
        }
        Point ref = info.getReference();
        int i = 0;
        while (i < num) {
            Rectangle r;
            if (i == numRight) {
                y = -cache.getLeftSumSpacing() / 2;
                if (insertion != null && !insertion.right) {
                    y -= insHeight / 2;
                }
                right = false;
            }
            if (!(insertion == null || i != insertion.getIndex() || i == numRight && insertion.right)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y += insHeight;
            }
            IBranchPart subBranch = subBranches.get(i);
            Dimension offset = this.getOffset(subBranch);
            IFigure subFigure = subBranch.getFigure();
            if (offset != null && subFigure instanceof IReferencedFigure) {
                Point subRef = ref.getTranslated(offset);
                r = ((IReferencedFigure)subFigure).getPreferredBounds(subRef);
            } else {
                int x = cache.getX(y, right);
                Point subRef = ref.getTranslated(x, y);
                r = RadialUtils.getPrefBounds(subBranch, subRef, right);
            }
            info.put(subFigure, r);
            y += childrenSpacings[i];
            if (insertion != null && (i == numRight - 1 && insertion.getIndex() == numRight && insertion.right || i == num)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y += insHeight;
            }
            ++i;
        }
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate up".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential) {
            if ("navigate right".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() >= numFirst) {
                    return branch.getTopicPart();
                }
            } else if ("navigate left".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() < numFirst) {
                    return branch.getTopicPart();
                }
            }
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return super.getSummaryDirection(branch, summary);
    }
}

