/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.xmind.core.IBoundary;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ICacheValueProvider;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingMapBranchHook
implements IBranchHook,
FigureListener,
ICoreEventListener {
    IBranchPart branch;
    private List<ICoreEventRegistration> topicListeners = new ArrayList<ICoreEventRegistration>();
    private Map<Object, List<ICoreEventRegistration>> rangeListeners = new HashMap<Object, List<ICoreEventRegistration>>();

    public void figureMoved(IFigure source) {
        if (this.needUpdate()) {
            this.branch.getBranchPolicy().flushStructureCache(this.branch, true, true);
            this.findTopBranch(this.branch, this.branch.getBranchPolicyId()).treeUpdate(false);
        }
    }

    private IBranchPart findTopBranch(IBranchPart branch, String policyId) {
        String parentId;
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && policyId.equals(parentId = parent.getBranchPolicyId())) {
            return this.findTopBranch(parent, policyId);
        }
        return branch;
    }

    private boolean needUpdate() {
        String oldValue = (String)MindMapUtils.getCache((IPart)this.branch, "org.xmind.ui.branchCache.structureId");
        String newValue = this.calcStructureId(this.branch);
        if (newValue == null) {
            return false;
        }
        return !newValue.equals(oldValue);
    }

    private String calcStructureId(IBranchPart branch) {
        Object value;
        ICacheValueProvider valueProvider = MindMapUtils.getCacheManager((IPart)branch).getValueProvider("org.xmind.ui.branchCache.structureId");
        if (valueProvider != null && (value = valueProvider.getValue((IPart)branch, "org.xmind.ui.branchCache.structureId")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public void hook(IBranchPart branch) {
        this.branch = branch;
        branch.getFigure().addFigureListener((FigureListener)this);
        if ("floatingBranch".equals(branch.getBranchType())) {
            ITopic topic = branch.getTopic();
            if (topic instanceof ICoreEventSource) {
                ICoreEventSource source = (ICoreEventSource)topic;
                this.topicListeners.add(source.registerCoreEventListener("boundaryAdd", (ICoreEventListener)this));
                this.topicListeners.add(source.registerCoreEventListener("boundaryRemove", (ICoreEventListener)this));
                this.topicListeners.add(source.registerCoreEventListener("summaryAdd", (ICoreEventListener)this));
                this.topicListeners.add(source.registerCoreEventListener("summaryRemove", (ICoreEventListener)this));
            }
            for (IBoundary boundary : topic.getBoundaries()) {
                this.registerRangeListeners(boundary);
            }
            for (ISummary summary : topic.getSummaries()) {
                this.registerRangeListeners(summary);
            }
        }
    }

    @Override
    public void unhook(IBranchPart branch) {
        branch.getFigure().removeFigureListener((FigureListener)this);
        this.unregister(this.topicListeners);
        for (List<ICoreEventRegistration> regs : this.rangeListeners.values()) {
            this.unregister(regs);
        }
    }

    private void unregister(List<ICoreEventRegistration> listeners) {
        for (ICoreEventRegistration reg : listeners) {
            reg.unregister();
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("boundaryAdd".equals(type) || "summaryAdd".equals(type)) {
            Object range = event.getTarget();
            this.registerRangeListeners(range);
        } else if ("boundaryRemove".equals(type) || "summaryRemove".equals(type)) {
            Object range = event.getTarget();
            List<ICoreEventRegistration> list = this.rangeListeners.remove(range);
            if (list != null) {
                this.unregister(list);
            }
        } else if ("startIndex".equals(type) || "endIndex".equals(type)) {
            this.branch.getFigure().invalidate();
            this.branch.treeUpdate(true);
        }
    }

    private void registerRangeListeners(Object range) {
        if (range instanceof ICoreEventSource) {
            ICoreEventSource source = (ICoreEventSource)range;
            ArrayList<ICoreEventRegistration> list = new ArrayList<ICoreEventRegistration>();
            list.add(source.registerCoreEventListener("startIndex", (ICoreEventListener)this));
            list.add(source.registerCoreEventListener("endIndex", (ICoreEventListener)this));
            this.rangeListeners.put(range, list);
        }
    }
}

