/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.print.PageSetupDialog;
import org.xmind.ui.internal.print.PrintClient;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;

public class PrintMapAction
extends PageAction {
    public PrintMapAction(IGraphicalEditorPage page) {
        super(ActionFactory.PRINT.getId(), page);
    }

    public void run() {
        PrintDialog printDialog;
        PrinterData printerData;
        IGraphicalEditor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        IGraphicalEditorPage page = this.getPage();
        if (page == null) {
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null || !(viewer instanceof IMindMapViewer)) {
            return;
        }
        IMindMapViewer mmv = (IMindMapViewer)viewer;
        IMindMap mindMap = mmv.getMindMap();
        if (mindMap == null) {
            return;
        }
        Shell parentShell = editor.getSite().getShell();
        if (parentShell == null || parentShell.isDisposed()) {
            return;
        }
        PageSetupDialog pageSetupDialog = new PageSetupDialog(parentShell, editor, page, mmv, mindMap);
        do {
            int open;
            if ((open = pageSetupDialog.open()) != 1) continue;
            return;
        } while ((printerData = (printDialog = new PrintDialog(parentShell)).open()) == null);
        this.print(printerData, pageSetupDialog.getSettings(), mindMap, parentShell);
    }

    private void print(PrinterData printerData, IDialogSettings settings, final IMindMap source, Shell parentShell) {
        final PrintClient client = new PrintClient(source.getCentralTopic().getTitleText(), parentShell, printerData, settings);
        Display display = parentShell.getDisplay();
        try {
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    client.print(source);
                }
            });
        }
        finally {
            client.dispose();
        }
    }
}

