/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.ui.mindmap.IEditPolicyManager;
import org.xmind.ui.util.Logger;

public class EditPolicyManager
extends RegistryReader
implements IEditPolicyManager {
    private Map<String, EditPolicyDescriptor> descriptors = null;

    public IEditPolicy getEditPolicy(String editPolicyId) {
        EditPolicyDescriptor descriptor = this.getDescriptor(editPolicyId);
        if (descriptor != null) {
            return descriptor.getPolicy();
        }
        return NullEditPolicy.getInstance();
    }

    private EditPolicyDescriptor getDescriptor(String editPolicyId) {
        this.ensureLoaded();
        return this.descriptors.get(editPolicyId);
    }

    private void ensureLoaded() {
        if (this.descriptors != null) {
            return;
        }
        this.lazyLoad();
        if (this.descriptors == null) {
            this.descriptors = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        if (!Platform.isRunning()) {
            return;
        }
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "editPolicies");
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("editPolicy".equals(name)) {
            this.readEditPolicy(element);
            return true;
        }
        return false;
    }

    private void readEditPolicy(IConfigurationElement element) {
        EditPolicyDescriptor descriptor;
        try {
            descriptor = new EditPolicyDescriptor(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load edit policy: " + element);
            return;
        }
        String id = descriptor.getId();
        if (id == null) {
            return;
        }
        if (this.descriptors == null) {
            this.descriptors = new HashMap<String, EditPolicyDescriptor>();
        }
        this.descriptors.put(id, descriptor);
    }

    private static class EditPolicyDescriptor {
        private IConfigurationElement element;
        private String id;
        private IEditPolicy policy;

        public EditPolicyDescriptor(IConfigurationElement element) throws CoreException {
            this.element = element;
            this.id = element.getAttribute("id");
            if (RegistryReader.getClassValue((IConfigurationElement)element, (String)"class") == null) {
                throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
            }
        }

        public String getId() {
            return this.id;
        }

        public IEditPolicy getPolicy() {
            if (this.policy == null) {
                this.policy = this.createPolicy();
            }
            return this.policy;
        }

        private IEditPolicy createPolicy() {
            try {
                return (IEditPolicy)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create edit policy: " + this.id);
                return NullEditPolicy.getInstance();
            }
        }
    }
}

